/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.util;

import com.humuson.tms.mapper.util.BASE64;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BASE64EncodeOutputStream
extends BufferedOutputStream {
    private byte[] ENC_SRC_BUFFER;
    private byte[] ENC_TARGET_BUFFER;
    private int ENC_SRC_BUFFER_SIZE;
    private int WRITE_COUNT;
    private int BYTES_PER_LINE;

    private void init(int i) {
        this.ENC_SRC_BUFFER = new byte[3];
        this.ENC_TARGET_BUFFER = new byte[4];
        this.BYTES_PER_LINE = i;
    }

    public BASE64EncodeOutputStream(OutputStream out) {
        this(out, 76);
    }

    public BASE64EncodeOutputStream(OutputStream out, int buffer) {
        super(out, buffer + 2);
        this.init(buffer);
    }

    @Override
    public void write(byte[] source, int i, int j) throws IOException {
        for (int k = 0; k < j; ++k) {
            this.write(source[i + k]);
        }
    }

    @Override
    public void write(byte[] source) throws IOException {
        this.write(source, 0, source.length);
    }

    @Override
    public void write(int i) throws IOException {
        this.ENC_SRC_BUFFER[this.ENC_SRC_BUFFER_SIZE++] = (byte)i;
        if (this.ENC_SRC_BUFFER_SIZE == 3) {
            this.encode();
            this.ENC_SRC_BUFFER_SIZE = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.ENC_SRC_BUFFER_SIZE > 0) {
            this.encode();
            this.ENC_SRC_BUFFER_SIZE = 0;
        }
        super.flush();
    }

    private void encode() throws IOException {
        if (this.WRITE_COUNT + 4 > this.BYTES_PER_LINE) {
            super.write(13);
            super.write(10);
            super.flush();
            this.WRITE_COUNT = 0;
        }
        BASE64.encode_sep(this.ENC_SRC_BUFFER, this.ENC_SRC_BUFFER_SIZE, this.ENC_TARGET_BUFFER);
        for (int i = 0; i < 4; ++i) {
            super.write(this.ENC_TARGET_BUFFER[i]);
        }
        this.WRITE_COUNT += 4;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

