/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.redis;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Column;
import com.humuson.tms.mapper.filter.Filter;
import com.humuson.tms.mapper.info.MapperInfo;
import com.humuson.tms.mapper.mapping.ContentMapping;
import com.humuson.tms.mapper.redis.RedisExecutor;
import com.humuson.tms.mapper.util.StringUtil;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultRedisExecutor
implements RedisExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedisExecutor.class);
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private ContentMapping contentMapping;
    @Autowired
    private Filter filter;
    @Value(value="${tms.daemon-type}")
    private String daemonType;
    @Value(value="${tms.daemon-id}")
    private String daemonId;

    @Override
    public void updateSproc(String state, String schdId, String targetSeq, String sendId, int cnt) throws Exception {
        String key = "SPROC:" + schdId;
        String field = schdId + ":" + targetSeq;
        try {
            String oldValue = this.wrapperRedisTemplate.hmget(key, field);
            if (oldValue == null) {
                oldValue = "";
            }
            if ("42".equals(state)) {
                String mpStart = "";
                mpStart = oldValue.indexOf("MP") == -1 ? this.daemonType + ":" + this.daemonId + ":" + "10" + ":" + DateUtil.getFullDateDefaultFormat() + ":" + cnt + "|" : mpStart + "|";
                oldValue = oldValue + mpStart + this.daemonType + ":" + this.daemonId + ":" + state + ":" + DateUtil.getFullDateDefaultFormat() + ":" + 0;
            } else {
                oldValue = oldValue + ("10".equals(state) ? "" : "|") + this.daemonType + ":" + this.daemonId + ":" + state + ":" + DateUtil.getFullDateDefaultFormat() + (cnt > -1 ? ":" + cnt : ":0");
            }
            this.wrapperRedisTemplate.hmset(key, field, oldValue);
            log.info("[END] SPROC UPDATE \uc644\ub8cc ===> sendId:[{}] state:[{}]  key:[{}]  field:[{}] cnt:[{}]", new Object[]{sendId, state, key, field, cnt});
        }
        catch (Exception e) {
            log.error("CM0201|Redis Hmset Fail:{}", (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<MapperInfo> getRedisData(String sendId, String schdId, String targetSeq) throws Exception {
        ArrayList<MapperInfo> totalList = new ArrayList<MapperInfo>();
        ArrayList<Map<String, Object>> targetList = new ArrayList<Map<String, Object>>();
        MapperInfo totalInfo = new MapperInfo();
        Map resInfoMap = new HashMap();
        Map targetListMap = new HashMap();
        Properties campProp = new Properties();
        String pinfoKey = "PINFO:" + schdId;
        try {
            resInfoMap = this.wrapperRedisTemplate.hgetAll(pinfoKey);
            campProp.putAll((Map<?, ?>)resInfoMap);
        }
        catch (Exception e) {
            log.error("CM0201|Redis hgetAll Fail :{}", (Object)e.getMessage());
            throw new Exception("[ERROR] Redis hgetAll :" + e);
        }
        String invalidError = this.filter.inValidCheck(campProp, sendId, schdId);
        if (invalidError != null && !invalidError.trim().isEmpty()) {
            throw new Exception("[ERROR] PINFO inValid Error. " + invalidError);
        }
        String tlistKey = "TLIST:" + schdId + ":" + targetSeq;
        try {
            targetListMap = this.wrapperRedisTemplate.hgetAll(tlistKey);
            Iterator iterTargetList = targetListMap.entrySet().iterator();
            Object obj = null;
            while (iterTargetList.hasNext()) {
                Map<String, String> targetMap = new HashMap();
                HashMap resTargetMap = new HashMap();
                Map.Entry entry = iterTargetList.next();
                if (StringUtil.isNull((String)entry.getValue())) {
                    log.warn("[WARN] TLIST : VALUE IS NULL Continue => sendId [{}] schdId [{}], targetSeq:[{}] key[{}]", new Object[]{sendId, schdId, targetSeq, entry.getKey()});
                    continue;
                }
                targetMap = JsonUtil.getMapFromJson((String)((String)entry.getValue()));
                targetMap.put(Column.FIELD_MEMBER_ID, (String)entry.getKey());
                resTargetMap.putAll(targetMap);
                targetList.add(resTargetMap);
            }
        }
        catch (Exception e) {
            log.error("CM0201|Redis hgetAll Fail tlistKey[{}] :{}", (Object)tlistKey, (Object)e.getMessage());
            throw new Exception("[ERROR] Redis hgetAll :" + e);
        }
        totalInfo.setCampProp(campProp);
        totalInfo.setTargetList(targetList);
        totalList.add(totalInfo);
        return totalList;
    }

    @Override
    public void updateHashMap(String key, Map<String, String> map) throws Exception {
        if (map.size() > 0) {
            try {
                this.wrapperRedisTemplate.hmsetAll(key, map);
            }
            catch (Exception e) {
                log.error("CM0201| Redis hmsetAll Error key[{}]:{}", (Object)key, (Object)e);
                throw new Exception("[ERROR] updateHashMap Fail : {}", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkStop(String key, String field) throws Exception {
        boolean res = false;
        try {
            String time = this.wrapperRedisTemplate.hmget(key, field);
            if (!StringUtil.isNull(time)) {
                res = true;
                return res;
            }
        }
        catch (Exception e) {
            log.error("CM0201| Redis hmget Error {}", (Throwable)e);
        }
        finally {
            return res;
        }
    }

    @Override
    public int updateTotalCrsltUser(List<MapperInfo> totalList, String sendId, String schdId, String targetSeq, String errorCode, String errorMsg) throws Exception {
        Properties campProp = totalList.get(0).getCampProp();
        List<Map<String, Object>> targetList = totalList.get(0).getTargetList();
        String channelType = (String)campProp.get(Column.CHANNEL_TYPE);
        String crsltKey = "CRSLT:" + channelType + ":" + DateUtil.getFullDate((String)"yyyyMMddHHmm");
        HashMap<String, String> afterCrsltMap = new HashMap<String, String>();
        Map<String, String> userCrsltMap = new HashMap<String, String>();
        int cnt = 0;
        for (Map<String, Object> userMap : targetList) {
            ++cnt;
            String memberId = String.valueOf(userMap.get(Column.FIELD_MEMBER_ID));
            String rsltJson = "";
            String cRsltField = sendId + ":" + schdId + ":" + targetSeq + ":" + memberId;
            if (!StringUtil.isNull((String)userMap.get(Column.STATUS))) {
                log.warn("[ERROR] updateTotalCrsltUser() user STATUS not null STATUS [{}]  member [{}]", userMap.get(Column.STATUS), (Object)memberId);
                userCrsltMap = this.contentMapping.putErrorCodeDetail((String)userMap.get(Column.STATUS), (String)userMap.get(Column.LOG_DETAIL), userCrsltMap);
            } else {
                userCrsltMap = this.contentMapping.putErrorCodeDetail(errorCode, errorMsg, userCrsltMap);
            }
            rsltJson = this.contentMapping.putCrsltJsonString(userMap, campProp, targetSeq, userCrsltMap);
            afterCrsltMap.put(cRsltField, rsltJson);
            this.updateHashMap(crsltKey, afterCrsltMap);
        }
        return cnt;
    }
}

