/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.mq;

import com.humuson.tms.config.Constants;
import com.humuson.tms.mapper.ContentConvert;
import com.humuson.tms.mapper.filter.MapperSkipper;
import com.humuson.tms.mapper.scheduler.CheckLiveScheduler;
import com.humuson.tms.mapper.util.LockCheckerUtil;
import com.humuson.tms.monitor.feasibility.WatcherHttpCallParser;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MQConsumer
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(MQConsumer.class);
    @Autowired
    private ContentConvert convertContent;
    @Autowired
    private MapperSkipper mapperSkipper;
    @Autowired
    WatcherHttpCallParser watcher;
    @Autowired
    LockCheckerUtil lockCheckerUtil;
    @Autowired
    private CheckLiveScheduler checkLiveScheduler;
    @Value(value="${wt.hdd-check-use-yn:N}")
    private String wtHddCheckUseYn;
    @Value(value="${mapper.memory-check.use-yn:Y}")
    private String mpMemoryCheckUseYn;

    public void onMessage(Message message) {
        String str = "";
        try {
            str = ((TextMessage)message).getText();
            String destination = message.getJMSDestination().toString().replaceAll("queue://", "");
            log.info("[MQ Consumer]  destinationName : {}, message : {}, Priority : {}", new Object[]{destination, str, message.getJMSPriority()});
            if ("Y".equals(this.wtHddCheckUseYn)) {
                this.watcher.callWatcher(Constants.JobName.MAPPING);
                if (!this.watcher.isOk()) {
                    this.mapperSkipper.skip("WT", destination, str);
                    return;
                }
            }
            if ("Y".equals(this.mpMemoryCheckUseYn) && this.checkLiveScheduler.isCheckMemory()) {
                this.mapperSkipper.skip("MEMORY", destination, str);
                return;
            }
            String lockResult = this.lockCheckerUtil.isAnyLocked();
            if (lockResult != null && !lockResult.trim().isEmpty()) {
                log.info("[SCHEDULER] {}", (Object)lockResult);
                this.mapperSkipper.skip("", destination, str);
                return;
            }
            this.convertContent.execute(str);
        }
        catch (JMSException e) {
            log.error("[ERROR] MQConsumer message : {} error:{}", (Object)str, (Object)e);
        }
        catch (Exception e1) {
            log.error("[ERROR] MQConsumer message : {} error:{}", (Object)str, (Object)e1);
        }
    }
}

