/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.mq;

import com.humuson.tms.adaptor.activemq.ActiveMQSender;
import com.humuson.tms.adaptor.activemq.ActivemqConnectorConfig;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.mapper.db.MapperDao;
import com.humuson.tms.mapper.mq.MQProducer;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent
public class DefaultMQProducer
implements MQProducer {
    private static final Logger log = LoggerFactory.getLogger(DefaultMQProducer.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private MapperDao mapperDao;
    @Autowired
    @Qualifier(value="activemq-sender")
    private ActiveMQSender activeMQsender;
    @Value(value="${spring.activemq.mapper.auto.producer.name.em2}")
    private String mqAutoProducerNameEm2;
    @Value(value="${spring.activemq.mapper.mass.producer.name.em2}")
    private String mqMassProducerNameEm2;
    @Value(value="${spring.activemq.mapper.auto.producer.name.em}")
    private String mqAutoProducerNameEm;
    @Value(value="${spring.activemq.mapper.auto.producer.name.sm}")
    private String mqAutoProducerNameSm;
    @Value(value="${spring.activemq.mapper.auto.producer.name.pu}")
    private String mqAutoProducerNamePu;
    @Value(value="${spring.activemq.mapper.auto.producer.name.ka}")
    private String mqAutoProducerNameKa;
    @Value(value="${spring.activemq.mapper.mass.producer.name.em}")
    private String mqMassProducerNameEm;
    @Value(value="${spring.activemq.mapper.mass.producer.name.sm}")
    private String mqMassProducerNameSm;
    @Value(value="${spring.activemq.mapper.mass.producer.name.pu}")
    private String mqMassProducerNamePu;
    @Value(value="${spring.activemq.mapper.mass.producer.name.ka}")
    private String mqMassProducerNameKa;

    @Override
    public void send(Properties campProp, String message) throws Exception {
        String campType = campProp.getProperty(Column.CAMP_TYPE, "M");
        String[] channelType = campProp.getProperty(Column.CHANNEL_TYPE, "EM");
        String mqProducerNamefinal = "";
        String sendId = "";
        if (campProp.containsKey(Column.SEND_ID)) {
            sendId = campProp.getProperty(Column.SEND_ID);
        }
        if (sendId == "" || sendId == null) {
            return;
        }
        String resultMqProducer = "";
        if (Constants.CampType.A.name().equalsIgnoreCase(campType)) {
            resultMqProducer = this.mqAutoProducerNameEm;
        } else if (Constants.CampType.M.name().equalsIgnoreCase(campType) || Constants.CampType.T.name().equalsIgnoreCase(campType)) {
            resultMqProducer = this.mqMassProducerNameEm;
        }
        HashMap<String, Object> testInfo = this.mapperDao.getTestInfo(sendId);
        String redisSdValue = "";
        String redisIdValue = "";
        String cType = String.valueOf(testInfo.get("CAMP_TYPE"));
        String dbRegId = String.valueOf(testInfo.get("REG_ID"));
        if ("EM".equals(channelType)) {
            if ("A".equals(cType)) {
                String[] sdValues;
                try {
                    redisSdValue = this.wrapperRedisTemplate.hmget("REGID", "SD");
                }
                catch (Exception e) {
                    log.error("get REGID SD value error :: ", (Throwable)e);
                }
                for (String sdValue : sdValues = redisSdValue.split("\\".concat("|"))) {
                    if (!sendId.equals(sdValue)) continue;
                    resultMqProducer = this.mqAutoProducerNameEm2;
                }
            } else {
                String[] idValues;
                try {
                    redisIdValue = this.wrapperRedisTemplate.hmget("REGID", "ID");
                }
                catch (Exception e) {
                    log.error("get REGID ID value error :: ", (Throwable)e);
                }
                for (String idValue : idValues = redisIdValue.split("\\".concat("|"))) {
                    if (!dbRegId.equals(idValue)) continue;
                    resultMqProducer = this.mqMassProducerNameEm2;
                }
            }
        }
        try {
            if (Constants.CampType.A.name().equalsIgnoreCase(campType)) {
                switch (channelType) {
                    case "PU": {
                        mqProducerNamefinal = this.mqAutoProducerNamePu;
                        break;
                    }
                    case "SM": {
                        mqProducerNamefinal = this.mqAutoProducerNameSm;
                        break;
                    }
                    case "KA": {
                        mqProducerNamefinal = this.mqAutoProducerNameKa;
                        break;
                    }
                    default: {
                        mqProducerNamefinal = resultMqProducer;
                        break;
                    }
                }
            } else if (Constants.CampType.M.name().equalsIgnoreCase(campType) || Constants.CampType.T.name().equalsIgnoreCase(campType)) {
                switch (channelType) {
                    case "PU": {
                        mqProducerNamefinal = this.mqMassProducerNamePu;
                        break;
                    }
                    case "SM": {
                        mqProducerNamefinal = this.mqMassProducerNameSm;
                        break;
                    }
                    case "KA": {
                        mqProducerNamefinal = this.mqMassProducerNameKa;
                        break;
                    }
                    default: {
                        mqProducerNamefinal = resultMqProducer;
                    }
                }
            }
            int priority = 4;
            if (campProp.containsKey(Column.MQ_PRIORITY)) {
                priority = Integer.parseInt(campProp.getProperty(Column.MQ_PRIORITY, "4"));
            }
            ActivemqConnectorConfig config = this.activeMQsender.getactiveMQSenderConfig();
            config.jmsTemplate().setExplicitQosEnabled(true);
            config.jmsTemplate().setPriority(priority);
            config.jmsTemplate().afterPropertiesSet();
            this.activeMQsender.setactiveMQSenderConfig(config);
            this.activeMQsender.send(mqProducerNamefinal, message);
            log.info("MQ::[produce] SEND ===== queue:{}, message:{}, priority:{}", new Object[]{mqProducerNamefinal, message, priority});
        }
        catch (Exception e) {
            log.error("[ERROR] MQProducer => Send ActiveMQ Fail:" + e);
            throw new Exception("[ERROR] MQProducer => Send ActiveMQ Fail:" + e);
        }
    }

    public void send(String destination, String message) throws Exception {
        this.activeMQsender.send(destination, message);
    }
}

