/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.mapping;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.DBTypeDetector;
import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.config.ChannelType;
import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.mapper.body.SourceAdd;
import com.humuson.tms.mapper.content.ContentReadWrite;
import com.humuson.tms.mapper.db.BatchExecutor;
import com.humuson.tms.mapper.db.MapperDao;
import com.humuson.tms.mapper.encdec.EncryptDecrypter;
import com.humuson.tms.mapper.filter.Filter;
import com.humuson.tms.mapper.info.ConnectInfo;
import com.humuson.tms.mapper.info.KeyValueInfo;
import com.humuson.tms.mapper.info.MapperInfo;
import com.humuson.tms.mapper.info.MappingInfo;
import com.humuson.tms.mapper.mapping.ContentMapping;
import com.humuson.tms.mapper.mq.MQProducer;
import com.humuson.tms.mapper.redis.RedisExecutor;
import com.humuson.tms.mapper.util.StringConvertUtil;
import com.humuson.tms.mapper.util.StringUtil;
import com.humuson.tms.mapper.util.eMsStringWriter;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.date.DateUtil;
import com.humuson.tms.util.net.HttpUtil;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent
public class DefaultContentMapping
implements ContentMapping {
    private static final Logger log = LoggerFactory.getLogger(DefaultContentMapping.class);
    @Autowired
    private MapperDao mapperDao;
    @Autowired
    public Filter filter;
    @Autowired
    private RedisExecutor redisExecutor;
    @Autowired
    private BatchExecutor batchExcutor;
    @Autowired
    private MQProducer mqProducer;
    @Autowired
    private EncryptDecrypter encryptDecrypter;
    @Autowired
    private SourceAdd sourceAdd;
    @Autowired
    private ContentReadWrite contentReadWrite;
    @Value(value="${mapper.secure.default-attach-name}")
    private String defaultSecureAttachName;
    @Value(value="${mapper.content-save-file-yn}")
    public String contentSaveFileYn;
    @Value(value="${mapper.content-save-path}")
    private String contentRootPath;
    @Value(value="${mapper.content-save-url}")
    private String contentRootUrl;
    @Value(value="${mapper.content-save-file-separator}")
    private String contentSaveFileSeparator;
    @Value(value="${mapper.sms.max-byte}")
    private String smsMaxByte;
    @Value(value="${mapper.lms.max-byte}")
    private String lmsMaxByte;
    @Value(value="${tms.daemon-id}")
    private String daemonId;
    @Value(value="${tms.daemon-type}")
    private String daemonType;
    @Value(value="${mapper.send-flag-count}")
    private String sendFlagCnt;
    @Value(value="${mapper.map-data-save-path}")
    private String mapDataSavePath;
    @Value(value="${mapper.map-data-save-ip}")
    private String mapDataSaveIp;
    @Value(value="${wt.port}")
    private String wtPort;
    @Value(value="${wt.get-file-path}")
    private String wtGetFilePath;
    @Value(value="${mapper.file-save-byte}")
    private String fileSaveByte;
    @Value(value="${mapper.content-compress-yn:Y}")
    private String isContentSaveCompress;
    Configuration cfg;

    @PostConstruct
    public void init() {
        this.cfg = this.configFreeMarker();
    }

    public Configuration configFreeMarker() {
        try {
            BeansWrapperBuilder builder = new BeansWrapperBuilder(Configuration.VERSION_2_3_23);
            builder.setUseModelCache(true);
            BeansWrapper wrapper = builder.build();
            TemplateHashModel staticModels = wrapper.getStaticModels();
            TemplateHashModel tplHashModelStringUtils = (TemplateHashModel)staticModels.get("com.humuson.tms.mapper.util.StringUtil");
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
            cfg.setSharedVariable("util", (TemplateModel)tplHashModelStringUtils);
            cfg.setDefaultEncoding("UTF-8");
            return cfg;
        }
        catch (Exception e) {
            log.error("FREEMARKER configruration fail : {} ", (Throwable)e);
            return null;
        }
    }

    @Override
    public int executeContentMapping(String content, List<MapperInfo> totalList, String targetSeq) throws Exception {
        String cRsltField;
        String tempIntroContent;
        Template templatePushValue = null;
        Template templatePushMsg = null;
        Template templateContent = null;
        Template templateSubject = null;
        Template templateFromNumber = null;
        Template templateSecureAttach = null;
        Template templateSecureIntro = null;
        Template templatePushTrCode = null;
        Template templatePushCustomData = null;
        ArrayList<String> afterMQList = new ArrayList<String>();
        HashMap<String, String> afterTlistMap = new HashMap<String, String>();
        HashMap<String, String> afterCrsltMap = new HashMap<String, String>();
        HashMap<String, String> afterDlistMap = new HashMap<String, String>();
        Map<String, String> userCrsltMap = new HashMap<String, String>();
        ArrayList<Map<String, Object>> afterInAppList = new ArrayList<Map<String, Object>>();
        MappingInfo mminfo = new MappingInfo();
        Properties campProp = totalList.get(0).getCampProp();
        log.info("campProp:{}", (Object)campProp);
        String campType = campProp.getProperty(Column.CAMP_TYPE, "M");
        String channelType = (String)campProp.get(Column.CHANNEL_TYPE);
        String channelTypeSub = (String)campProp.get(Column.CHANNEL_TYPE_SUB);
        String tempChannelTypeSub = "";
        String schdId = campProp.getProperty(Column.SCHD_ID);
        String sendId = campProp.getProperty(Column.SEND_ID);
        String sendAddId = campProp.getProperty(Column.SEND_ADD_ID);
        String switchFlag = campProp.getProperty(Column.SWITCH_FLAG, "N");
        String pushType = campProp.getProperty(Column.PUSH_TYPE);
        String nlsLang = campProp.getProperty(Column.NLS_LANG, "UTF-8");
        String triggerMethod = campProp.getProperty(Column.TRIGGER_METHOD, "O1");
        String workday = campProp.getProperty(Column.WORKDAY, DateUtil.getWorkday());
        boolean sendFlag = false;
        List<Map<String, Object>> targetList = totalList.get(0).getTargetList();
        ArrayList<Map<String, Object>> attachList = new ArrayList();
        HashMap<String, Object> mqUserMap = new HashMap<String, Object>();
        if (targetList.size() < 1) {
            log.error("MP2001|TargetList size Zero : TargetList.size():[{}]", (Object)targetList.size());
            throw new Exception("TargetList size Zero");
        }
        if (StringUtil.isNull(content) && !"OP".equals(pushType)) {
            log.error("CM0501|Content is null : content:[{}] / sendId:{} / schdId:{} / targetSeq:{}", new Object[]{content, sendId, schdId, targetSeq});
            this.redisExecutor.updateTotalCrsltUser(totalList, sendId, schdId, targetSeq, "MP104", "Content is Null");
            this.redisExecutor.updateSproc("40", schdId, targetSeq, sendId, -1);
            return -1;
        }
        sendFlag = targetList.size() >= Integer.parseInt(this.sendFlagCnt) && (Constants.TriggerMethod.O1.name().equals(triggerMethod) || Constants.TriggerMethod.O9.name().equals(triggerMethod));
        log.info("targetList.size() :{}", (Object)targetList.size());
        String tlistKey = "TLIST:" + schdId + ":" + targetSeq;
        String dlistKey = "DLIST:" + schdId + ":" + targetSeq;
        String crsltKey = "CRSLT:" + channelType + ":" + DateUtil.getFullDate((String)"yyyyMMddHHmm");
        String sendMqKey = sendId + ":" + schdId + ":" + targetSeq;
        long startT = 0L;
        long endT = 0L;
        if (campProp.getProperty(Column.SAFEMAIL_YN, "N").equalsIgnoreCase("Y") && ChannelType.EMAIL.same(channelType)) {
            startT = System.currentTimeMillis();
            content = this.sourceAdd.addSafeMailSource(content, campProp);
            endT = System.currentTimeMillis();
            log.info("[END] \uc548\uc2ec\uba54\uc77c\ucf54\ub4dc \uc0bd\uc785 \uc644\ub8cc ==========================[{}]", (Object)((double)(endT - startT) / 1000.0 + " \ucd08"));
        }
        if (!campProp.getProperty(Column.TRACKING_YN, "N").equalsIgnoreCase("N") && campProp.getProperty(Column.CONTENT_TYPE, "T").equalsIgnoreCase("H") && ChannelType.EMAIL.same(channelType)) {
            startT = System.currentTimeMillis();
            content = this.sourceAdd.addTarckingSource(content, campProp);
            endT = System.currentTimeMillis();
            log.info("[END] \ud2b8\ub808\ud0b9\ucf54\ub4dc \uc0bd\uc785 \uc644\ub8cc ===========================[{}]", (Object)((double)(endT - startT) / 1000.0 + " \ucd08"));
        }
        if (campProp.getProperty(Column.ATTACH_YN, "N").equalsIgnoreCase("Y")) {
            startT = System.currentTimeMillis();
            attachList = this.mapperDao.getAttachFileInfo(sendAddId);
            endT = System.currentTimeMillis();
            log.info("[END] \ucca8\ubd80\ud30c\uc77c\ub9ac\uc2a4\ud2b8 \uac00\uc838\uc634 ==========================[{}]", (Object)((double)(endT - startT) / 1000.0 + " \ucd08"));
        }
        boolean isAttachSizeError = false;
        if (campProp.getProperty(Column.ATTACH_YN, "N").equalsIgnoreCase("Y") && this.filter.checkAttachSize(attachList)) {
            log.error("[\uc77c\ubc18\ucca8\ubd80\ud30c\uc77c\uc624\ub958] Attach File Size Over => sendId:{}", (Object)sendId);
            isAttachSizeError = true;
        }
        if (Constants.TargetType.DB.name().equals(campProp.getProperty(Column.TARGET_TYPE)) && !Constants.TriggerMethod.O7.name().equals(triggerMethod)) {
            startT = System.currentTimeMillis();
            mminfo = this.getMappingData(campProp);
            endT = System.currentTimeMillis();
            log.info("[END] \ub9e4\ud551\uc815\ubcf4 \uac00\uc838\uc640\uc11c Set ==========================[{}]", (Object)((double)(endT - startT) / 1000.0 + " \ucd08"));
        }
        if (campProp.containsKey(Column.PUSH_VALUE) && campProp.getProperty(Column.PUSH_VALUE, "").indexOf("${") > -1) {
            templatePushValue = new Template("templatePushValue", (Reader)new StringReader(campProp.getProperty(Column.PUSH_VALUE, "")), this.cfg);
        }
        if (campProp.containsKey(Column.PUSH_MSG) && campProp.getProperty(Column.PUSH_MSG, "").indexOf("${") > -1) {
            templatePushMsg = new Template("templatePushMsg", (Reader)new StringReader(campProp.getProperty(Column.PUSH_MSG, "")), this.cfg);
        }
        if (!content.trim().isEmpty() && content.indexOf("${") > -1) {
            templateContent = new Template("templateContent", (Reader)new StringReader(content), this.cfg);
        }
        if (campProp.containsKey(Column.SUBJECT) && campProp.getProperty(Column.SUBJECT, "").indexOf("${") > -1) {
            templateSubject = new Template("templateSubject", (Reader)new StringReader(campProp.getProperty(Column.SUBJECT, "")), this.cfg);
        }
        if (campProp.containsKey(Column.SECURE_ATTACH_NAME) && campProp.getProperty(Column.SECURE_ATTACH_NAME, "").indexOf("${") > -1) {
            templateSecureAttach = new Template("templateSecureAttach", (Reader)new StringReader(campProp.getProperty(Column.SECURE_ATTACH_NAME, "")), this.cfg);
        }
        if (campProp.containsKey(Column.SECURE_INTRO_TEMPLATE) && campProp.getProperty(Column.SECURE_INTRO_TEMPLATE, "N").equalsIgnoreCase("Y") && (tempIntroContent = this.sourceAdd.getContentUrl(campProp.getProperty(Column.SECURE_INTRO_TEMPLATE))).indexOf("${") > -1) {
            templateSecureIntro = new Template("templateSecureIntro", (Reader)new StringReader(tempIntroContent), this.cfg);
        }
        if (campProp.containsKey(Column.FROM_NUMBER) && campProp.getProperty(Column.FROM_NUMBER, "").indexOf("${") > -1) {
            templateFromNumber = new Template("templateFromNumber", (Reader)new StringReader(campProp.getProperty(Column.FROM_NUMBER, "")), this.cfg);
        }
        if (campProp.containsKey("PUSH_TRCODE") && campProp.getProperty("PUSH_TRCODE", "").indexOf("${") > -1) {
            templatePushTrCode = new Template("templatePushTrCode", (Reader)new StringReader(campProp.getProperty("PUSH_TRCODE", "")), this.cfg);
        }
        if (campProp.containsKey("PUSH_CUSTOM_DATA") && campProp.getProperty("PUSH_CUSTOM_DATA", "").indexOf("${") > -1) {
            templatePushCustomData = new Template("templatePushCustomData", (Reader)new StringReader(campProp.getProperty("PUSH_CUSTOM_DATA", "")), this.cfg);
        }
        int cnt = 0;
        int failCnt = 0;
        int noti_N_cnt = 0;
        for (Map<String, Object> userMap : targetList) {
            String memberId;
            String domain;
            boolean isError;
            String tempContent;
            String rsltJson;
            String userInfoMQJson;
            String userInfoJson;
            Map<String, Object> mappingDataMapTemp;
            HashMap<String, Object> mappingDataMap;
            List<Map<String, Object>> dynamicAttachList;
            block178: {
                ++cnt;
                dynamicAttachList = new ArrayList<Map<String, Object>>();
                mappingDataMap = null;
                mappingDataMapTemp = null;
                userInfoJson = "";
                userInfoMQJson = "";
                rsltJson = "";
                tempContent = "";
                isError = false;
                domain = "";
                userCrsltMap.clear();
                memberId = String.valueOf(userMap.get(Column.FIELD_MEMBER_ID));
                log.info("[\uac00\uc838\uc628 \ub300\uc0c1\uc790 \ub370\uc774\ud130] userMap ===========>  {}", userMap);
                if (!StringUtil.isNull((String)userMap.get(Column.STATUS))) {
                    log.info("[ERROR] user STATUS not null STATUS [{}]  memberId [{}]", userMap.get(Column.STATUS), (Object)memberId);
                    ++failCnt;
                    isError = true;
                    userCrsltMap = this.putErrorCodeDetail((String)userMap.get(Column.STATUS), (String)userMap.get(Column.LOG_DETAIL), userCrsltMap);
                }
                if (isAttachSizeError && !isError) {
                    ++failCnt;
                    isError = true;
                    userMap.put(Column.STATUS, "MP101");
                    userCrsltMap = this.putErrorCodeDetail("MP101", "[\uc77c\ubc18\ucca8\ubd80\ud30c\uc77c\uc624\ub958] Attach File Size Over => sendId:" + sendId, userCrsltMap);
                }
                if (!Constants.TriggerMethod.O7.name().equals(triggerMethod)) {
                    mappingDataMap = new HashMap<String, Object>();
                    try {
                        mappingDataMapTemp = this.getMappingDataPut(userMap, campProp, mminfo);
                        mappingDataMap.putAll(mappingDataMapTemp);
                        userMap.putAll(mappingDataMapTemp);
                    }
                    catch (Exception e) {
                        log.error("[getMaappingDataPut] Error -> CRSLT input -> memberId:{}  sendId:{} :{}", new Object[]{memberId, sendId, e});
                        ++failCnt;
                        isError = true;
                        userMap.put(Column.STATUS, "MP101");
                        userCrsltMap = this.putErrorCodeDetail("MP101", "[\ub9e4\ud551\ub370\uc774\ud130\uc624\ub958] Simple Mapping Result Size Over [Or] Mapping Query Error [Or] KeyValue Mapping key is NULL", userCrsltMap);
                    }
                    try {
                        if (!mappingDataMap.isEmpty() || this.checkByte(userMap, this.fileSaveByte)) {
                            String mapFolderPath = this.mapDataSavePath + "/" + workday + "/" + schdId + "/" + targetSeq;
                            File mappingFolderFile = new File(mapFolderPath);
                            if (!mappingFolderFile.exists()) {
                                mappingFolderFile.mkdirs();
                            }
                            String mapFullPath = mapFolderPath + "/" + memberId.replaceAll(":", this.contentSaveFileSeparator) + ".map";
                            if (!mappingDataMap.isEmpty()) {
                                mappingDataMap.putAll(userMap);
                                this.saveMapData(mappingDataMap, mapFullPath, memberId, nlsLang);
                            } else if (this.checkByte(userMap, this.fileSaveByte)) {
                                this.saveMapData(userMap, mapFullPath, memberId, nlsLang);
                            }
                            userMap.put(Column.MAP_FILE_SAVE_YN, "Y");
                            userMap.put(Column.MAP_FILE_PATH, mapFullPath);
                            userMap.put(Column.MAP_FILE_IP, this.mapDataSaveIp);
                            break block178;
                        }
                        userMap.put(Column.MAP_FILE_SAVE_YN, "N");
                    }
                    catch (Exception e) {
                        log.error("MP4001|MappingContent or TLIST save File Error. memberId:{}", (Object)memberId, (Object)e);
                        ++failCnt;
                        isError = true;
                        userMap.put(Column.STATUS, "MP105");
                        userCrsltMap = this.putErrorCodeDetail("MP105", "[Error] Mapping Content or TLIST save File Error", userCrsltMap);
                    }
                } else if (Constants.TriggerMethod.O7.name().equals(triggerMethod) && "Y".equals((String)userMap.get(Column.MAP_FILE_SAVE_YN)) && !isError) {
                    JSONObject resultJSON = new JSONObject();
                    try {
                        String mapFileIp = (String)userMap.get(Column.MAP_FILE_IP);
                        String mapFilePath = (String)userMap.get(Column.MAP_FILE_PATH);
                        if (StringUtil.isNull(mapFileIp) || StringUtil.isNull(mapFilePath)) {
                            log.error("[ERROR] MAP_FILE_IP is Null OR MAP_FILE_PATH is Null => [{}],[{}]", (Object)mapFileIp, (Object)mapFilePath);
                            throw new Exception("[ERROR] MAP_FILE_IP is Null OR MAP_FILE_PATH is Null =>  mapFileIp:" + mapFileIp + ",mapFilePath:" + mapFilePath);
                        }
                        StringBuffer mapCallUrlSb = new StringBuffer();
                        mapCallUrlSb.append("http://").append(mapFileIp).append(":").append(this.wtPort).append("/watcher").append(this.wtGetFilePath).append("?").append("path=").append(URLEncoder.encode(mapFilePath, nlsLang));
                        log.debug("mapFileIp : {}, wtPort:{}, wtGetFilePath:{}, mapFilePath:{} mapCallUrlSb.toString() : {}", new Object[]{mapFileIp, this.wtPort, this.wtGetFilePath, mapFilePath, mapCallUrlSb.toString()});
                        JSONParser parser = new JSONParser();
                        String resString = HttpUtil.jsonCallUrl((String)mapCallUrlSb.toString());
                        Object obj = parser.parse(resString);
                        resultJSON = (JSONObject)obj;
                        if (resultJSON.containsKey((Object)Column.DOMAIN)) {
                            resultJSON.remove((Object)Column.DOMAIN);
                        }
                        if (ChannelType.EMAIL.same(channelType)) {
                            if (resultJSON.containsKey((Object)Column.TMS_M_EMAIL)) {
                                resultJSON.remove((Object)Column.TMS_M_EMAIL);
                            }
                        } else if ((ChannelType.SMS.same(channelType) || ChannelType.KAKAO.same(channelType)) && resultJSON.containsKey((Object)Column.TMS_M_PHONE)) {
                            resultJSON.remove((Object)Column.TMS_M_PHONE);
                        }
                        if (resultJSON.containsKey((Object)Column.TMS_M_TARGET)) {
                            resultJSON.remove((Object)Column.TMS_M_TARGET);
                        }
                        userMap.putAll((Map<String, Object>)resultJSON);
                    }
                    catch (Exception e) {
                        log.error("MP4001|WATCH API Call Error memberId:{} :{}", (Object)memberId, (Object)e.getMessage());
                        ++failCnt;
                        isError = true;
                        userMap.put(Column.STATUS, "MP106");
                        userCrsltMap = this.putErrorCodeDetail("MP105", "[API\uc5d0\ub7ec] Resend API Call Error:" + e.getMessage(), userCrsltMap);
                    }
                } else {
                    userMap.put(Column.MAP_FILE_SAVE_YN, "N");
                }
            }
            if (userMap.containsKey(Column.ATTACH_1) && !isError) {
                try {
                    dynamicAttachList = this.putDynamicAttachAdd(userMap, dynamicAttachList);
                    if (this.filter.checkAttachSize(dynamicAttachList)) {
                        log.error("[\uac1c\ubcc4\ucca8\ubd80\ud30c\uc77c\uc624\ub958] Attach File Size Over => sendId:{}", (Object)sendId);
                        ++failCnt;
                        isError = true;
                        userMap.put(Column.STATUS, "MP101");
                        userCrsltMap = this.putErrorCodeDetail("MP101", "[\uac1c\ubcc4\ucca8\ubd80\ud30c\uc77c\uc624\ub958] Attach File Size Over => sendId:" + sendId, userCrsltMap);
                    }
                }
                catch (Exception e) {
                    log.error("[\uac1c\ubcc4\ucca8\ubd80\ud30c\uc77c\uc624\ub958] dynamic Attach List Create Error memberId:{} / sendId:{} / schdId:{} / targetSeq:{}", new Object[]{memberId, sendId, schdId, targetSeq, e});
                    ++failCnt;
                    isError = true;
                    userMap.put(Column.STATUS, "MP101");
                    userCrsltMap = this.putErrorCodeDetail("MP101", "[\uac1c\ubcc4\ucca8\ubd80\ud30c\uc77c\uc624\ub958] dynamic Attach List Create Error", userCrsltMap);
                }
            }
            if (this.filter.userInfoFilter(userMap, channelType) && !isError) {
                ++failCnt;
                isError = true;
                userMap.put(Column.STATUS, "MP102");
                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] \ub300\uc0c1\uc790 \ud544\uc218\uc815\ubcf4 \uc720\ud6a8\uc131 \uc5d0\ub7ec", userCrsltMap);
            }
            userMap = this.sourceAdd.addEncValues(userMap, schdId, channelType);
            if (ChannelType.PUSH.same(channelType) && !isError) {
                String original;
                String result;
                if (campProp.containsKey(Column.PUSH_VALUE)) {
                    String resultPushValue = "";
                    String pushValue = campProp.getProperty(Column.PUSH_VALUE, "");
                    if (pushValue.indexOf("${") > -1) {
                        try {
                            resultPushValue = this.convertMappingExecutor(resultPushValue, userMap, campProp, pushValue, templatePushValue);
                            if (StringUtil.isNull(resultPushValue)) {
                                log.info("[FAIL] resultPushValue isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put(Column.STATUS, "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] PushValue isNull", userCrsltMap);
                            } else {
                                userMap.put(Column.PUSH_VALUE, resultPushValue);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5304|PUSH_VALUE Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put(Column.STATUS, "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] Mapping Error", userCrsltMap);
                        }
                    }
                }
                if (campProp.containsKey(Column.PUSH_MSG)) {
                    String resultPushMsg = "";
                    String pushMsg = campProp.getProperty(Column.PUSH_MSG, "");
                    if (pushMsg.indexOf("${") > -1) {
                        try {
                            resultPushMsg = this.convertMappingExecutor(resultPushMsg, userMap, campProp, pushMsg, templatePushMsg);
                            if (StringUtil.isNull(resultPushMsg)) {
                                log.info("[FAIL] resultPushMsg isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put(Column.STATUS, "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] PushMsg isNull", userCrsltMap);
                            } else {
                                userMap.put(Column.PUSH_MSG, resultPushMsg);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5305|PUSH_MSG Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put(Column.STATUS, "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] Mapping Error", userCrsltMap);
                        }
                    }
                }
                if (campProp.containsKey("PUSH_CUSTOM_DATA")) {
                    result = "";
                    original = campProp.getProperty("PUSH_CUSTOM_DATA", "");
                    if (original.indexOf("${") > -1) {
                        try {
                            result = this.convertMappingExecutor(result, userMap, campProp, original, templatePushCustomData);
                            if (StringUtil.isNull(result)) {
                                log.info("[FAIL] result PUSH_CUSTOM_DATA isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put(Column.STATUS, "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] PUSH_CUSTOM_DATA isNull", userCrsltMap);
                            } else {
                                userMap.put("PUSH_CUSTOM_DATA", result);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5305|PUSH_CUSTOM_DATA Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put(Column.STATUS, "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] PUSH_CUSTOM_DATA Mapping Error", userCrsltMap);
                        }
                    }
                }
                if (campProp.containsKey("PUSH_TRCODE")) {
                    result = "";
                    original = campProp.getProperty("PUSH_TRCODE", "");
                    if (original.indexOf("${") > -1) {
                        try {
                            result = this.convertMappingExecutor(result, userMap, campProp, original, templatePushTrCode);
                            if (StringUtil.isNull(result)) {
                                log.info("[FAIL] result PUSH_TRCODE isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put(Column.STATUS, "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] PUSH_TRCODE isNull", userCrsltMap);
                            } else {
                                userMap.put("PUSH_TRCODE", result);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5305|PUSH_TRCODE Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put(Column.STATUS, "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] PUSH_TRCODE Mapping Error", userCrsltMap);
                        }
                    }
                }
            }
            if (!isError) {
                try {
                    tempContent = this.convertMappingExecutor(tempContent, userMap, campProp, content, templateContent);
                }
                catch (Exception e) {
                    log.error("MP5306|Content Mapping Error :{}", (Object)e.getMessage());
                    ++failCnt;
                    isError = true;
                    userMap.put(Column.STATUS, "MP103");
                    userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] Mapping Error", userCrsltMap);
                }
                if (this.filter.contentFilter(tempContent, channelType, channelTypeSub, memberId, switchFlag) && !isError) {
                    ++failCnt;
                    isError = true;
                    userMap.put(Column.STATUS, "MP104");
                    userCrsltMap = this.putErrorCodeDetail("MP104", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] Content Max Byte Over", userCrsltMap);
                }
                if (campProp.containsKey(Column.SUBJECT) && !ChannelType.SMS.same(tempChannelTypeSub) && !isError) {
                    String resultSubject = "";
                    String subject = campProp.getProperty(Column.SUBJECT, "");
                    if (subject.indexOf("${") > -1) {
                        try {
                            resultSubject = this.convertMappingExecutor(resultSubject, userMap, campProp, subject, templateSubject);
                            if (StringUtil.isNull(resultSubject)) {
                                log.info("[FAIL] resultSubject isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put(Column.STATUS, "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] Subject isNull", userCrsltMap);
                            } else {
                                userMap.put(Column.SUBJECT, resultSubject);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5308|SUBJECT Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put(Column.STATUS, "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] Mapping Error", userCrsltMap);
                        }
                    }
                }
                if (ChannelType.PUSH.same(channelType) && userMap.get(Column.DOMAIN).equals(Column.ANDROID)) {
                    userMap.put(Column.DOMAIN, channelTypeSub);
                }
                log.debug("[\ucee8\ud150\uce20\ub9e4\ud551 \ud6c4] tempContent \n:{}", (Object)tempContent);
                if (ChannelType.EMAIL.same(channelType) && !isError) {
                    if (campProp.getProperty(Column.SECURE_YN, "N").equalsIgnoreCase("Y")) {
                        String secureAttachName = campProp.getProperty(Column.SECURE_ATTACH_NAME, this.defaultSecureAttachName);
                        String tempSecureAttachName = this.convertMappingExecutor(tempContent, userMap, campProp, secureAttachName, templateSecureAttach);
                        userMap.put(Column.SECURE_ATTACH_NAME, tempSecureAttachName);
                    }
                    try {
                        tempContent = this.sourceAdd.addMailBody(tempContent, campProp, userMap, attachList, dynamicAttachList, templateSecureIntro);
                    }
                    catch (Exception e) {
                        log.error("MP5503|AddMailBody Fail. memberId:[{}]:{}", (Object)memberId, (Object)e.getMessage());
                        ++failCnt;
                        isError = true;
                        userMap.put(Column.STATUS, "MP108");
                        userCrsltMap = this.putErrorCodeDetail("MP108", "[ERROR] AddMailBody Fail", userCrsltMap);
                    }
                } else if (ChannelType.KAKAO.same(channelType) && !isError) {
                    String kakaoContent = "";
                    String smsContent = "";
                    if (!"N".equals(switchFlag) && tempContent.indexOf("/**KAKAO_DELIM**/") > -1) {
                        int idx1 = tempContent.indexOf("/**KAKAO_DELIM**/");
                        int idx2 = "/**KAKAO_DELIM**/".length();
                        kakaoContent = tempContent.substring(0, idx1);
                        smsContent = tempContent.substring(idx1 + idx2, tempContent.length());
                        if (!StringUtil.isNull(smsContent) && smsContent.indexOf("/**KAKAO_BUTTON**/") > -1) {
                            int idx3 = smsContent.indexOf("/**KAKAO_BUTTON**/");
                            int idx4 = "/**KAKAO_BUTTON**/".length();
                            userMap.put(Column.RESEND_MT_MESSAGE, smsContent.substring(0, idx3));
                            userMap.put(Column.ATTACHMENT_JSON, smsContent.substring(idx3 + idx4, smsContent.length()));
                        } else {
                            userMap.put(Column.RESEND_MT_MESSAGE, smsContent);
                        }
                        tempContent = kakaoContent;
                    } else if (!StringUtil.isNull(tempContent) && tempContent.indexOf("/**KAKAO_BUTTON**/") > -1) {
                        int idx3 = tempContent.indexOf("/**KAKAO_BUTTON**/");
                        int idx4 = "/**KAKAO_BUTTON**/".length();
                        tempContent = tempContent.substring(0, idx3);
                        userMap.put(Column.ATTACHMENT_JSON, tempContent.substring(idx3 + idx4, tempContent.length()));
                    }
                } else if (ChannelType.SMS.same(channelType) && !isError) {
                    tempChannelTypeSub = this.filter.exchangeChannelTypeSub(tempContent, channelType, channelTypeSub, switchFlag, attachList, dynamicAttachList);
                    if (!StringUtil.isNull(tempChannelTypeSub)) {
                        userMap.put(Column.DOMAIN, tempChannelTypeSub);
                    }
                    if (campProp.containsKey(Column.FROM_NUMBER)) {
                        String resultFromNumber = "";
                        String originalFromNumber = campProp.getProperty(Column.FROM_NUMBER, "");
                        try {
                            resultFromNumber = this.convertMappingExecutor(resultFromNumber, userMap, campProp, originalFromNumber, templateFromNumber);
                            if (StringUtil.isNull(resultFromNumber)) {
                                log.info("[FAIL] resultFromNumber isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put(Column.STATUS, "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] resultFromNumber isNull", userCrsltMap);
                            } else {
                                userMap.put(Column.FROM_NUMBER, resultFromNumber);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5310| FromNumber Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put(Column.STATUS, "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] FromNumber Mapping Error", userCrsltMap);
                        }
                    }
                    if (ChannelType.MMS.getName().equals(tempChannelTypeSub)) {
                        try {
                            userMap = this.addAttachList(attachList, dynamicAttachList, userMap);
                        }
                        catch (Exception e) {
                            log.error("MP5505|MMS attach Parsing Error, memberId:[{}]:{}", (Object)memberId, (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put(Column.STATUS, "MP107");
                            userCrsltMap = this.putErrorCodeDetail("MP107", "[FAIL] MMS attach Parsing Error", userCrsltMap);
                        }
                    }
                }
                if (ChannelType.EMAIL.same(channelType) && "Y".equals(this.contentSaveFileYn) && !isError) {
                    String folderPath;
                    File folder;
                    String fullContentFolderPath = this.contentRootPath + "/" + workday + "/" + schdId + "/" + targetSeq;
                    String fullContentFolderUrl = this.contentRootUrl + "/" + workday + "/" + schdId + "/" + targetSeq;
                    File contentFolderFile = new File(fullContentFolderPath);
                    if (!contentFolderFile.exists()) {
                        contentFolderFile.mkdirs();
                    }
                    String contentFullPath = fullContentFolderPath + "/" + memberId.replaceAll(":", this.contentSaveFileSeparator) + ".html";
                    String contentFullUrl = fullContentFolderUrl + "/" + URLEncoder.encode(memberId.replaceAll(":", this.contentSaveFileSeparator) + ".html", nlsLang);
                    if ("Y".equalsIgnoreCase(this.isContentSaveCompress)) {
                        contentFullPath = fullContentFolderPath + "/" + memberId.replaceAll(":", this.contentSaveFileSeparator) + ".zip";
                        contentFullUrl = fullContentFolderUrl + "/" + URLEncoder.encode(memberId.replaceAll(":", this.contentSaveFileSeparator) + ".zip", nlsLang);
                    }
                    if (!(folder = new File(folderPath = contentFullPath.substring(0, contentFullPath.lastIndexOf("/")))).exists()) {
                        folder.mkdirs();
                    }
                    long startFile = System.currentTimeMillis();
                    log.debug("[START] FullContent(content length:{}) Write START ===========================memberId :{}", (Object)tempContent.length(), (Object)memberId);
                    if ("Y".equalsIgnoreCase(this.isContentSaveCompress) && this.contentReadWrite.saveFullContentCompressFile(contentFullPath, "html", tempContent, nlsLang) || "N".equalsIgnoreCase(this.isContentSaveCompress) && this.contentReadWrite.saveFullContentFile(contentFullPath, tempContent, nlsLang)) {
                        File f = new File(contentFullPath);
                        if (!f.exists() || !f.isFile()) {
                            log.info("MP4002|Email Templte Not Exists [{}]", (Object)contentFullPath);
                        } else {
                            userMap.put(Column.FULL_CONTENT_PATH, contentFullPath);
                            userMap.put(Column.FULL_CONTENT_URL, contentFullUrl);
                            userMap.put(Column.FULL_CONTENT_COMPRESS_YN, this.isContentSaveCompress);
                        }
                    } else {
                        log.error("MP4001|FullContent save Fail :{}", (Object)memberId);
                        ++failCnt;
                        isError = true;
                        userMap.put(Column.STATUS, "MP105");
                        userCrsltMap = this.putErrorCodeDetail("MP105", "[FAIL] FullContent save Fail", userCrsltMap);
                    }
                    long endFile = System.currentTimeMillis();
                    log.debug("[END] FullContent(content length:{})memberId :{} Write END ===========================[{}]", new Object[]{tempContent.length(), memberId, (double)(endFile - startFile) / 1000.0 + " \ucd08"});
                } else if (!isError) {
                    userMap.put(Column.CONTENT, tempContent);
                }
            }
            if (tempContent != null) {
                tempContent = "";
            }
            cRsltField = sendId + ":" + schdId + ":" + targetSeq + ":" + memberId;
            if (isError) {
                rsltJson = this.putCrsltJsonString(userMap, campProp, targetSeq, userCrsltMap);
                afterCrsltMap.put(cRsltField, rsltJson);
            } else if (ChannelType.PUSH.same(channelType) && "OM".equals(pushType)) {
                userCrsltMap = this.putErrorCodeDetail("MP001", "SUCCESS", userCrsltMap);
                rsltJson = this.putCrsltJsonString(userMap, campProp, targetSeq, userCrsltMap);
                afterCrsltMap.put(cRsltField, rsltJson);
            }
            domain = String.valueOf(userMap.get(Column.DOMAIN));
            userInfoJson = this.convertMapToJSONString(userMap, channelType, mappingDataMapTemp);
            afterTlistMap.put(memberId, userInfoJson);
            if (sendFlag && !isError) {
                if (afterDlistMap.containsKey(domain)) {
                    afterDlistMap.put(domain, (String)afterDlistMap.get(domain) + "," + memberId);
                } else {
                    afterDlistMap.put(domain, memberId);
                }
            }
            if (!sendFlag) {
                mqUserMap.put("key", sendMqKey);
                mqUserMap.put("memberId", memberId);
                mqUserMap.put("domain", String.valueOf(userMap.get(Column.DOMAIN)));
                mqUserMap.put("company", campProp.getProperty(Column.COMPANY, "tms"));
                mqUserMap.put("channelType", channelType);
                userInfoMQJson = this.convertMapToJSONString(mqUserMap, channelType, mappingDataMapTemp);
                if (ChannelType.PUSH.same(channelType)) {
                    if (!"OM".equals(pushType) && "Y".equals((String)userMap.get(Column.NOTI_FLAG)) && !isError) {
                        afterMQList.add(userInfoMQJson);
                    }
                } else if (!isError) {
                    afterMQList.add(userInfoMQJson);
                }
            }
            if (ChannelType.PUSH.same(channelType)) {
                String msgUid = campProp.getProperty(Column.SITE_ID).toString().concat("-").concat(schdId).concat("-").concat(sendId).concat("-").concat(targetSeq).concat("-").concat((String)campProp.get(Column.WORKDAY)).concat("-").concat(String.valueOf(userMap.get(Column.TMS_M_ID))).concat("-").concat(String.valueOf(userMap.get(Column.UNIQUE_SEQ)));
                userMap.put(Column.MSG_UID, msgUid);
                userMap = this.putInAppValue(userMap, campProp);
                if (("MP".equals(pushType) || "OM".equals(pushType)) && !isError) {
                    afterInAppList.add(userMap);
                }
                if ("N".equals((String)userMap.get(Column.NOTI_FLAG)) && !isError) {
                    ++noti_N_cnt;
                    log.info("==> NOFI_FLAG:N   memberId:{}  sendId:{}  schdId:{} targetSeq:{}", new Object[]{memberId, sendId, schdId, targetSeq});
                    userCrsltMap = this.putErrorCodeDetail("MP001", "NOTI_FLAG:N => [SUCCESS]", userCrsltMap);
                    rsltJson = this.putCrsltJsonString(userMap, campProp, targetSeq, userCrsltMap);
                    afterCrsltMap.put(cRsltField, rsltJson);
                }
            }
            if (!dynamicAttachList.isEmpty()) {
                dynamicAttachList.clear();
            }
            if (mappingDataMap != null && !mappingDataMap.isEmpty()) {
                mappingDataMap.clear();
            }
            if (mappingDataMapTemp == null || mappingDataMapTemp.isEmpty()) continue;
            mappingDataMapTemp.clear();
        }
        long start1 = 0L;
        long end1 = 0L;
        String pcnclKey = "PCNCL";
        if (this.redisExecutor.checkStop(pcnclKey, sendId)) {
            start1 = System.currentTimeMillis();
            this.redisExecutor.updateTotalCrsltUser(totalList, sendId, schdId, targetSeq, "MP601", "SEND STOP");
            this.redisExecutor.updateSproc("42", schdId, targetSeq, sendId, -1);
            end1 = System.currentTimeMillis();
            log.info("[END] 2\ucc28 \ubc1c\uc1a1\uc911\uc9c0 \ucc98\ub9ac ===========================[{}]", (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
            return -1;
        }
        if (sendFlag && failCnt != cnt) {
            String userInfoMQJson = "";
            mqUserMap.clear();
            mqUserMap.put("key", sendMqKey);
            mqUserMap.put("domain", "ALL");
            mqUserMap.put("company", campProp.getProperty(Column.COMPANY, "tms"));
            mqUserMap.put("channelType", channelType);
            userInfoMQJson = this.convertMapToJSONString(mqUserMap, channelType, null);
            afterMQList.add(userInfoMQJson);
        }
        if (!mqUserMap.isEmpty()) {
            mqUserMap.clear();
        }
        log.info("==> channelType:{} \t channelTypeSub:{} \t tempChannelTypeSub:{} \t switchFlag:{} \t sendFlag:{} ", new Object[]{channelType, channelTypeSub, tempChannelTypeSub, switchFlag, sendFlag});
        log.info("==> afterInAppList.size():{} \t afterMQList.size():{} \t afterTlistMap.size():{} \t afterDlistMap.size():{} \t afterCrsltMap.size():{} \t noti_N_cnt:{}", new Object[]{afterInAppList.size(), afterMQList.size(), afterTlistMap.size(), afterDlistMap.size(), afterCrsltMap.size(), noti_N_cnt});
        List<Map<String, Object>> failList = null;
        ArrayList<String> removeMQList = null;
        Map<String, String> userCrsltMap2 = null;
        if (afterInAppList.size() > 0) {
            start1 = System.currentTimeMillis();
            try {
                failList = this.batchExcutor.insertBatch(afterInAppList);
                log.info("==> Inapp Insert Fail.size(): {}", (Object)failList.size());
                userCrsltMap2 = new HashMap<String, String>();
                removeMQList = new ArrayList<String>();
                int equalsCnt = 0;
                for (Map<String, Object> failMap : failList) {
                    String failMemberId = String.valueOf(failMap.get(Column.FIELD_MEMBER_ID));
                    userCrsltMap2.clear();
                    cRsltField = sendId + ":" + schdId + ":" + targetSeq + ":" + failMemberId;
                    userCrsltMap2 = this.putErrorCodeDetail("MP701", "[DB_ERROR] INAPP_MSG insert Fail", userCrsltMap2);
                    String rsltJson = this.putCrsltJsonString(failMap, campProp, targetSeq, userCrsltMap2);
                    afterCrsltMap.put(cRsltField, rsltJson);
                    if (sendFlag) {
                        String doamin = (String)failMap.get(Column.DOMAIN);
                        String domainValue = (String)afterDlistMap.get(doamin);
                        afterDlistMap.put(doamin, domainValue.replace(failMemberId, "").replace(failMemberId + ",", ""));
                    }
                    removeMQList.clear();
                    for (String jsonStr : afterMQList) {
                        String mqMemberId;
                        Map mqInfoMap = new HashMap();
                        mqInfoMap = JsonUtil.getMapFromJson((String)jsonStr);
                        if (sendFlag || !failMemberId.equals(mqMemberId = (String)mqInfoMap.get("memberId"))) continue;
                        log.error("[ERROR] INSERT FAIL TARGET afterMqList remove : CNT:[{}] sendId[{}] schdId[{}] targetSeq[{}] ==> : [ failMemberId:{} / mqMemberId:{} ]", new Object[]{++equalsCnt, sendId, schdId, targetSeq, failMemberId, mqMemberId});
                        removeMQList.add(jsonStr);
                    }
                    if (sendFlag) continue;
                    for (String jsonStr : removeMQList) {
                        afterMQList.remove(jsonStr);
                        ++failCnt;
                    }
                }
                if (sendFlag) {
                    log.info("[afterMQList Clear] INAPP LIST SIZE({}) / INAPP INSERT FAIL SIZE({}) : sendId:[{}] schdId:[{}] targetSeq:[{}]", new Object[]{afterInAppList.size(), failList.size(), sendId, schdId, targetSeq});
                    if (afterInAppList.size() == failList.size()) {
                        afterMQList.clear();
                        failCnt = cnt;
                    }
                }
            }
            catch (Exception e) {
                log.error("MP1002|INAPP_MSG insertBatch(INAPP_MSG) Fail -> schdId:{} targetSeq:{} error:{}", new Object[]{schdId, targetSeq, e.getMessage()});
                throw new Exception("[ERROR] INAPP_MSG insertBatch(INAPP_MSG) Fail -> schdId:" + schdId + " targetSeq:" + targetSeq + " error:" + e.getMessage());
            }
            finally {
                if (!failList.isEmpty()) {
                    failList.clear();
                }
                if (removeMQList != null && !removeMQList.isEmpty()) {
                    removeMQList.clear();
                }
                if (userCrsltMap2 != null && !userCrsltMap2.isEmpty()) {
                    userCrsltMap2.clear();
                }
            }
            end1 = System.currentTimeMillis();
            log.info("[END] INSERT IN_APP_MSG size:{}============[{}]", (Object)afterInAppList.size(), (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
            if (!afterInAppList.isEmpty()) {
                afterInAppList.clear();
            }
        }
        if (!afterTlistMap.isEmpty()) {
            start1 = System.currentTimeMillis();
            this.redisExecutor.updateHashMap(tlistKey, afterTlistMap);
            end1 = System.currentTimeMillis();
            log.info("[END] TLIST UPDATE :{}============[{}]", (Object)tlistKey, (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
        } else {
            log.info("afterTlistMap isEmpty .... sendId:[{}] schdId:[{}] targetSeq:[{}]", new Object[]{sendId, schdId, targetSeq});
        }
        if (!afterDlistMap.isEmpty()) {
            start1 = System.currentTimeMillis();
            this.redisExecutor.updateHashMap(dlistKey, afterDlistMap);
            end1 = System.currentTimeMillis();
            log.info("[END] DLIST INSERT :{}============[{}]", (Object)dlistKey, (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
        }
        if (!afterCrsltMap.isEmpty()) {
            start1 = System.currentTimeMillis();
            this.redisExecutor.updateHashMap(crsltKey, afterCrsltMap);
            end1 = System.currentTimeMillis();
            log.info("[END] CRSLT UPDATE :{}============[{}]", (Object)crsltKey, (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
        }
        if (afterMQList.size() > 0) {
            start1 = System.currentTimeMillis();
            for (String jsonStr : afterMQList) {
                this.mqProducer.send(campProp, jsonStr);
            }
            end1 = System.currentTimeMillis();
            log.info("[END] [{}] MQ SEND [{}] [{}] ==========================[{}]", new Object[]{campType, afterMQList.size(), sendId + ":" + schdId + ":" + targetSeq, (double)(end1 - start1) / 1000.0 + " \ucd08"});
        } else {
            log.info("afterMQList size Zero.... sendId:[{}] schdId:[{}] targetSeq:[{}]", new Object[]{sendId, schdId, targetSeq});
        }
        if (!afterMQList.isEmpty()) {
            afterMQList.clear();
        }
        if (!afterCrsltMap.isEmpty()) {
            afterCrsltMap.clear();
        }
        if (!afterTlistMap.isEmpty()) {
            afterTlistMap.clear();
        }
        if (!afterDlistMap.isEmpty()) {
            afterDlistMap.clear();
        }
        if (!userCrsltMap.isEmpty()) {
            userCrsltMap.clear();
        }
        if (mminfo != null) {
            Map<String, TmsJdbcTemplate> tmsJdbcMap = mminfo.getTmsJdbcMap();
            if (tmsJdbcMap != null && !tmsJdbcMap.isEmpty()) {
                for (String key : tmsJdbcMap.keySet()) {
                    tmsJdbcMap.get(key).close();
                }
            }
            mminfo = null;
        }
        if (campProp != null) {
            campProp.clear();
        }
        if (!targetList.isEmpty()) {
            targetList.clear();
        }
        if (!attachList.isEmpty()) {
            attachList.clear();
        }
        if (!afterInAppList.isEmpty()) {
            afterInAppList.clear();
        }
        if (!mqUserMap.isEmpty()) {
            mqUserMap.clear();
        }
        if (templatePushValue != null) {
            templatePushValue = null;
        }
        if (templatePushMsg != null) {
            templatePushMsg = null;
        }
        if (templateContent != null) {
            templateContent = null;
        }
        if (templateSubject != null) {
            templateSubject = null;
        }
        if (templateSecureAttach != null) {
            templateSecureAttach = null;
        }
        if (templateSecureIntro != null) {
            templateSecureIntro = null;
        }
        if (templatePushTrCode != null) {
            templatePushTrCode = null;
        }
        if (templatePushCustomData != null) {
            templatePushCustomData = null;
        }
        return cnt - failCnt;
    }

    @Override
    public Map<String, Object> getMappingDataPut(Map<String, Object> userMap, Properties campProp, MappingInfo mminfo) throws Exception {
        boolean isMappingQueryExecute;
        long startT;
        Map<String, TmsJdbcTemplate> jdbcMap;
        List<ConnectInfo> dbInfoList;
        HashMap<String, Object> tempUserInfoMap;
        block27: {
            tempUserInfoMap = new HashMap<String, Object>();
            dbInfoList = mminfo.getConnectionList();
            jdbcMap = mminfo.getTmsJdbcMap();
            startT = System.currentTimeMillis();
            isMappingQueryExecute = false;
            if (dbInfoList != null && jdbcMap != null) break block27;
            HashMap<String, Object> hashMap = tempUserInfoMap;
            long endT = System.currentTimeMillis();
            if (isMappingQueryExecute) {
                log.info("[END] \ub9e4\ud551\ucffc\ub9ac \uc804\uccb4 \uc644\ub8cc \uc2dc\uac04. \uc804\uccb4 \ucffc\ub9ac \uac2f\uc218:[{}], SEND_ID:[{}] TMS_M_ID [{}] ==========================[{}]", new Object[]{dbInfoList.size(), campProp.getProperty(Column.SEND_ID, "sendId"), userMap.get(Column.TMS_M_ID), (double)(endT - startT) / 1000.0 + " \ucd08"});
            }
            return hashMap;
        }
        try {
            tempUserInfoMap.putAll(userMap);
            int loop_idx = 1;
            for (ConnectInfo conInfo : dbInfoList) {
                ArrayList<Map<String, String>> rapList = new ArrayList<Map<String, String>>();
                String queryType = conInfo.getQUERY_TYPE();
                String looping_key = "";
                StringBuffer buffer = new StringBuffer(128);
                if ("30".equals(queryType)) {
                    looping_key = "rap_" + String.valueOf(loop_idx++);
                }
                if (Constants.MAPPING_QUERY_10.equals(queryType) || "40".equals(queryType) || "50".equals(queryType)) continue;
                isMappingQueryExecute = true;
                long start = System.currentTimeMillis();
                TmsJdbcTemplate jdbcTemplate = jdbcMap.get(conInfo.getDB_ID());
                String query = conInfo.getQUERY();
                if ("20".equals(queryType)) {
                    query = this.addConvertQuery(query, conInfo.getDB_TYPE());
                }
                if (query.indexOf("@{") > -1) {
                    StringConvertUtil.ConvertString(buffer, query, tempUserInfoMap, "@{", "}", false, false);
                } else {
                    buffer.append(query);
                }
                ArrayList<KeyValueInfo> kvList = new ArrayList<KeyValueInfo>();
                List resList = new ArrayList();
                List resListLink = new ArrayList();
                if ("70".equals(queryType)) {
                    resListLink = jdbcTemplate.selectListLinkedHashMap(buffer.toString());
                    for (Map<String, String> resultMap : resListLink) {
                        Iterator iter = ((LinkedHashMap)resultMap).entrySet().iterator();
                        KeyValueInfo kvInfo = new KeyValueInfo();
                        int i = 1;
                        while (iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            String key = String.valueOf(entry.getKey());
                            String value = String.valueOf(entry.getValue());
                            if (i % 2 == 0) {
                                kvInfo.setValues(StringUtil.isNull(value) || "null".equalsIgnoreCase(value) ? "" : value);
                            } else {
                                if (StringUtil.isNull(value) || "null".equalsIgnoreCase(value)) {
                                    log.error("MP5303| KeyValue Mapping key is NULL : memberId:{}", userMap.get(Column.TMS_M_ID));
                                    throw new Exception("[ERROR] KeyValue Mapping key is NULL : memberId:" + userMap.get(Column.TMS_M_ID));
                                }
                                kvInfo.setKeys(value);
                            }
                            kvList.add(kvInfo);
                            ++i;
                        }
                    }
                } else {
                    resList = jdbcTemplate.selectList(buffer.toString());
                    for (Map<String, String> resultMap : resList) {
                        Set key = resultMap.keySet();
                        Iterator iter = key.iterator();
                        while (iter.hasNext()) {
                            String keyName = String.valueOf(iter.next());
                            String value = String.valueOf(resultMap.get(keyName));
                            if (!"30".equals(queryType)) {
                                tempUserInfoMap.put(keyName, StringUtil.isNull(value) || "null".equalsIgnoreCase(value) ? "" : value);
                                continue;
                            }
                            resultMap.put(keyName, StringUtil.isNull(value) || "null".equalsIgnoreCase(value) ? "" : value);
                        }
                        if (!"30".equals(queryType)) continue;
                        rapList.add(resultMap);
                    }
                }
                if (kvList.size() > 0) {
                    for (KeyValueInfo info : kvList) {
                        if (StringUtil.isNull(info.getKeys())) continue;
                        tempUserInfoMap.put(info.getKeys(), info.getValues());
                    }
                }
                if ("20".equals(queryType) && resList.size() > 1) {
                    log.error("[ERROR] Simple Mapping Result Count Over -> queryId [{}] size [{}] memberId [{}]", new Object[]{conInfo.getQUERY_ID(), resList.size(), userMap.get(Column.TMS_M_ID)});
                    throw new Exception("[ERROR] Simple Mapping Result Count Over");
                }
                if ("30".equals(queryType)) {
                    tempUserInfoMap.put(looping_key, rapList);
                }
                long end = System.currentTimeMillis();
                log.info("[END] \ub9e4\ud551\ucffc\ub9ac 1\uac1c \uc644\ub8cc. SEND_ID:[{}] TMS_M_ID:[{}] queryId [{}] resultSize [{}] ==========================[{}]", new Object[]{campProp.getProperty(Column.SEND_ID, "sendId"), userMap.get(Column.TMS_M_ID), conInfo.getQUERY_ID(), rapList.size(), (double)(end - start) / 1000.0 + " \ucd08"});
                tempUserInfoMap.putAll(userMap);
            }
        }
        catch (Exception e) {
            try {
                log.error("MP5303|convertMapping Fail :{}", (Object)e.getMessage());
                throw new Exception("[ERROR] convertMapping Fail :" + e);
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (isMappingQueryExecute) {
                    log.info("[END] \ub9e4\ud551\ucffc\ub9ac \uc804\uccb4 \uc644\ub8cc \uc2dc\uac04. \uc804\uccb4 \ucffc\ub9ac \uac2f\uc218:[{}], SEND_ID:[{}] TMS_M_ID [{}] ==========================[{}]", new Object[]{dbInfoList.size(), campProp.getProperty(Column.SEND_ID, "sendId"), userMap.get(Column.TMS_M_ID), (double)(endT - startT) / 1000.0 + " \ucd08"});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (isMappingQueryExecute) {
            log.info("[END] \ub9e4\ud551\ucffc\ub9ac \uc804\uccb4 \uc644\ub8cc \uc2dc\uac04. \uc804\uccb4 \ucffc\ub9ac \uac2f\uc218:[{}], SEND_ID:[{}] TMS_M_ID [{}] ==========================[{}]", new Object[]{dbInfoList.size(), campProp.getProperty(Column.SEND_ID, "sendId"), userMap.get(Column.TMS_M_ID), (double)(endT - startT) / 1000.0 + " \ucd08"});
        }
        return tempUserInfoMap;
    }

    @Override
    public MappingInfo getMappingData(Properties campProp) throws Exception {
        MappingInfo mminfo = new MappingInfo();
        ArrayList<ConnectInfo> connectionList = new ArrayList<ConnectInfo>();
        TreeMap<String, TmsJdbcTemplate> jdbcMap = new TreeMap<String, TmsJdbcTemplate>();
        String targetId = (String)campProp.get(Column.TARGET_ID);
        try {
            List<Map<String, Object>> queryInfoList = this.mapperDao.getMappingQueryInfo(targetId);
            if (queryInfoList.size() > 0) {
                for (Map<String, Object> map : queryInfoList) {
                    ConnectInfo connectionInfo = new ConnectInfo();
                    connectionInfo.setDB_ID(String.valueOf(map.get(Column.DB_ID)));
                    connectionInfo.setDB_TYPE(String.valueOf(map.get(Column.DB_TYPE)));
                    connectionInfo.setQUERY_ID(String.valueOf(map.get(Column.QUERY_ID)));
                    connectionInfo.setDB_NAME(String.valueOf(map.get(Column.DB_NAME)));
                    connectionInfo.setDRIVER(String.valueOf(map.get(Column.CONNECT_DRIVER)));
                    connectionInfo.setDB_URL(String.valueOf(map.get(Column.CONNECT_IP)));
                    connectionInfo.setDB_UID(String.valueOf(map.get(Column.CONNECT_ID)));
                    connectionInfo.setDB_PASS(String.valueOf(map.get(Column.CONNECT_PWD)));
                    connectionInfo.setDB_BASE_CHARSET(String.valueOf(map.get(Column.BASE_CHARSET)));
                    connectionInfo.setDB_IN_CHARSET(String.valueOf(map.get(Column.IN_CHARSET)));
                    connectionInfo.setDB_OUT_CHARSET(String.valueOf(map.get(Column.OUT_CHARSET)));
                    connectionInfo.setQUERY_SEQ(String.valueOf(map.get(Column.QUERY_SEQ)));
                    connectionInfo.setQUERY_TYPE(String.valueOf(map.get(Column.QUERY_TYPE)));
                    connectionInfo.setENCRYPT_YN(String.valueOf(map.get(Column.ENCRYPT_YN)));
                    connectionInfo.setQUERY(String.valueOf(map.get(Column.QUERY_SELECT)));
                    connectionInfo.setAPPEND_NULL("Y".equalsIgnoreCase(String.valueOf(map.get(Column.APPEND_NULL)) == null ? "N" : String.valueOf(map.get(Column.APPEND_NULL))));
                    String decPasswd = this.encryptDecrypter.stringDecrypt(String.valueOf(map.get(Column.CONNECT_PWD)));
                    if ("40".equals(connectionInfo.getQUERY_TYPE())) continue;
                    if (!jdbcMap.containsKey(connectionInfo.getDB_ID())) {
                        TmsJdbcTemplate jdbcTemplate = (TmsJdbcTemplate)ClassDispatcher.getApplicationContext().getBean(TmsJdbcTemplate.class);
                        map.put(Column.DB_DRV, String.valueOf(map.get(Column.CONNECT_DRIVER)));
                        map.put(Column.DB_URL, String.valueOf(map.get(Column.CONNECT_IP)));
                        map.put(Column.DB_USR, String.valueOf(map.get(Column.CONNECT_ID)));
                        map.put(Column.DB_PWD, String.valueOf(map.get(Column.CONNECT_PWD)));
                        jdbcMap.put(connectionInfo.getDB_ID(), jdbcTemplate.db(TmsBatchDataSourceManager.INSTANCE.getDataSource(map)));
                    }
                    connectionList.add(connectionInfo);
                }
            } else {
                log.error("MP5302|queryInfoList size zero");
                throw new Exception("[ERROR] queryInfoList size zero");
            }
            mminfo.setConnectionList(connectionList);
            mminfo.setTmsJdbcMap(jdbcMap);
        }
        catch (Exception e) {
            log.error("MP5301|getMappingData Fail:{}", (Throwable)e);
            throw new Exception("[ERROR] getMappingData Fafil:{}" + e);
        }
        return mminfo;
    }

    @Override
    public String convertMappingExecutor(String result, Map<String, Object> userMap, Properties campProp, String source, Template template) throws Exception {
        if (!StringUtil.isNull(source)) {
            try {
                result = this.customizingMappingString(userMap, result, campProp, source, template);
            }
            catch (Exception e) {
                throw new Exception("[ERROR] customizingMappingString() Fail:" + e.getMessage());
            }
        }
        String contentPath = (String)campProp.get(Column.CONTENT_PATH);
        if (contentPath != null && contentPath.indexOf(".html") > -1) {
            String path = contentPath.substring(0, contentPath.lastIndexOf("/"));
            String[] contentArray = contentPath.split("/");
            String fileName = contentArray[contentArray.length - 1];
            try {
                result = this.customizingMappingFile(path, fileName, userMap, result);
            }
            catch (Exception e) {
                throw new Exception("[ERROR] customizingMappingFile() Fail:" + e.getMessage());
            }
        }
        return result;
    }

    @Override
    public synchronized String customizingMappingString(Map<String, Object> userMap, String result, Properties campProp, String source, Template template) throws Exception {
        eMsStringWriter writerStringBuffer = null;
        PrintWriter writerContentComposer = null;
        try {
            if (source.indexOf("&MEMBER_ID=${ENC_MEMBER_ID}") > -1) {
                source = source.replace("${ENC_MEMBER_ID}", String.valueOf(userMap.get("ENC_MEMBER_ID")));
            }
            if (source.indexOf("&MEMBER_ID_SEQ=${UNIQUE_SEQ}") > -1) {
                source = source.replace("${UNIQUE_SEQ}", String.valueOf(userMap.get(Column.UNIQUE_SEQ)));
            }
            if (source.indexOf("${TMS_M_ID}") > -1) {
                source = source.replace("${TMS_M_ID}", String.valueOf(userMap.get(Column.TMS_M_ID)));
            }
            if (source.indexOf("${TMS_M_NAME}") > -1) {
                source = source.replace("${TMS_M_NAME}", String.valueOf(userMap.get(Column.TMS_M_NAME)));
            }
            if (source.indexOf("${TMS_M_EMAIL}") > -1) {
                source = source.replace("${TMS_M_EMAIL}", String.valueOf(userMap.get(Column.TMS_M_EMAIL)));
            }
            if (source.indexOf("${TMS_M_PHONE}") > -1) {
                source = source.replace("${TMS_M_PHONE}", String.valueOf(userMap.get(Column.TMS_M_PHONE)));
            }
            if (source.indexOf("${") < 0) {
                String string = source;
                return string;
            }
            if (this.cfg == null) {
                this.cfg = this.configFreeMarker();
            }
            writerStringBuffer = new eMsStringWriter();
            writerContentComposer = new PrintWriter(writerStringBuffer);
            writerContentComposer.flush();
            writerStringBuffer.reset();
            template.process(userMap, (Writer)writerContentComposer);
            writerContentComposer.flush();
            result = writerStringBuffer.toString();
        }
        catch (Exception e) {
            log.error("MP5306|freeMarker(String) Mapping Fail -> id:[{}] detail: {}", userMap.get(Column.TMS_M_ID), (Object)e);
            throw new Exception("freeMarker(String) Mapping Fail");
        }
        finally {
            if (writerStringBuffer != null) {
                writerStringBuffer.close();
                writerStringBuffer = null;
            }
            if (writerContentComposer != null) {
                writerContentComposer.close();
                writerContentComposer = null;
            }
        }
        return result;
    }

    @Override
    public String customizingMappingFile(String path, String fileName, Map<String, Object> userMap, String result) throws Exception {
        eMsStringWriter writerStringBuffer = new eMsStringWriter();
        PrintWriter writerContentComposer = new PrintWriter(writerStringBuffer);
        Template template = null;
        try {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
            cfg.setDirectoryForTemplateLoading(new File(path));
            template = cfg.getTemplate(fileName);
            writerContentComposer.flush();
            writerStringBuffer.reset();
            template.process(userMap, (Writer)writerContentComposer);
            writerContentComposer.flush();
            result = writerStringBuffer.toString();
        }
        catch (Exception e) {
            log.error("MP5307|freeMarker(File) Mapping Fail:{}", (Throwable)e);
            throw new Exception("freeMarker(File) Mapping Fail." + e.getMessage());
        }
        finally {
            if (writerStringBuffer != null) {
                writerStringBuffer.close();
                writerStringBuffer = null;
            }
            if (writerContentComposer != null) {
                writerContentComposer.close();
                writerContentComposer = null;
            }
            if (template != null) {
                template = null;
            }
        }
        return result;
    }

    public Map<String, Object> putInAppValue(Map<String, Object> userMap, Properties campProp) {
        if (!StringUtil.isNull(campProp.getProperty(Column.REQ_DATE, DateUtil.getFullDateDefaultFormat()))) {
            userMap.put(Column.REQ_DATE, campProp.getProperty(Column.REQ_DATE, DateUtil.getFullDateDefaultFormat()));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.REQ_UID, ""))) {
            userMap.put(Column.REQ_UID, campProp.getProperty(Column.REQ_UID, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.MSG_UID, ""))) {
            userMap.put(Column.MSG_UID, campProp.getProperty(Column.MSG_UID, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.PUSH_KEY, ""))) {
            userMap.put(Column.PUSH_KEY, campProp.getProperty(Column.PUSH_KEY, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.APP_GRP_ID, ""))) {
            userMap.put(Column.APP_GRP_ID, campProp.getProperty(Column.APP_GRP_ID, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.PUSH_MSG, "")) && !userMap.containsKey(Column.PUSH_MSG)) {
            userMap.put(Column.PUSH_MSG, campProp.getProperty(Column.PUSH_MSG, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.PUSH_VALUE, "")) && !userMap.containsKey(Column.PUSH_VALUE)) {
            userMap.put(Column.PUSH_VALUE, campProp.getProperty(Column.PUSH_VALUE, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.SUBJECT, "")) && !userMap.containsKey(Column.SUBJECT)) {
            userMap.put(Column.SUBJECT, campProp.getProperty(Column.SUBJECT, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty("PUSH_TRCODE", "")) && !userMap.containsKey("PUSH_TRCODE")) {
            userMap.put("PUSH_TRCODE", campProp.getProperty("PUSH_TRCODE", ""));
        }
        if (!StringUtil.isNull(campProp.getProperty("PUSH_CUSTOM_DATA", "")) && !userMap.containsKey("PUSH_CUSTOM_DATA")) {
            userMap.put("PUSH_CUSTOM_DATA", campProp.getProperty("PUSH_CUSTOM_DATA", ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.SEND_ID, ""))) {
            userMap.put(Column.SEND_ID, campProp.getProperty(Column.SEND_ID, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.SCHD_ID, ""))) {
            userMap.put(Column.SCHD_ID, campProp.getProperty(Column.SCHD_ID, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.WORKDAY, ""))) {
            userMap.put(Column.WORKDAY, campProp.getProperty(Column.WORKDAY, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.TRACKING_CLOSE, ""))) {
            userMap.put(Column.TRACKING_CLOSE, campProp.getProperty(Column.TRACKING_CLOSE, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.CONTENT_TYPE, ""))) {
            userMap.put(Column.CONTENT_TYPE, campProp.getProperty(Column.CONTENT_TYPE, "T"));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.PUSH_IMG, ""))) {
            userMap.put(Column.PUSH_IMG, campProp.getProperty(Column.PUSH_IMG, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.PUSH_TYPE, ""))) {
            userMap.put(Column.PUSH_TYPE, campProp.getProperty(Column.PUSH_TYPE, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.ETC1, ""))) {
            userMap.put(Column.ETC1, campProp.getProperty(Column.ETC1, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.ETC2, ""))) {
            userMap.put(Column.ETC2, campProp.getProperty(Column.ETC2, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.ETC3, ""))) {
            userMap.put(Column.ETC3, campProp.getProperty(Column.ETC3, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.ETC4, ""))) {
            userMap.put(Column.ETC4, campProp.getProperty(Column.ETC4, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.ETC5, ""))) {
            userMap.put(Column.ETC5, campProp.getProperty(Column.ETC5, ""));
        }
        if (!StringUtil.isNull(campProp.getProperty(Column.ETC6, ""))) {
            userMap.put(Column.ETC6, campProp.getProperty(Column.ETC6, ""));
        }
        return userMap;
    }

    public String convertMapToJSONString(Map<String, Object> userMap, String channelType, Map<String, Object> mappingDataMap) throws Exception {
        JSONObject jsonObj = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : userMap.entrySet()) {
                String key = entry.getKey();
                if (key.equals(Column.FIELD_MEMBER_ID) || key.equals("enc_mid") || key.equals("m_id") || key.equals("enc_email") || key.equals("s_id") || key.equals("ENC_MEMBER_ID") || ChannelType.PUSH.same(channelType) && key.indexOf(Column.CONTENT) > -1) continue;
                String value = String.valueOf(entry.getValue());
                jsonObj.put((Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            log.error("MP5504|convertMapToJSONString Fail:" + e);
            throw new Exception("convertMapToJSONString Fail:" + e);
        }
        return jsonObj.toString();
    }

    @Override
    public String putCrsltJsonString(Map<String, Object> userMap, Properties campProp, String targetSeq, Map<String, String> crsltMap) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)Column.ERROR_CODE, (Object)crsltMap.get(Column.ERROR_CODE));
        jsonObj.put((Object)Column.ERROR_DETAIL, (Object)crsltMap.get(Column.ERROR_DETAIL));
        jsonObj.put((Object)Column.RESULT_TYPE, (Object)"S");
        jsonObj.put((Object)Column.WORKDAY, campProp.get(Column.WORKDAY));
        jsonObj.put((Object)Column.SCHD_ID, campProp.get(Column.SCHD_ID));
        jsonObj.put((Object)Column.SERVER_ID, (Object)(this.daemonType + this.daemonId));
        jsonObj.put((Object)Column.SITE_ID, campProp.get(Column.SITE_ID));
        jsonObj.put((Object)Column.TARGET_SEQ, (Object)targetSeq);
        jsonObj.put((Object)Column.MEMBER_ID, userMap.get(Column.TMS_M_ID));
        jsonObj.put((Object)Column.UNIQUE_SEQ, userMap.get(Column.UNIQUE_SEQ));
        jsonObj.put((Object)Column.DOMAIN, userMap.get(Column.DOMAIN));
        jsonObj.put((Object)Column.START_TIME, (Object)DateUtil.getFullDateDefaultFormat());
        jsonObj.put((Object)Column.END_TIME, (Object)DateUtil.getFullDateDefaultFormat());
        return jsonObj.toString();
    }

    @Override
    public Map<String, String> putErrorCodeDetail(String errorCode, String errorDetail, Map<String, String> map) {
        map.put(Column.ERROR_CODE, errorCode);
        map.put(Column.ERROR_DETAIL, errorDetail);
        return map;
    }

    public String addConvertQuery(String sql, String dbType) {
        String convertSql = sql;
        convertSql = DBType.DB2 == DBTypeDetector.databaseType((String)dbType) ? " SELECT A.*     FROM \t          ( \t  " + sql + "        ) A           RIGHT OUTER JOIN ( SELECT '' FROM SYSIBM.SYSDUMMY1) B ON ( 1=1 )   " : " SELECT A.*     FROM \t          ( \t  " + sql + "        ) A           RIGHT OUTER JOIN ( SELECT '' FROM DUAL) B ON ( 1=1 )   ";
        return convertSql;
    }

    public List<Map<String, Object>> putDynamicAttachAdd(Map<String, Object> userMap, List<Map<String, Object>> dynamicAttachList) {
        HashMap<String, String> attachMap = new HashMap<String, String>();
        int cnt = 0;
        for (Map.Entry<String, Object> entry : userMap.entrySet()) {
            String key = entry.getKey();
            String value = (String)entry.getValue();
            if (key.indexOf("ATTACH_") == 0 && key.indexOf("NAME") == -1 && key.indexOf("URL") == -1 && key.indexOf("CHARSET") == -1) {
                ++cnt;
                attachMap.put(key, value);
                continue;
            }
            if (key.indexOf("ATTACH_") != 0 || key.indexOf("_NAME") <= 0) continue;
            attachMap.put(key, value);
        }
        for (int i = 0; i < cnt; ++i) {
            HashMap<String, String> attachMap2 = new HashMap<String, String>();
            String pathKey = "ATTACH_" + String.valueOf(i + 1);
            String pathValue = (String)attachMap.get(pathKey);
            String nameKey = pathKey + "_NAME";
            String nameValue = "";
            if (pathValue.indexOf("http:") > -1 || pathValue.indexOf("https:") > -1) {
                attachMap2.put(Column.ATTACH_URL, pathValue);
            } else {
                attachMap2.put(Column.ATTACH_PATH, pathValue);
            }
            nameValue = StringUtil.isNull((String)attachMap.get(nameKey)) || !attachMap.containsKey(nameKey) ? pathValue.substring(pathValue.lastIndexOf("/") + 1) : (String)attachMap.get(nameKey);
            attachMap2.put(Column.ATTACH_NAME, nameValue);
            attachMap2.put(Column.ATTACH_CHARSET, "UTF-8");
            dynamicAttachList.add(attachMap2);
        }
        return dynamicAttachList;
    }

    @Override
    public boolean saveMapData(Map<String, Object> map, String mapFullPath, String memberId, String nlsLang) {
        JSONObject mapJson = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                JSONArray mapJsonArr = new JSONArray();
                if (entry.getKey().indexOf("rap_") > -1) {
                    List rapList = (List)entry.getValue();
                    for (int i = 0; i < rapList.size(); ++i) {
                        Map tempMap = (Map)rapList.get(i);
                        JSONObject jsonObj = new JSONObject();
                        try {
                            for (Map.Entry entry2 : tempMap.entrySet()) {
                                String key = (String)entry2.getKey();
                                String value = String.valueOf(entry2.getValue());
                                jsonObj.put((Object)key, (Object)value);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5504|convertMapToJSONString Fail:" + e);
                            return false;
                        }
                        mapJsonArr.add((Object)JsonUtil.getMapFromJson((String)jsonObj.toString()));
                    }
                    mapJson.put((Object)entry.getKey(), (Object)mapJsonArr);
                    continue;
                }
                if (entry.getKey().indexOf("TMS_M_ID") > -1 || entry.getKey().indexOf("TMS_M_NAME") > -1 || entry.getKey().indexOf("TMS_M_EMAIL") > -1 || entry.getKey().indexOf("TMS_M_PHONE") > -1 || entry.getKey().indexOf("TMS_M_TARGET") > -1) continue;
                mapJson.put((Object)entry.getKey(), (Object)((String)entry.getValue()));
            }
            String folderPath = mapFullPath.substring(0, mapFullPath.lastIndexOf("/"));
            File folder = new File(folderPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (!this.contentReadWrite.saveFullContentFile(mapFullPath, mapJson.toString(), nlsLang)) {
                log.error("MP4001|MappingContent save Fail :{}", (Object)memberId);
                return false;
            }
        }
        catch (Exception e) {
            log.error("MP5504|saveMappingData Fail:" + e);
            return false;
        }
        return true;
    }

    public boolean checkByte(Map<String, Object> userMap, String fileSaveByte) {
        JSONObject mapJson = new JSONObject();
        Iterator<Map.Entry<String, Object>> iter = userMap.entrySet().iterator();
        try {
            while (iter.hasNext()) {
                JSONArray mapJsonArr = new JSONArray();
                Map.Entry<String, Object> entry = iter.next();
                String value = "";
                value = entry.getValue() == null ? "" : (entry.getValue() instanceof Long ? Long.toString((Long)entry.getValue()) : String.valueOf(entry.getValue()));
                mapJson.put((Object)entry.getKey(), (Object)value);
            }
            int mapSize = StringUtil.checkByteEnKrEtc(mapJson.toString());
            return mapSize > Integer.parseInt(fileSaveByte);
        }
        catch (Exception e) {
            log.error("MP5504|check Byte Data Fail:" + e);
            return false;
        }
    }

    public Map<String, Object> addAttachList(List<Map<String, Object>> attachList, List<Map<String, Object>> dynamicAttachList, Map<String, Object> userMap) throws Exception {
        if (attachList.size() > 0 && dynamicAttachList.size() > 0) {
            log.error("MP5505|MMS attachList exist AND dynamicAttachList exist");
            throw new Exception("MMS attachList exist AND dynamicAttachList exist");
        }
        try {
            String attachKey;
            Map<String, Object> attachMap;
            int i;
            for (i = 0; i < attachList.size(); ++i) {
                attachMap = attachList.get(i);
                attachKey = "ATTACH_" + String.valueOf(i + 1);
                if (attachMap.containsKey(Column.ATTACH_URL)) {
                    userMap.put(attachKey, attachMap.get(Column.ATTACH_URL));
                    continue;
                }
                if (!attachMap.containsKey(Column.ATTACH_PATH)) continue;
                userMap.put(attachKey, attachMap.get(Column.ATTACH_PATH));
            }
            for (i = 0; i < dynamicAttachList.size(); ++i) {
                attachMap = dynamicAttachList.get(i);
                attachKey = "ATTACH_" + String.valueOf(i + 1);
                if (attachMap.containsKey(Column.ATTACH_URL)) {
                    userMap.put(attachKey, attachMap.get(Column.ATTACH_URL));
                    continue;
                }
                if (!attachMap.containsKey(Column.ATTACH_PATH)) continue;
                userMap.put(attachKey, attachMap.get(Column.ATTACH_PATH));
            }
        }
        catch (Exception e) {
            log.error("MP5505|MMS attachList/dynamicAttachList Parsing Error:{}", (Throwable)e);
            throw new Exception("MMS ttachList/dynamicAttachList Parsing Error." + e.getMessage());
        }
        return userMap;
    }

    @Override
    public String convertMappingExecutor(String result, Map<String, Object> userMap, Properties campProp, String source) throws Exception {
        if (!StringUtil.isNull(source)) {
            Template template = new Template("name", (Reader)new StringReader(source), this.cfg);
            try {
                result = this.customizingMappingString(userMap, result, campProp, source, template);
            }
            catch (Exception e) {
                throw new Exception("[ERROR] customizingMappingString() Fail:" + e.getMessage());
            }
            finally {
                if (template != null) {
                    template = null;
                }
            }
        }
        String contentPath = (String)campProp.get(Column.CONTENT_PATH);
        if (contentPath != null && contentPath.indexOf(".html") > -1) {
            String path = contentPath.substring(0, contentPath.lastIndexOf("/"));
            String[] contentArray = contentPath.split("/");
            String fileName = contentArray[contentArray.length - 1];
            try {
                result = this.customizingMappingFile(path, fileName, userMap, result);
            }
            catch (Exception e) {
                throw new Exception("[ERROR] customizingMappingFile() Fail:" + e.getMessage());
            }
        }
        return result;
    }
}

