/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.filter;

import com.humuson.tms.mapper.mq.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MapperSkipper {
    private static final Logger log = LoggerFactory.getLogger(MapperSkipper.class);
    @Autowired
    private DefaultMQProducer defaultMQProducer;
    @Value(value="${wt.sleep-time:20000}")
    private int sleepTime;
    @Value(value="${mapper.memory-check.sleep-time:20000}")
    private int mpSleepTime;

    public void skip(String situation, String destination, String message) throws Exception {
        if (situation.equalsIgnoreCase("WT")) {
            log.info("[MapperSkipper] HDD Size Over Sleep {} Seconds after will resending to {} => {}", new Object[]{this.sleepTime / 1000, message, destination, message});
        } else if (situation.equalsIgnoreCase("MEMORY")) {
            log.debug("START GARBAGE COLLECTOR ============");
            try {
                System.gc();
            }
            catch (Exception e) {
                log.debug("[ERROR] GARBAGE colloertor has an error : {} ", (Throwable)e);
            }
            log.info("[MapperSkipper] MP Use Memroy Critical Over Sleep {} Second after will resending to {} => {}", new Object[]{this.mpSleepTime / 1000, message, destination, message});
        }
        Thread.sleep(this.mpSleepTime);
        this.defaultMQProducer.send(destination, message);
        log.info("[MapperSkipper] Resended queue: {} => message:{} . SENDED", new Object[]{this.mpSleepTime / 1000, message, destination, message});
    }
}

