/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.filter;

import com.humuson.tms.config.ChannelType;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.mapper.filter.Filter;
import com.humuson.tms.mapper.util.FileUtil;
import com.humuson.tms.mapper.util.StringUtil;
import com.humuson.tms.mapper.util.eMsLocale;
import com.humuson.tms.util.StringUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent
public class DefaultFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DefaultFilter.class);
    @Value(value="${mapper.sms.max-byte}")
    public String smsMaxByte;
    @Value(value="${mapper.lms.max-byte}")
    public String lmsMaxByte;
    @Value(value="${mapper.attach-check.max-size}")
    public int attachCheckMaxSize;

    @Override
    public boolean userInfoFilter(Map<String, Object> userMap, String channelType) {
        try {
            if (ChannelType.EMAIL.same(channelType) ? StringUtils.isEmailError((String)String.valueOf(userMap.get(Column.TMS_M_EMAIL))) : (ChannelType.SMS.same(channelType) || ChannelType.KAKAO.same(channelType)) && StringUtils.isSmsError((String)String.valueOf(userMap.get(Column.TMS_M_PHONE)))) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("CM0501|userInfoFilter ERROR:{}", (Throwable)e);
            return true;
        }
        return false;
    }

    @Override
    public boolean contentFilter(String content, String channelType, String channelTypeSub, String memberId, String switchFlag) {
        block5: {
            try {
                if (!ChannelType.SMS.same(channelType)) break block5;
                if (StringUtil.isNull(content)) {
                    log.error("CM0501| after Mapping Content is null : memberId:{}", (Object)memberId);
                    return true;
                }
                if (ChannelType.LMS.getName().equals(channelTypeSub) || ChannelType.MMS.getName().equals(channelTypeSub)) break block5;
                if (ChannelType.SMS.getName().equals(channelTypeSub)) {
                    int contentByte;
                    if ("L".equals(switchFlag) && (contentByte = StringUtil.checkByteEnKrEtc(content.trim())) > Integer.parseInt(this.lmsMaxByte)) {
                        log.error("MP5401|content maxByte[{}]  Over contentByte[{}] / memberId:[{}] / switchFlag:[{}], fullContent:[{}]", new Object[]{this.lmsMaxByte, contentByte, memberId, switchFlag, content});
                        return true;
                    }
                    break block5;
                }
                log.error("CM0501|Invalid ChannelTypeSub :[{}]", (Object)channelTypeSub);
                return true;
            }
            catch (Exception e) {
                log.error("MP5501|contentFilter ERROR:{}", (Throwable)e);
                return true;
            }
        }
        return false;
    }

    @Override
    public String exchangeChannelTypeSub(String content, String channelType, String channelTypeSub, String switchFlag, List<Map<String, Object>> attachList, List<Map<String, Object>> dynamicAttachList) throws Exception {
        if (ChannelType.SMS.same(channelType)) {
            if ((ChannelType.SMS.getName().equals(channelTypeSub) || ChannelType.LMS.getName().equals(channelTypeSub)) && dynamicAttachList.size() > 0) {
                log.error("MP5502|exchangeChannelTypeSub() ERROR -> channelTypeSub[{}] dynamicAttachList.size [{}]", (Object)channelTypeSub, (Object)dynamicAttachList.size());
                throw new Exception("[ERROR] exchangeChannelTypeSub() ERROR");
            }
            try {
                if (ChannelType.SMS.getName().equals(channelTypeSub) && "L".equals(switchFlag)) {
                    if (StringUtil.checkByteEnKrEtc(content.trim()) > Integer.parseInt(this.smsMaxByte)) {
                        channelTypeSub = ChannelType.LMS.getName();
                    }
                } else if (ChannelType.LMS.getName().equals(channelTypeSub) && "S".equals(switchFlag)) {
                    if (StringUtil.checkByteEnKrEtc(content.trim()) <= Integer.parseInt(this.smsMaxByte)) {
                        channelTypeSub = ChannelType.SMS.getName();
                    }
                } else if (ChannelType.MMS.getName().equals(channelTypeSub) && "L".equals(switchFlag)) {
                    boolean isAttachUrl = false;
                    boolean isAttachPath = false;
                    boolean isDynamicAttachUrl = false;
                    boolean isDynamicAttachPath = false;
                    if (attachList.size() > 0) {
                        if (attachList.get(0).containsKey(Column.ATTACH_URL) && !StringUtil.isNull((String)attachList.get(0).get(Column.ATTACH_URL))) {
                            isAttachUrl = true;
                        }
                        if (attachList.get(0).containsKey(Column.ATTACH_PATH) && !StringUtil.isNull((String)attachList.get(0).get(Column.ATTACH_PATH))) {
                            isAttachPath = true;
                        }
                    }
                    if (dynamicAttachList.size() > 0) {
                        if (dynamicAttachList.get(0).containsKey(Column.ATTACH_URL) && !StringUtil.isNull((String)dynamicAttachList.get(0).get(Column.ATTACH_URL))) {
                            isDynamicAttachUrl = true;
                        }
                        if (dynamicAttachList.get(0).containsKey(Column.ATTACH_PATH) && !StringUtil.isNull((String)dynamicAttachList.get(0).get(Column.ATTACH_PATH))) {
                            isDynamicAttachPath = true;
                        }
                    }
                    if (attachList.size() == 0 && dynamicAttachList.size() == 0 || !isAttachUrl && !isAttachPath && !isDynamicAttachUrl && !isDynamicAttachPath) {
                        channelTypeSub = ChannelType.LMS.getName();
                    }
                }
            }
            catch (Exception e) {
                log.error("MP5502|exchangeChannelTypeSub ERROR:{}", (Throwable)e);
                return channelTypeSub;
            }
        }
        return channelTypeSub;
    }

    @Override
    public String inValidCheck(Properties campProp, String sendId, String schdId) {
        String error = "";
        if (campProp.isEmpty()) {
            error = "CM0501|PINFO data is Empty";
            return error;
        }
        String channelType = (String)campProp.get(Column.CHANNEL_TYPE);
        if (StringUtil.isNull(channelType)) {
            error = "CM0501|InValid CHANNEL_TYPE false";
            return error;
        }
        if (!campProp.getProperty(Column.SEND_ID).equals(sendId)) {
            error = "CM0501|InValid SEND_ID false";
            return error;
        }
        if (!campProp.getProperty(Column.SCHD_ID).equals(schdId)) {
            error = "CM0501|InValid SCHD_ID false";
            return error;
        }
        if (ChannelType.EMAIL.same(channelType)) {
            if (StringUtil.isNull((String)campProp.get(Column.FROM_NAME))) {
                error = "CM0501|FROM_NAME is Null";
                return error;
            }
            if (StringUtil.isNull((String)campProp.get(Column.FROM_EMAIL))) {
                error = "CM0501|FROM_EMAIL is Null";
                return error;
            }
            if (StringUtil.isNull((String)campProp.get(Column.RETURN_PATH))) {
                error = "CM0501|RETURN_PATH is Null";
                return error;
            }
            if (StringUtil.isNull((String)campProp.get(Column.SUBJECT))) {
                error = "CM0501|SUBJECT is Null";
                return error;
            }
        } else if (ChannelType.SMS.same(channelType)) {
            if (StringUtil.isNull((String)campProp.get(Column.FROM_NUMBER))) {
                error = "CM0501|FROM_NUMBER is Null";
                return error;
            }
        } else if (ChannelType.PUSH.same(channelType)) {
            if (StringUtil.isNull((String)campProp.get(Column.PUSH_MSG)) && !"OM".equals(campProp.getProperty(Column.PUSH_TYPE))) {
                error = "CM0501|PUSH_MSG is Null";
                return error;
            }
        } else if (ChannelType.KAKAO.same(channelType) && !((String)campProp.get(Column.SWITCH_FLAG)).equals("N") && StringUtil.isNull((String)campProp.get(Column.FROM_NUMBER))) {
            error = "CM0501|FROM_NUMBER is Null";
            return error;
        }
        return error;
    }

    @Override
    public boolean checkAttachSize(List<Map<String, Object>> attachList) {
        boolean res = false;
        try {
            int fileCnt = 0;
            for (Map<String, Object> attachMap : attachList) {
                ++fileCnt;
                byte[] file = null;
                if (StringUtil.isNull((String)attachMap.get(Column.ATTACH_URL))) {
                    return res;
                }
                file = FileUtil.readUrlToByteArray((String)attachMap.get(Column.ATTACH_URL), eMsLocale.CHAR_SET);
                DecimalFormat df = new DecimalFormat("#0");
                String fileSizeMB = df.format(file.length / 0x100000);
                log.info("[{}] ATTACH_URL:{} / FileSize:{} MB / checkSize:{} MB / FileName:{} ", new Object[]{fileCnt, attachMap.get(Column.ATTACH_URL), Integer.parseInt(fileSizeMB), this.attachCheckMaxSize, attachMap.get(Column.ATTACH_NAME)});
                if (this.attachCheckMaxSize >= Integer.parseInt(fileSizeMB)) continue;
                log.error("[{}] AttachFile Size Over ==> ATTACH_URL:{} / FileSize:{} MB / checkSize:{} MB / FileName:{} ", new Object[]{fileCnt, attachMap.get(Column.ATTACH_URL), Integer.parseInt(fileSizeMB), this.attachCheckMaxSize, attachMap.get(Column.ATTACH_NAME)});
                res = true;
            }
        }
        catch (Exception e) {
            log.error("[ERROR] \ucca8\ubd80\ud30c\uc77c \uc6a9\ub7c9 \uccb4\ud06c \uc624\ub958. ", (Throwable)e);
        }
        return res;
    }
}

