/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.encdec;

import com.humuson.tms.config.ChannelType;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.crypto.HumusonEncryptor;
import com.humuson.tms.mapper.encdec.EncryptDecrypter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent
public class DefaultEncryptDecrypter
implements EncryptDecrypter {
    private static final Logger log = LoggerFactory.getLogger(DefaultEncryptDecrypter.class);
    @Value(value="${tms.security.encrypt-key}")
    public String encKey;

    @Override
    public Map<String, Object> userInfoDecrypt(Map<String, Object> userMap, String channelType, String encryptYn) {
        if ("Y".equals(encryptYn) && !ChannelType.PUSH.same(channelType)) {
            String target = (String)userMap.get(Column.TMS_M_TARGET);
            try {
                target = HumusonDecryptor.decrypt((String)target, (String)this.encKey);
            }
            catch (Exception e) {
                target = (String)userMap.get(Column.TMS_M_TARGET);
                log.error("Decrypt error. target:[{}] error:{}", (Object)target, (Object)e.getMessage());
            }
            userMap.put(Column.TMS_M_TARGET, target);
            if (ChannelType.EMAIL.same(channelType)) {
                userMap.put(Column.TMS_M_EMAIL, target);
            } else if (ChannelType.SMS.same(channelType) || ChannelType.KAKAO.same(channelType)) {
                userMap.put(Column.TMS_M_PHONE, target);
            }
        }
        return userMap;
    }

    @Override
    public Map<String, Object> userInfoEncrypt(Map<String, Object> userMap, String channelType, String encryptYn, String charSet) {
        if ("Y".equals(encryptYn)) {
            String target = (String)userMap.get(Column.TMS_M_TARGET);
            try {
                target = HumusonEncryptor.encrypt((String)target, (String)this.encKey, (String)charSet);
            }
            catch (Exception e) {
                target = (String)userMap.get(Column.TMS_M_TARGET);
                log.error("Encrypt error. target:[{}] error:{}", (Object)target, (Object)e.getMessage());
            }
            userMap.put(Column.TMS_M_TARGET, target);
            if (ChannelType.EMAIL.same(channelType)) {
                userMap.put(Column.TMS_M_EMAIL, target);
            } else if (ChannelType.SMS.same(channelType) || ChannelType.KAKAO.same(channelType)) {
                userMap.put(Column.TMS_M_PHONE, target);
            }
        }
        return userMap;
    }

    @Override
    public String stringDecrypt(String target) {
        try {
            target = HumusonDecryptor.decrypt((String)target, (String)this.encKey);
        }
        catch (Exception e) {
            log.error("Encrypt error. target:[{}] error:{}", (Object)target, (Object)e.getMessage());
        }
        return target;
    }
}

