/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.config;

import com.humuson.tms.adaptor.activemq.ActivemqConnectorConfig;
import com.humuson.tms.mapper.mq.MQConsumer;
import com.humuson.tms.mapper.mq.TmsDefaultMessageListenerContainer;
import com.humuson.tms.mapper.mq.TmsMessageListenerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableJms
@Configuration
@ConditionalOnClass(value={ActivemqConnectorConfig.class})
public class ActivemqConnectorConfigMapper {
    private static final Logger log = LoggerFactory.getLogger(ActivemqConnectorConfigMapper.class);
    @Value(value="${spring.jms.listener.concurrency}")
    private String concurrency;
    @Value(value="${spring.jms.executor.initSize}")
    private String initSize;
    @Value(value="${spring.jms.executor.maxSize}")
    private String maxSize;
    @Value(value="${spring.jms.executor.capacity}")
    private String capacity;
    @Value(value="${spring.activemq.mapper.consumer.name}")
    private String consumerName;
    @Autowired
    private MQConsumer mqConsumer;
    @Qualifier(value="messageListenerList")
    ConcurrentHashMap<String, TmsDefaultMessageListenerContainer> messageListenerList = new ConcurrentHashMap();

    @Bean(value={"jms.task.executor"})
    public TaskExecutor taskExecutor() throws Exception {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(Integer.parseInt(this.initSize));
        taskExecutor.setMaxPoolSize(Integer.parseInt(this.maxSize));
        taskExecutor.setQueueCapacity(Integer.parseInt(this.capacity));
        taskExecutor.setThreadGroupName("jms.task.executor");
        return taskExecutor;
    }

    @Bean
    public TmsMessageListenerFactory mapperMessageListenerContainer(ConnectionFactory connectionFactory) throws Exception {
        String[] destinationNames;
        TmsMessageListenerFactory tmsChannelFactory = TmsMessageListenerFactory.listenerManager;
        for (String destination : destinationNames = this.consumerName.split(",")) {
            TmsDefaultMessageListenerContainer channelHandlerListener = new TmsDefaultMessageListenerContainer("ActivemqConnectorConfigMapper");
            channelHandlerListener.setConnectionFactory(connectionFactory);
            channelHandlerListener.setDestinationName(destination);
            channelHandlerListener.setMessageListener(this.mqConsumer);
            channelHandlerListener.setConcurrentConsumers(Integer.parseInt(this.concurrency));
            channelHandlerListener.setRecoveryInterval(10000L);
            ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
            taskExecutor.setCorePoolSize(Integer.parseInt(this.concurrency));
            taskExecutor.setMaxPoolSize(Integer.parseInt(this.concurrency));
            taskExecutor.setQueueCapacity(Integer.parseInt(this.capacity));
            taskExecutor.setThreadGroupName("mq.group." + destination);
            taskExecutor.setThreadNamePrefix("mq_" + destination);
            taskExecutor.setBeanName("jms." + destination);
            taskExecutor.afterPropertiesSet();
            channelHandlerListener.setTaskExecutor((Executor)taskExecutor);
            channelHandlerListener.setCacheLevel(3);
            channelHandlerListener.setMaxMessagesPerTask(10);
            channelHandlerListener.setIdleTaskExecutionLimit(10);
            channelHandlerListener.setBeanName("MP_" + destination);
            channelHandlerListener.afterPropertiesSet();
            channelHandlerListener.start();
            this.messageListenerList.put(destination, channelHandlerListener);
        }
        return tmsChannelFactory;
    }

    public ConcurrentHashMap<String, TmsDefaultMessageListenerContainer> getMessageListenerList() {
        return this.messageListenerList;
    }
}

