/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.body;

import com.humuson.tms.config.Column;
import com.humuson.tms.mapper.body.BodyParser;
import com.humuson.tms.mapper.util.BASE64;
import com.humuson.tms.mapper.util.Message;
import com.humuson.tms.mapper.util.MimeConvertor;
import com.humuson.tms.mapper.util.StringConvertUtil;
import com.humuson.tms.mapper.util.StringUtil;
import com.humuson.tms.mapper.util.eMsLocale;
import freemarker20.template.SimpleHash;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SimpleMessage
implements Message {
    private static final Logger log = LoggerFactory.getLogger(SimpleMessage.class);
    protected BodyParser PARSED_CONTENT;
    public static String MESSAGE_ID_TAIL = "@TMS_SMTP_V5.0";
    protected Short CONTENT_TYPE = new Short(2);
    protected Short CONTENT_ENCODING = new Short(4);
    protected String CHAR_SET = null;
    protected String MESSAGE_ID = null;
    protected String CONTENT_NAME = null;
    protected String MESSAGE_HEADER = null;
    protected String contents = null;
    @Value(value="${mapper.mail.smtp.localhost}")
    public String smtpLocalhost;
    private Date myDate = new Date();
    private int MAX_RANDOM_VALUE = 8999;
    private int MIN_RANDOM_VALUE = 1000;
    private Random rnd = new Random();

    public SimpleMessage() {
        int idx1;
        String localHost = this.smtpLocalhost;
        if (StringUtil.isNull(localHost)) {
            localHost = "TMS_SMTP_V5.0";
        }
        if ((idx1 = localHost.indexOf("[")) > -1) {
            int idx2 = localHost.indexOf("]");
            localHost = localHost.substring(idx1 + 1, idx2 > -1 ? idx2 : localHost.length());
        }
        MESSAGE_ID_TAIL = "@" + localHost;
        this.MESSAGE_ID = String.valueOf(System.currentTimeMillis()).concat(MESSAGE_ID_TAIL);
    }

    @Override
    public void setContentType(Short type) {
        this.CONTENT_TYPE = type;
    }

    @Override
    public Short getContentType() {
        return this.CONTENT_TYPE;
    }

    @Override
    public void setCharSet(String charset) {
        this.CHAR_SET = charset;
    }

    @Override
    public String getCharSet() {
        return this.CHAR_SET;
    }

    @Override
    public void setContentEncoding(Short enc_type) {
        this.CONTENT_ENCODING = enc_type;
    }

    @Override
    public Short getContentEncoding() {
        return this.CONTENT_ENCODING;
    }

    @Override
    public void setContent(BodyParser content) {
        this.PARSED_CONTENT = content;
    }

    @Override
    public BodyParser getContent() {
        return this.PARSED_CONTENT;
    }

    public synchronized String convert(Object info1, Object info2, Properties prop) throws Exception {
        StringBuffer buffer = new StringBuffer(2048);
        StringConvertUtil.ConvertString(buffer, this.contents, prop, "${", "}", false, true);
        String tmpString = buffer.toString();
        buffer.setLength(0);
        if (info1 != null) {
            if (!(info1 instanceof Map) && !(info1 instanceof SimpleHash)) {
                throw new RuntimeException("UNSUPPORTED HASH TYPE");
            }
            StringConvertUtil.ConvertString(buffer, tmpString, info1, "${", "}", false, false);
            tmpString = buffer.toString();
            buffer.setLength(0);
        }
        StringConvertUtil.ConvertString(buffer, tmpString, info2, "@{", "}", false, false);
        return buffer.toString();
    }

    @Override
    public void putStringMessageToStreamSimple(Object info1, Properties prop, OutputStream out, String tempContent, String charSet) throws Exception {
        String returnValue = tempContent;
        this.CONTENT_TYPE = new Short(2);
        this.CHAR_SET = eMsLocale.MAIL_BASE_CHAR_SET;
        this.MESSAGE_ID = (String)prop.get(Column.SCHD_ID);
        if (log.isDebugEnabled()) {
            log.debug("message original body", (Object)returnValue);
        }
        short encType = this.CONTENT_ENCODING;
        switch (encType) {
            case 2: {
                MimeConvertor.putMimeToStream(out, returnValue, eMsLocale.MAIL_BASE_CHAR_SET, charSet, encType);
                break;
            }
            case 1: {
                MimeConvertor.putMimeToStream(out, returnValue, eMsLocale.MAIL_BASE_CHAR_SET, charSet, encType);
                break;
            }
            case 3: 
            case 5: {
                MimeConvertor.putMimeToStream(out, returnValue, eMsLocale.MAIL_BASE_CHAR_SET, this.CHAR_SET, encType);
                break;
            }
            default: {
                out.write(returnValue.getBytes(charSet));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("message convert body", (Object)out.toString());
        }
    }

    @Override
    public void putStringMessageToStreamNew(Object info1, Properties prop, OutputStream out) throws Exception {
        String returnValue = out.toString();
        this.CONTENT_TYPE = new Short(5);
        this.CHAR_SET = (String)prop.get(Column.ATTACH_CHARSET);
        this.setContentName((String)prop.get(Column.ATTACH_NAME));
        this.MESSAGE_ID = (String)prop.get(Column.SCHD_ID);
        this.setContentEncoding(new Short(1));
        short encType = this.CONTENT_ENCODING;
        switch (encType) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                MimeConvertor.putMimeToStreamNew(out, returnValue, eMsLocale.MAIL_BASE_CHAR_SET, this.CHAR_SET, encType);
                break;
            }
            default: {
                out.write(returnValue.getBytes(eMsLocale.CHAR_SET));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("message convert body", (Object)out.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putHeaderToStream(OutputStream out, int bodyType, String contentMimeEncodeType) throws Exception {
        MESSAGE_ID_TAIL = "@" + this.smtpLocalhost;
        try {
            switch (bodyType) {
                case 2: {
                    if ("base64".equals(contentMimeEncodeType)) {
                        this.CONTENT_TYPE = 7;
                        this.CONTENT_ENCODING = 1;
                        break;
                    }
                    if ("8bit".equals(contentMimeEncodeType)) {
                        this.CONTENT_TYPE = 2;
                        this.CONTENT_ENCODING = 4;
                        break;
                    }
                    if ("quoted-printable".equals(contentMimeEncodeType)) {
                        this.CONTENT_TYPE = 7;
                        this.CONTENT_ENCODING = 2;
                        break;
                    }
                }
                case 1: {
                    this.CONTENT_TYPE = 5;
                    break;
                }
                default: {
                    this.CONTENT_TYPE = 4;
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("[ERROR] Message Header Init Fail:{}", e);
        }
        StringBuffer buffer = null;
        try {
            FastDateFormat fdf = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
            this.myDate.setTime(System.currentTimeMillis());
            buffer = new StringBuffer(512);
            buffer.append("Message-ID: <");
            buffer.append(fdf.format(this.myDate));
            buffer.append(this.rnd.nextInt(this.MAX_RANDOM_VALUE) + this.MIN_RANDOM_VALUE);
            buffer.append("_TMS");
            buffer.append(MESSAGE_ID_TAIL);
            buffer.append(">\r\n");
            buffer.append("Content-Type: ");
            switch (this.CONTENT_TYPE) {
                case 1: 
                case 3: {
                    buffer.append("text/plain;");
                    break;
                }
                case 2: 
                case 4: {
                    buffer.append("text/html;");
                    break;
                }
                case 5: {
                    buffer.append("application/octet-stream;");
                    break;
                }
                case 6: {
                    buffer.append("image/jpeg;");
                    break;
                }
                default: {
                    buffer.append("text/html;");
                }
            }
            switch (this.CONTENT_TYPE) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    buffer.append("\tcharset=\"");
                    buffer.append(this.CHAR_SET);
                    buffer.append("\"\r\n");
                    break;
                }
                case 5: 
                case 6: {
                    buffer.append("\tname=\"=?");
                    buffer.append(this.CHAR_SET);
                    buffer.append("?B?");
                    buffer.append(BASE64.encode(this.getContentName()));
                    buffer.append("?=\"\r\n");
                    break;
                }
                default: {
                    buffer.append("\tcharset=");
                    buffer.append(this.CHAR_SET);
                    buffer.append("\r\n");
                }
            }
            buffer.append("Content-Transfer-Encoding: ");
            if (this.CONTENT_TYPE == 5 || this.CONTENT_TYPE == 6) {
                buffer.append("base64");
            } else {
                switch (this.CONTENT_ENCODING) {
                    case 1: {
                        buffer.append("base64");
                        break;
                    }
                    case 2: {
                        buffer.append("quoted-printable");
                        break;
                    }
                    case 3: {
                        buffer.append("uuencode");
                        break;
                    }
                    case 4: {
                        buffer.append("8bit");
                        break;
                    }
                    case 5: {
                        buffer.append("7bit");
                        break;
                    }
                    default: {
                        buffer.append("8bit");
                    }
                }
            }
            buffer.append("\r\n");
            if (this.CONTENT_TYPE == 5 || this.CONTENT_TYPE == 4) {
                buffer.append("Content-Disposition: attachment;\r\n");
                buffer.append("\tfilename=\"=?");
                buffer.append(this.CHAR_SET);
                buffer.append("?B?");
                buffer.append(BASE64.encode(this.getContentName()));
                buffer.append("?=\"\r\n");
            }
            if (this.CONTENT_TYPE == 6) {
                buffer.append("Content-ID: <");
                buffer.append(this.getMessageID());
                buffer.append(">\r\n");
            }
            this.MESSAGE_HEADER = buffer.toString();
            out.write(this.MESSAGE_HEADER.getBytes(eMsLocale.CHAR_SET));
        }
        finally {
            buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putHeaderToStreamMime(OutputStream out, int bodyType, String contentMimeEncodeType, String boundary) throws Exception {
        MESSAGE_ID_TAIL = "@" + this.smtpLocalhost;
        StringBuffer buffer = null;
        try {
            FastDateFormat fdf = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
            this.myDate.setTime(System.currentTimeMillis());
            buffer = new StringBuffer(512);
            buffer.append("Message-ID: <");
            buffer.append(fdf.format(this.myDate));
            buffer.append(this.rnd.nextInt(this.MAX_RANDOM_VALUE) + this.MIN_RANDOM_VALUE);
            buffer.append("_TMS");
            buffer.append(MESSAGE_ID_TAIL);
            buffer.append(">\r\n");
            buffer.append("Content-Type: multipart/mixed;");
            buffer.append("\tboundary=\"");
            buffer.append(boundary);
            buffer.append("\"\r\n\r\n");
            out.write(buffer.toString().getBytes());
        }
        finally {
            buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putHeaderToStreamAttach(OutputStream out, Map<String, Object> attachMap, Properties campProp, Map<String, Object> userMap, boolean isContent) throws Exception {
        StringBuffer buffer = null;
        try {
            FastDateFormat fdf = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
            this.myDate.setTime(System.currentTimeMillis());
            if (campProp.getProperty(Column.SECURE_YN, "N").equalsIgnoreCase("Y") && isContent) {
                this.CHAR_SET = campProp.getProperty(Column.NLS_LANG, "UTF-8");
                this.setContentName((String)userMap.get(Column.SECURE_ATTACH_NAME));
            } else {
                this.CHAR_SET = (String)attachMap.get(Column.ATTACH_CHARSET);
                this.setContentName((String)attachMap.get(Column.ATTACH_NAME));
            }
            this.MESSAGE_ID = campProp.getProperty(Column.SCHD_ID);
            buffer = new StringBuffer(512);
            buffer.append("Message-ID: <");
            buffer.append(fdf.format(this.myDate));
            buffer.append(this.rnd.nextInt(this.MAX_RANDOM_VALUE) + this.MIN_RANDOM_VALUE);
            buffer.append("_TMS");
            buffer.append(MESSAGE_ID_TAIL);
            buffer.append(">\r\n");
            buffer.append("Content-Type: ");
            buffer.append("application/octet-stream;");
            buffer.append("\tname=\"=?");
            buffer.append(this.CHAR_SET);
            buffer.append("?B?");
            buffer.append(BASE64.encode(this.getContentName()));
            buffer.append("?=\"\r\n");
            buffer.append("Content-Transfer-Encoding: ");
            buffer.append("base64");
            buffer.append("\r\n");
            buffer.append("Content-Disposition: attachment;");
            buffer.append("\tfilename=\"=?");
            buffer.append(this.CHAR_SET);
            buffer.append("?B?");
            buffer.append(BASE64.encode(this.getContentName()));
            buffer.append("?=\"\r\n");
            this.MESSAGE_HEADER = buffer.toString();
            out.write(this.MESSAGE_HEADER.getBytes(eMsLocale.CHAR_SET));
        }
        finally {
            buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putHeaderToStreamContent(OutputStream out, Properties campProp, String contentMimeEncodeType, String propLocalhost) throws Exception {
        if (StringUtil.isNull(this.smtpLocalhost)) {
            this.smtpLocalhost = propLocalhost;
        }
        MESSAGE_ID_TAIL = "@" + this.smtpLocalhost;
        StringBuffer buffer = null;
        try {
            FastDateFormat fdf = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
            this.myDate.setTime(System.currentTimeMillis());
            String contenetType = campProp.getProperty(Column.CONTENT_TYPE);
            Short contentEmsType = new Short(1);
            contentEmsType = contenetType.equalsIgnoreCase("T") ? new Short(1) : (contenetType.equalsIgnoreCase("H") || contenetType.equalsIgnoreCase("L") ? new Short(2) : new Short(5));
            if (contentEmsType != 5 && "base64".equals(contentMimeEncodeType)) {
                contentEmsType = 7;
                this.CONTENT_ENCODING = 1;
            } else if (contentEmsType != 5 && "quoted-printable".equals(contentMimeEncodeType)) {
                contentEmsType = 7;
                this.CONTENT_ENCODING = 2;
            }
            this.CHAR_SET = (String)campProp.get(Column.NLS_LANG);
            this.MESSAGE_ID = campProp.getProperty(Column.SCHD_ID);
            buffer = new StringBuffer(512);
            buffer.append("Message-ID: <");
            buffer.append(fdf.format(this.myDate));
            buffer.append(this.rnd.nextInt(this.MAX_RANDOM_VALUE) + this.MIN_RANDOM_VALUE);
            buffer.append("_TMS");
            buffer.append(MESSAGE_ID_TAIL);
            buffer.append(">\r\n");
            buffer.append("Content-Type: ");
            switch (contentEmsType) {
                case 1: 
                case 3: {
                    buffer.append("text/plain;");
                    break;
                }
                case 2: 
                case 4: {
                    buffer.append("text/html;");
                    break;
                }
                case 5: {
                    buffer.append("application/octet-stream;");
                    break;
                }
                case 6: {
                    buffer.append("image/jpeg;");
                    break;
                }
                default: {
                    buffer.append("text/html;");
                }
            }
            switch (contentEmsType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    buffer.append("\tcharset=\"");
                    buffer.append(this.CHAR_SET);
                    buffer.append("\"\r\n");
                    break;
                }
                case 5: 
                case 6: {
                    buffer.append("\tname=\"=?");
                    buffer.append(this.CHAR_SET);
                    buffer.append("?B?");
                    buffer.append(BASE64.encode(this.getContentName()));
                    buffer.append("?=\"\r\n");
                    break;
                }
                default: {
                    buffer.append("\tcharset=");
                    buffer.append(this.CHAR_SET);
                    buffer.append("\r\n");
                }
            }
            buffer.append("Content-Transfer-Encoding: ");
            if (contentEmsType == 5 || contentEmsType == 6) {
                buffer.append("base64");
            } else {
                switch (this.CONTENT_ENCODING) {
                    case 1: {
                        buffer.append("base64");
                        break;
                    }
                    case 2: {
                        buffer.append("quoted-printable");
                        break;
                    }
                    case 3: {
                        buffer.append("uuencode");
                        break;
                    }
                    case 4: {
                        buffer.append("8bit");
                        break;
                    }
                    case 5: {
                        buffer.append("7bit");
                        break;
                    }
                    default: {
                        buffer.append("8bit");
                    }
                }
            }
            buffer.append("\r\n");
            if (contentEmsType == 5 || contentEmsType == 4) {
                buffer.append("Content-Disposition: attachment;\r\n");
                buffer.append("\tfilename=\"=?");
                buffer.append(this.CHAR_SET);
                buffer.append("?B?");
                buffer.append(BASE64.encode(this.getContentName()));
                buffer.append("?=\"\r\n");
            }
            if (contentEmsType == 6) {
                buffer.append("Content-ID: <");
                buffer.append(this.getMessageID());
                buffer.append(">\r\n");
            }
            this.MESSAGE_HEADER = buffer.toString();
            out.write(this.MESSAGE_HEADER.getBytes(eMsLocale.CHAR_SET));
        }
        finally {
            buffer = null;
        }
    }

    @Override
    public void setMessageID(String id) {
        this.MESSAGE_ID = id.endsWith(MESSAGE_ID_TAIL) ? id : id.concat(MESSAGE_ID_TAIL);
    }

    @Override
    public String getMessageID() {
        return this.MESSAGE_ID;
    }

    @Override
    public String getContentName() {
        return this.CONTENT_NAME == null ? this.PARSED_CONTENT.getName() : this.CONTENT_NAME;
    }

    @Override
    public void setContentName(String name) {
        this.CONTENT_NAME = name;
    }

    protected void finalize() {
    }
}

