/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.body;

import com.humuson.tms.mapper.body.BodyParser;
import com.humuson.tms.mapper.util.FileElement;
import com.humuson.tms.mapper.util.Name;
import com.humuson.tms.mapper.util.StringConvertUtil;
import com.humuson.tms.mapper.util.eMsLocale;
import freemarker20.template.SimpleHash;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Properties;

public class SimpleBodyParser
extends Name
implements BodyParser {
    protected String origin = null;
    protected String contents = null;

    public SimpleBodyParser() {
        this.setName("SimpleBodyParser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setContents(String src) throws Exception {
        this.origin = src;
        ByteArrayOutputStream byteBuffer = null;
        try {
            byteBuffer = new ByteArrayOutputStream(2048);
            FileElement fe = FileElement.getFileElement(src);
            fe.putStream(byteBuffer);
            this.contents = byteBuffer.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
            this.setName(fe.getName());
            fe.close();
        }
        finally {
            if (byteBuffer != null) {
                byteBuffer.close();
                byteBuffer = null;
            }
        }
    }

    @Override
    public void setContents(String original, String contents, String name) throws Exception {
        this.origin = original;
        this.contents = contents;
        this.setName(name);
    }

    @Override
    public synchronized String convert(Object info1, Object info2, Properties prop) throws Exception {
        StringBuffer buffer = new StringBuffer(2048);
        StringConvertUtil.ConvertString(buffer, this.contents, prop, "${", "}", false, true);
        String tmpString = buffer.toString();
        buffer.setLength(0);
        if (info1 != null) {
            if (!(info1 instanceof Map) && !(info1 instanceof SimpleHash)) {
                throw new RuntimeException("UNSUPPORTED HASH TYPE");
            }
            StringConvertUtil.ConvertString(buffer, tmpString, info1, "${", "}", false, false);
            tmpString = buffer.toString();
            buffer.setLength(0);
        }
        StringConvertUtil.ConvertString(buffer, tmpString, info2, "@{", "}", false, false);
        return buffer.toString();
    }

    @Override
    public String getContents() {
        return this.contents;
    }

    @Override
    public String getOriginal() {
        return this.origin;
    }

    protected void finalize() throws Throwable {
    }
}

