/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.body;

import java.io.IOException;

public class Canonicalization {
    public static Canonicalization SIMPLE = new Canonicalization(){

        @Override
        public String getType() {
            return "simple";
        }

        @Override
        public String canonicalizeHeader(String name, String value) {
            return name + ":" + value;
        }

        @Override
        public String canonicalizeBody(String body) throws IOException {
            if (body == null || "".equals(body)) {
                return "\r\n";
            }
            if (!"\r\n".equals(body.substring(body.length() - 2, body.length()))) {
                return body + "\r\n";
            }
            while ("\r\n\r\n".equals(body.substring(body.length() - 4, body.length()))) {
                body = body.substring(0, body.length() - 2);
            }
            return body;
        }
    };
    public static Canonicalization RELAXED = new Canonicalization(){

        @Override
        public String getType() {
            return "relaxed";
        }

        @Override
        public String canonicalizeHeader(String name, String value) {
            name = name.trim().toLowerCase();
            value = value.replaceAll("\\s+", " ").trim();
            return name + ":" + value;
        }

        @Override
        public String canonicalizeBody(String body) throws IOException {
            if (body == null || "".equals(body)) {
                return "\r\n";
            }
            body = body.replaceAll("[ \\t\\x0B\\f]+", " ");
            if (!"\r\n".equals((body = body.replaceAll(" \r\n", "\r\n")).substring(body.length() - 2, body.length()))) {
                return body + "\r\n";
            }
            while ("\r\n\r\n".equals(body.substring(body.length() - 4, body.length()))) {
                body = body.substring(0, body.length() - 2);
            }
            return body;
        }
    };

    public String getType() {
        return "unknown";
    }

    public String canonicalizeHeader(String name, String value) {
        return null;
    }

    public String canonicalizeBody(String body) throws IOException {
        return null;
    }
}

