/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper;

import com.humuson.tms.mapper.content.ContentReadWrite;
import com.humuson.tms.mapper.info.MapperInfo;
import com.humuson.tms.mapper.mapping.ContentMapping;
import com.humuson.tms.mapper.redis.RedisExecutor;
import com.humuson.tms.mapper.util.StringUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentConvert {
    private static final Logger log = LoggerFactory.getLogger(ContentConvert.class);
    @Autowired
    private RedisExecutor redisExecutor;
    @Autowired
    private ContentMapping contentMapping;
    @Autowired
    private ContentReadWrite contentReadWrite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String message) {
        String[] arr = message.split(":");
        if (arr.length == 3) {
            String sendId = arr[0];
            String schdId = arr[1];
            String targetSeq = arr[2];
            log.info("sendId:[{}], schdId:[{}], targetSeq:[{}]", new Object[]{sendId, schdId, targetSeq});
            List<MapperInfo> totalList = null;
            try {
                long start = System.currentTimeMillis();
                totalList = this.redisExecutor.getRedisData(sendId, schdId, targetSeq);
                long end = System.currentTimeMillis();
                log.info("[END] Redis \ub370\uc774\ud130\uac00\uc838\uc634 PINFO/TLIST ===========================[{}]", (Object)((double)(end - start) / 1000.0 + " \ucd08"));
                String pcnclKey = "PCNCL";
                if (this.redisExecutor.checkStop(pcnclKey, sendId)) {
                    start = System.currentTimeMillis();
                    int targetCnt = this.redisExecutor.updateTotalCrsltUser(totalList, sendId, schdId, targetSeq, "MP601", "SEND STOP");
                    this.redisExecutor.updateSproc("42", schdId, targetSeq, sendId, targetCnt);
                    end = System.currentTimeMillis();
                    log.info("[END] 1\ucc28 \ubc1c\uc1a1\uc911\uc9c0 \ucc98\ub9ac ===========================[{}]", (Object)((double)(end - start) / 1000.0 + " \ucd08"));
                    return;
                }
                this.redisExecutor.updateSproc("10", schdId, targetSeq, sendId, totalList.get((int)0).targetList.size());
                if (totalList.size() == 0) {
                    log.error("CM0202|Redis Data Null");
                    this.redisExecutor.updateSproc("41", schdId, targetSeq, sendId, -1);
                    return;
                }
                String content = "";
                try {
                    start = System.currentTimeMillis();
                    content = this.contentReadWrite.getContent(totalList.get((int)0).campProp);
                    end = System.currentTimeMillis();
                    if (StringUtil.isNull(content)) {
                        log.info("CM0501| Content is Null : sendId:{} / schdId:{} / targetSeq:{}", new Object[]{sendId, schdId, targetSeq});
                        throw new Exception("Content is Null");
                    }
                    log.info("[END] Content \uc77d\uc5b4\uc634  ===========================[{}]", (Object)((double)(end - start) / 1000.0 + " \ucd08"));
                }
                catch (Exception e) {
                    log.error("CM0501|Content readWrite Error or Content is Null : sendId:{} / schdId:{} / targetSeq:{}", new Object[]{sendId, schdId, targetSeq});
                    this.redisExecutor.updateTotalCrsltUser(totalList, sendId, schdId, targetSeq, "MP104", "Content is Null");
                    this.redisExecutor.updateSproc("40", schdId, targetSeq, sendId, -1);
                    content = "";
                }
                int successCnt = 0;
                successCnt = StringUtil.isNull(content) ? -1 : this.contentMapping.executeContentMapping(content, totalList, targetSeq);
                if (successCnt == -1) return;
                this.redisExecutor.updateSproc("40", schdId, targetSeq, sendId, successCnt);
                return;
            }
            catch (Exception e) {
                log.error("[ERROR] execute() error:{}", (Throwable)e);
                try {
                    this.redisExecutor.updateSproc("41", schdId, targetSeq, sendId, -1);
                    return;
                }
                catch (Exception e1) {
                    log.error("CM0201|UpdateSproc[41] fail:{}", (Throwable)e1);
                }
                return;
            }
            finally {
                if (!totalList.isEmpty()) {
                    totalList.clear();
                }
            }
        }
        log.error("CM0301|MQ message invalid Error, message:{}", (Object)message);
    }
}

