/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.stat;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.manager.repository.model.SendListModel;
import com.humuson.tms.manager.repository.model.SprocModel;
import com.humuson.tms.manager.stat.CampaignStatService;
import com.humuson.tms.manager.stat.CommonStatService;
import com.humuson.tms.manager.stat.RealTimeStatService;
import com.humuson.tms.manager.stat.ResendStatService;
import com.humuson.tms.manager.stat.Stat;
import com.humuson.tms.manager.stat.StatBasicCommon;
import com.humuson.tms.manager.stat.TestStatService;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.StringUtils;

@TmsComponent
public class StatBasic
implements Stat {
    private static final Logger log = LoggerFactory.getLogger(StatBasic.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    StatDao statDao;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    @Qualifier(value="statTasklet")
    public Tasklet statTasklet;
    @Autowired
    @Qualifier(value="statReader")
    public MyBatisPagingItemReader<SendListModel> statReader;
    @Autowired
    @Qualifier(value="statWriter")
    public ItemWriter<SendListModel> statWriter;
    @Autowired
    @Qualifier(value="statProcessor")
    public ItemProcessor<SendListModel, SendListModel> statProcessor;
    @Value(value="${tms.manager.proc-stat.reader-page-size}")
    private int pageSize;
    @Value(value="${tms.manager.proc-stat.timeout.auto:12}")
    private int autoSchdTimeout;
    @Value(value="${tms.manager.proc-stat.timeout.auto-unit:hour}")
    private String autoSchdTimeoutUnit;
    @Value(value="${tms.manager.proc-stat.timeout.mass:2}")
    private int massSchdTimeout;
    @Value(value="${tms.manager.proc-stat.timeout.mass-unit:hour}")
    private String massSchdTimeoutUnit;
    private static final int CLEAN_SCAN_CNT = 1000;
    private static final int CLEAN_SCAN_MAX = 100000;

    @Override
    public long applyMgCnt(Map<String, String> infoMap, SprocModel sprocModel, long schdId, long sendId, String chnType) {
        long targetCnt = 0L;
        return targetCnt;
    }

    @Override
    public boolean applyStatus(StatBasicCommon targetStat, SchdInfoModel sim) {
        String triggerMethod = sim.getTriggerMethod();
        String jobStatus = sim.getJobStatus();
        String serviceName = null;
        CommonStatService statResultService = null;
        switch (triggerMethod) {
            case "C5": {
                statResultService = new RealTimeStatService();
                serviceName = "RealTime";
                break;
            }
            case "O8": {
                statResultService = new TestStatService();
                serviceName = "TestSend";
                break;
            }
            case "O7": {
                statResultService = new ResendStatService();
                serviceName = "ReSend";
                break;
            }
            default: {
                statResultService = new CampaignStatService();
                serviceName = "Campaign";
            }
        }
        statResultService.init(targetStat, this.statDao, serviceName);
        switch (jobStatus) {
            case "09": {
                statResultService.schdResult09Process();
                break;
            }
            case "10": {
                statResultService.schdResult10Process();
                break;
            }
            case "15": {
                statResultService.schdResult15Process(sim);
                break;
            }
            case "20": {
                statResultService.schdResult20Process();
                break;
            }
            case "25": {
                statResultService.schdResult25Process();
                break;
            }
            case "29": {
                statResultService.schdResult29Process(sim.getWorkday());
                break;
            }
            case "30": {
                statResultService.schdResult30Process(sim.getChannelType());
                break;
            }
            case "38": {
                statResultService.schdResult38Process(sim.getChannelType());
                break;
            }
            case "40": {
                statResultService.schdResult40Process(sim.getChannelType());
                break;
            }
            case "41": {
                statResultService.schdResult41Process();
                break;
            }
        }
        if (statResultService.getCleanFlag()) {
            this.cleanRedisSendReq(sim, null, targetStat.isSendComplete());
        }
        return true;
    }

    @Override
    public boolean checkTrackingEndToNow(String channelType, SchdInfoModel sim) {
        block10: {
            long nowDate = Long.parseLong(DateUtil.getFullDateDefaultFormat());
            if (channelType.equals(Constants.ChannelType.EM.toString()) || channelType.equals(Constants.ChannelType.PU.toString())) {
                if (sim.getTrackingYn().equals("N")) {
                    return false;
                }
                try {
                    long trackEnDate = Long.parseLong(sim.getTrackingClose());
                    if (trackEnDate - nowDate < 0L) {
                        return true;
                    }
                    break block10;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (channelType.equals(Constants.ChannelType.SM.toString()) || channelType.equals(Constants.ChannelType.KA.toString())) {
                int receiveSuc = sim.getReceivedSuccess();
                int receiveFail = sim.getReceivedFailCnt();
                int successCnt = sim.getSuccessCnt();
                if (successCnt == receiveSuc + receiveFail) {
                    return false;
                }
                try {
                    long trackEnDate = Long.parseLong(sim.getTrackingClose());
                    if (trackEnDate - nowDate < 0L) {
                        return true;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public boolean checkTimeOut(SchdInfoModel sim) {
        int timeOutSeconds = 3600;
        timeOutSeconds = sim.getTriggerMethod().startsWith("C") || sim.getTriggerMethod().equalsIgnoreCase(Constants.TriggerMethod.O9.name()) ? (this.autoSchdTimeoutUnit.equalsIgnoreCase("day") ? this.autoSchdTimeout * 24 * 60 * 60 : (this.autoSchdTimeoutUnit.equalsIgnoreCase("min") ? this.autoSchdTimeout * 60 : this.autoSchdTimeout * 60 * 60)) : (this.massSchdTimeoutUnit.equalsIgnoreCase("day") ? this.massSchdTimeout * 24 * 60 * 60 : (this.massSchdTimeoutUnit.equalsIgnoreCase("min") ? this.massSchdTimeout * 60 : this.massSchdTimeout * 60 * 60));
        boolean result = false;
        if (sim.getStartDate() != null) {
            String startDate = sim.getStartDate();
            String moniteStDate = sim.getMoniteStDate();
            String moniteEnDate = sim.getMoniteEnDate();
            String statStDate = sim.getStatStDate();
            String statEnDate = sim.getStatEnDate();
            boolean startTimeOutFlag = false;
            startTimeOutFlag = DateUtil.checkTimeoutSecondToNow((int)timeOutSeconds, (String)startDate);
            if (startTimeOutFlag) {
                result = moniteStDate != null ? (moniteEnDate != null ? DateUtil.checkTimeoutSecondToNow((int)timeOutSeconds, (String)moniteEnDate) : DateUtil.checkTimeoutSecondToNow((int)timeOutSeconds, (String)moniteStDate)) : (statStDate != null ? (statEnDate != null ? DateUtil.checkTimeoutSecondToNow((int)timeOutSeconds, (String)statEnDate) : DateUtil.checkTimeoutSecondToNow((int)timeOutSeconds, (String)statStDate)) : startTimeOutFlag);
            }
        }
        return result;
    }

    @Override
    public boolean checkSendRequestCnt(SchdInfoModel sim) {
        String channelType = sim.getChannelType();
        int targetCnt = sim.getTargetCnt();
        long processingCnt = 0L;
        if (targetCnt == 0) {
            return false;
        }
        if (channelType.equals(Constants.ChannelType.EM.toString()) || channelType.equals(Constants.ChannelType.PU.toString())) {
            String ctStauts = sim.getMoniteCTStat();
            String mpStatus = sim.getMoniteMPStat();
            if (ctStauts == null || mpStatus == null) {
                return false;
            }
            if (ctStauts.equals("40") && mpStatus.equals("40")) {
                processingCnt = sim.getMpPushedCnt() + (long)sim.getFilterCnt() + (long)sim.getExceptCnt();
            }
        } else if (channelType.equals(Constants.ChannelType.SM.toString()) || channelType.equals(Constants.ChannelType.KA.toString())) {
            processingCnt = sim.getSuccessCnt() + sim.getFailCnt() + sim.getFilterCnt() + sim.getExceptCnt();
        }
        boolean result = false;
        if (targetCnt >= sim.getInitTarget() && (long)targetCnt <= processingCnt) {
            result = true;
            log.debug("[checkRequestSenCnt] SCHD ID : {}. target Cnt : {} processingCnt : {} (success:{}, fail:{} filter:{}, except:{})", new Object[]{sim.getSchdId(), sim.getTargetCnt(), processingCnt, sim.getSuccessCnt(), sim.getFailCnt(), sim.getFilterCnt(), sim.getExceptCnt()});
        }
        return result;
    }

    @Override
    public boolean checkSendCompleteCnt(SchdInfoModel sim) {
        String channelType = sim.getChannelType();
        int targetCnt = sim.getTargetCnt();
        long processingCnt = 0L;
        if (targetCnt == 0) {
            return false;
        }
        if (channelType.equals(Constants.ChannelType.EM.toString()) || channelType.equals(Constants.ChannelType.PU.toString())) {
            processingCnt = sim.getSuccessCnt() + sim.getFailCnt() + sim.getFilterCnt() + sim.getExceptCnt();
        } else if (channelType.equals(Constants.ChannelType.SM.toString()) || channelType.equals(Constants.ChannelType.KA.toString())) {
            processingCnt = sim.getReceivedSuccess() + sim.getReceivedFailCnt() + sim.getFilterCnt() + sim.getExceptCnt() + sim.getFailCnt();
        }
        boolean result = false;
        if (targetCnt >= sim.getInitTarget() && (long)targetCnt <= processingCnt) {
            result = true;
            log.debug("[checkRequestSenCnt] SCHD ID : {}. target Cnt : {} processingCnt : {} (success:{}, fail:{} filter:{}, except:{})", new Object[]{sim.getSchdId(), sim.getTargetCnt(), processingCnt, sim.getSuccessCnt(), sim.getFailCnt(), sim.getFilterCnt(), sim.getExceptCnt()});
        }
        return result;
    }

    @Override
    public boolean isCtBeforeCancled(SchdInfoModel sim) {
        return sim.getMoniteCTStat() != null && sim.getMoniteCTStat().equalsIgnoreCase("42") && sim.getCtTargetCnt() == sim.getCtPushedCnt() && sim.getCtPushedCnt() == 0L;
    }

    @Override
    public Step filterTasklet() {
        return this.stepBuilderFactory.get("statFilterTasklet").tasklet(this.statTasklet).build();
    }

    @Override
    public Step step1() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("statRowStep").chunk(this.pageSize).reader(this.statReader).processor(this.statProcessor).writer(this.statWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }

    @Override
    public void cleanRedisSendReq(SchdInfoModel sim, List<String> tlistKeys, boolean isSendComplete) {
        long start = System.currentTimeMillis();
        long schdId = sim.getSchdId();
        long workingSize = 0L;
        this.wrapperRedisTemplate.del("SPROC:" + schdId);
        if (tlistKeys == null) {
            tlistKeys = this.wrapperRedisTemplate.scan("TLIST:" + schdId, 1000, 100000);
            if (tlistKeys != null && tlistKeys.size() > 0) {
                workingSize = tlistKeys.size();
            }
            for (String tlistKey : tlistKeys) {
                try {
                    if (isSendComplete) {
                        String dlistKey = null;
                        dlistKey = tlistKey.replace("TLIST", "DLIST");
                        this.wrapperRedisTemplate.del(tlistKey);
                        this.wrapperRedisTemplate.del(dlistKey);
                        continue;
                    }
                    Map targetTlistMap = this.wrapperRedisTemplate.hgetAllString(tlistKey);
                    HashMap<String, String> resultJsonObj = new HashMap<String, String>();
                    Map tmpMap = null;
                    for (String tlistFiled : targetTlistMap.keySet()) {
                        String tlistValue = (String)targetTlistMap.get(tlistFiled);
                        if (!StringUtils.isEmpty((Object)tlistValue)) {
                            tmpMap = JsonUtil.getMapFromJson((String)tlistValue);
                            String crsltKey = "CRSLT".concat(":").concat(sim.getChannelType()).concat(":").concat(StatBasic.createCrlstTime(1));
                            String crsltField = tlistKey.replace("TLIST", String.valueOf(sim.getSendId())).concat(":").concat(tlistFiled);
                            resultJsonObj.put("ERROR_CODE", "99");
                            resultJsonObj.put("RESULT_TYPE", "S");
                            resultJsonObj.put("ERROR_DETAIL", "TIME OUT ...");
                            resultJsonObj.put("WORKDAY", DateUtil.getWorkday());
                            resultJsonObj.put("SERVER_ID", "01");
                            resultJsonObj.put("START_TIME", DateUtil.getFullDateDefaultFormat());
                            resultJsonObj.put("END_TIME", DateUtil.getFullDateDefaultFormat());
                            resultJsonObj.put("MEMBER_ID", (String)tmpMap.get("MEMBER_ID"));
                            resultJsonObj.put("UNIQUE_SEQ", (String)tmpMap.get("UNIQUE_SEQ"));
                            this.wrapperRedisTemplate.hmset(crsltKey, crsltField, JsonUtil.convertMapToJsonString(resultJsonObj));
                        } else {
                            log.debug("Tlist key : {} / Tlistfiled : {}", (Object)tlistKey, (Object)tlistFiled);
                        }
                        resultJsonObj.clear();
                        if (tmpMap == null) continue;
                        tmpMap.clear();
                    }
                    if (resultJsonObj != null) {
                        resultJsonObj.clear();
                        resultJsonObj = null;
                    }
                    if (tmpMap != null) {
                        tmpMap.clear();
                        tmpMap = null;
                    }
                    if (targetTlistMap == null) continue;
                    targetTlistMap.clear();
                    targetTlistMap = null;
                }
                catch (Exception e) {
                    log.error(MNSystemErrorCode.ERR_4038.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
                }
            }
        }
        long end = System.currentTimeMillis();
    }

    public static String createCrlstTime(int intervalMin) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        Calendar c = Calendar.getInstance();
        Date d = new Date();
        c.setTime(d);
        c.add(12, intervalMin);
        return sdf.format(c.getTime());
    }

    @Override
    public String checkIfMoniteStatusIsFailOrStopped(SchdInfoModel schdInfoModel) {
        String ctStauts = schdInfoModel.getMoniteCTStat();
        String mpStatus = schdInfoModel.getMoniteMPStat();
        if (ctStauts == null || mpStatus == null) {
            return "";
        }
        if (ctStauts.equals("41")) {
            return "41";
        }
        if (mpStatus.equals("41")) {
            return "41";
        }
        if (ctStauts.equals("42")) {
            return "42";
        }
        if (mpStatus.equals("42")) {
            return "42";
        }
        return "40";
    }
}

