/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.stat;

import com.humuson.tms.config.Constants;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.manager.stat.StatBasicCommon;
import com.humuson.tms.manager.stat.StatBasicService;
import com.humuson.tms.manager.stat.StatConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonStatService
implements StatBasicService {
    private static final Logger log = LoggerFactory.getLogger(CommonStatService.class);
    private String serviceName = null;
    protected StatDao statDao;
    protected StatBasicCommon statCommon;
    protected boolean cleanFlag = false;
    protected boolean monitorErrorFlag = false;
    protected boolean monitorCancelFlag = false;
    protected boolean isCtBeforeCancle = false;

    public int updateJobStatus09Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "09", jobstate, msg);
    }

    public int updateJobStatus10Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "10", jobstate, msg);
    }

    public int updateJobStatus15Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "15", jobstate, msg);
    }

    public int updateJobStatus20Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "20", jobstate, msg);
    }

    public int updateJobStatus25Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "25", jobstate, msg);
    }

    public int updateJobStatus29Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "29", jobstate, msg);
    }

    public int updateJobStatus30Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "30", jobstate, msg);
    }

    public int updateJobStatus38Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "38", jobstate, msg);
    }

    public int updateJobStatus40Process(long schdId, String jobstate, String msg) {
        return this.updateSchdInfoTable(schdId, "40", jobstate, msg);
    }

    public int updateSchdInfoTable(long schdId, String beforeJobStatus, String jobstate, String msg) {
        long start = System.currentTimeMillis();
        int result = this.statDao.updateSchdJobState(schdId, beforeJobStatus, jobstate);
        long end = System.currentTimeMillis();
        log.info("[QUERY] updateSchdJobState schdId:{}, current:{}, change:{}, because:{}, result : {} =======[{}] seconds", new Object[]{schdId, beforeJobStatus, jobstate, msg, result, (double)(end - start) / 1000.0});
        return result;
    }

    public CommonStatService() {
    }

    @Override
    public void init(StatBasicCommon targetStat, StatDao statDao, String serviceName) {
        this.statCommon = targetStat;
        this.statDao = statDao;
        this.serviceName = serviceName;
        this.monitorSendProcess(targetStat);
    }

    @Override
    public boolean getCleanFlag() {
        return this.cleanFlag;
    }

    public CommonStatService(String moniteStatus, long sendId, long schdId, boolean isTrackingEnd, boolean isTimeOut, boolean isStoped, boolean isReulstProcess, boolean isRequestSendComplete, boolean isSendComplete, StatDao statDao, String serviceName) {
        StatBasicCommon targetStat = new StatBasicCommon();
        targetStat.setRequestSendComplete(isRequestSendComplete);
        targetStat.setSendComplete(isSendComplete);
        targetStat.setTimeOut(isTimeOut);
        targetStat.setTrackingEnd(isTrackingEnd);
        targetStat.setSendId(sendId);
        targetStat.setSchdId(schdId);
        targetStat.setMoniteStatus(moniteStatus);
        targetStat.setStoped(isStoped);
        targetStat.setReulstProcess(isReulstProcess);
        this.statCommon = targetStat;
        this.statDao = statDao;
        this.serviceName = serviceName;
    }

    @Override
    public void printStatus() {
        log.info("STAT PROCESS : Target Stat Data : {}", (Object)this.statCommon);
    }

    @Override
    public void monitorSendProcess(StatBasicCommon statCommon) {
        String monitorState = null;
        switch (monitorState = statCommon.getMoniteStatus()) {
            case "41": {
                this.monitorErrorFlag = true;
                break;
            }
            case "42": {
                this.monitorCancelFlag = true;
                break;
            }
        }
        if (statCommon.isCtBeforeCancle()) {
            this.isCtBeforeCancle = true;
        }
    }

    @Override
    public int schdResult09Process() {
        if (this.statCommon.isTimeOut()) {
            this.cleanFlag = true;
            return this.updateJobStatus09Process(this.statCommon.getSchdId(), "41", StatConstants.statErrorMes.TIME_OUT.getErrorMsg());
        }
        return 0;
    }

    @Override
    public int schdResult10Process() {
        if (this.statCommon.isTimeOut()) {
            this.cleanFlag = true;
            return this.updateJobStatus10Process(this.statCommon.getSchdId(), "41", StatConstants.statErrorMes.TIME_OUT.getErrorMsg());
        }
        return 0;
    }

    @Override
    public int schdResult15Process(SchdInfoModel sim) {
        if (this.statCommon.isTimeOut()) {
            this.cleanFlag = true;
            return this.updateJobStatus15Process(this.statCommon.getSchdId(), "41", StatConstants.statErrorMes.TIME_OUT.getErrorMsg());
        }
        return 0;
    }

    @Override
    public int schdResult20Process() {
        if (this.statCommon.isTimeOut()) {
            this.cleanFlag = true;
            return this.updateJobStatus20Process(this.statCommon.getSchdId(), "41", StatConstants.statErrorMes.TIME_OUT.getErrorMsg());
        }
        return 0;
    }

    @Override
    public int schdResult25Process() {
        if (this.statCommon.isTimeOut()) {
            this.cleanFlag = true;
            return this.updateJobStatus25Process(this.statCommon.getSchdId(), "41", StatConstants.statErrorMes.TIME_OUT.getErrorMsg());
        }
        return 0;
    }

    @Override
    public int schdResult30Process(String channelType) {
        if (this.statCommon.isRequestSendComplete()) {
            if (!channelType.equals(Constants.ChannelType.EM.toString())) {
                this.cleanFlag = true;
            }
            return this.updateJobStatus30Process(this.statCommon.getSchdId(), "40", "SendedRequestCountComplete");
        }
        if (this.statCommon.isTimeOut()) {
            this.cleanFlag = true;
            return this.updateJobStatus30Process(this.statCommon.getSchdId(), "41", StatConstants.statErrorMes.TIME_OUT.getErrorMsg());
        }
        if (!this.statCommon.isReulstProcess()) {
            if (this.monitorErrorFlag) {
                return this.updateJobStatus30Process(this.statCommon.getSchdId(), "41", StatConstants.statErrorMes.MONITE_ERROR.getErrorMsg());
            }
            if (this.isCtBeforeCancle) {
                return this.updateJobStatus30Process(this.statCommon.getSchdId(), "42", StatConstants.statErrorMes.MONITE_CANCLE.getErrorMsg());
            }
        }
        if (this.statCommon.isReulstProcess()) {
            return this.updateJobStatus30Process(this.statCommon.getSchdId(), "38", "success");
        }
        if (this.statCommon.isTrackingEnd()) {
            return this.updateJobStatus30Process(this.statCommon.getSchdId(), "43", StatConstants.statErrorMes.TRACKING_END.getErrorMsg());
        }
        return 0;
    }

    @Override
    public int schdResult38Process(String channelType) {
        if (this.statCommon.isRequestSendComplete()) {
            if (!channelType.equals(Constants.ChannelType.EM.toString())) {
                this.cleanFlag = true;
            }
            return this.updateJobStatus38Process(this.statCommon.getSchdId(), "40", "SendedRequestCountComplete");
        }
        if (this.statCommon.isSendComplete()) {
            this.cleanFlag = true;
            return this.updateJobStatus38Process(this.statCommon.getSchdId(), "40", "SendedResultCountComplete");
        }
        if (this.statCommon.isTimeOut()) {
            this.cleanFlag = true;
            return this.updateJobStatus38Process(this.statCommon.getSchdId(), "40", StatConstants.statErrorMes.TIME_OUT.getErrorMsg());
        }
        if (!this.statCommon.isRequestSendComplete()) {
            if (this.monitorErrorFlag) {
                return this.updateJobStatus38Process(this.statCommon.getSchdId(), "41", StatConstants.statErrorMes.MONITE_ERROR.getErrorMsg());
            }
            if (this.monitorCancelFlag) {
                return this.updateJobStatus38Process(this.statCommon.getSchdId(), "42", StatConstants.statErrorMes.MONITE_CANCLE.getErrorMsg());
            }
        }
        if (this.statCommon.isTrackingEnd()) {
            return this.updateJobStatus38Process(this.statCommon.getSchdId(), "43", StatConstants.statErrorMes.TRACKING_END.getErrorMsg());
        }
        return 0;
    }

    @Override
    public int schdResult40Process(String channelType) {
        if (this.statCommon.isSendComplete()) {
            this.cleanFlag = true;
            return this.updateJobStatus40Process(this.statCommon.getSchdId(), "43", "SendedResultCountComplete");
        }
        if (this.statCommon.isTrackingEnd()) {
            return this.updateJobStatus40Process(this.statCommon.getSchdId(), "43", StatConstants.statErrorMes.TRACKING_END.getErrorMsg());
        }
        return 0;
    }

    @Override
    public int schdResult41Process() {
        return 0;
    }
}

