/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.stat;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.manager.repository.model.StatSchdModel;
import com.humuson.tms.manager.stat.Stat;
import com.humuson.tms.manager.stat.StatBasicCommon;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class ResultSchdInfoScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResultSchdInfoScheduler.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private LockContexter contexter;
    @Autowired
    StatDao statDao;
    @Autowired
    Stat statService;
    @Value(value="${tms.manager.proc-stat.stat-use:N}")
    private String statUseFlag;
    @Value(value="${tms.manager.proc-stat.schd-limit:10}")
    private int schdLimit;
    @Value(value="${tms.manager.proc-stat.stat-limit-day:1}")
    private int statLimitDay;
    @Value(value="${tms.manager.proc-stat.stat-check-day:7}")
    private int schdCheckDay;
    private List<StatSchdModel> statSchdList;
    private List<SchdInfoModel> schdList;

    @Scheduled(fixedDelayString="${tms.manager.proc-stat.interval}")
    public void schedule() {
        if (!"Y".equals(this.statUseFlag)) {
            log.debug("[ResultSchdInfoScheduler] stat config is {}", (Object)this.statUseFlag);
            return;
        }
        String startDate = DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.schdCheckDay));
        String endDate = DateUtil.getFullDate((String)"yyyyMMdd");
        long start = System.currentTimeMillis();
        this.statSchdList = this.statDao.selectStatSchdule();
        long end = System.currentTimeMillis();
        log.debug("[QUERY] START selectStatSchdule size:{} =======[{}] seconds", (Object)this.statSchdList.size(), (Object)((double)(end - start) / 1000.0));
        if (this.statSchdList == null || this.statSchdList.size() == 0) {
            end = System.currentTimeMillis();
            log.debug("[SCHEDULER] END. count:{},  [{}] seconds", (Object)this.statSchdList.size(), (Object)((double)(end - start) / 1000.0));
            return;
        }
        try {
            for (StatSchdModel statSchdModel : this.statSchdList) {
                long sendId = statSchdModel.getSendId();
                this.doResultingSchdInfo(startDate, endDate, sendId, statSchdModel.getJobStatus());
            }
            if (this.schdList != null) {
                this.schdList.clear();
            }
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4020.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
        }
        end = System.currentTimeMillis();
        log.debug("[SCHEDULER] END. count:{},  [{}] seconds", (Object)this.statSchdList.size(), (Object)((double)(end - start) / 1000.0));
        if (this.statSchdList != null) {
            this.statSchdList.clear();
        }
    }

    public void doResultingSchdInfo(String startDate, String endDate, long sendId, String sendJobStatus) {
        boolean isSendInfoStoped = this.checkIfDeliveryIsStopped(sendJobStatus);
        long start1 = System.currentTimeMillis();
        this.schdList = this.statDao.selectSchdInfo(null, startDate, endDate, sendId);
        long end1 = System.currentTimeMillis();
        if (this.schdList.size() > 0) {
            log.debug("[QUERY] START startDate:{},endDate:{},SenId:{}, selectSchdInfo size:{}=======[{}] seconds ", new Object[]{startDate, endDate, sendId, this.schdList.size(), (double)(end1 - start1) / 1000.0});
        }
        long schdId = 0L;
        for (SchdInfoModel sim : this.schdList) {
            schdId = sim.getSchdId();
            try {
                long redisTargetCnt = -1L;
                long pushedCnt = -1L;
                String redisPinfoKey = "PINFO:" + schdId;
                String totalCnt = "";
                if (this.wrapperRedisTemplate.hasHMKey(redisPinfoKey, "COUNT_TARGET") && (totalCnt = this.wrapperRedisTemplate.hmget(redisPinfoKey, "COUNT_TARGET")) != null && !totalCnt.trim().isEmpty() && (long)sim.getTargetCnt() != redisTargetCnt) {
                    redisTargetCnt = Long.valueOf(totalCnt);
                }
                if ((long)sim.getTargetCnt() != sim.getCtTargetCnt() && redisTargetCnt == -1L) {
                    redisTargetCnt = sim.getCtTargetCnt();
                } else if (redisTargetCnt == sim.getCtTargetCnt() && redisTargetCnt == (long)sim.getTargetCnt()) {
                    redisTargetCnt = -1L;
                }
                if ((long)sim.getPushedCnt() != sim.getMpPushedCnt()) {
                    pushedCnt = sim.getMpPushedCnt();
                }
                this.updateStatTargetCntTable(sim.getSendId(), sim.getSchdId(), redisTargetCnt, pushedCnt);
                boolean isSendRequested = this.statService.checkSendRequestCnt(sim);
                boolean isSendComplete = this.statService.checkSendCompleteCnt(sim);
                boolean isTrackingEnd = this.statService.checkTrackingEndToNow(sim.getChannelType(), sim);
                boolean isTimeOut = this.statService.checkTimeOut(sim);
                boolean isReulstProcess = this.checkIfRedsultProcess(sim);
                boolean isCtBeforeCancle = this.statService.isCtBeforeCancled(sim);
                String moniteStatus = this.statService.checkIfMoniteStatusIsFailOrStopped(sim);
                StatBasicCommon targetStat = new StatBasicCommon();
                targetStat.setSendId(sim.getSendId());
                targetStat.setSchdId(sim.getSchdId());
                targetStat.setTestId(sim.getTestId());
                targetStat.setResendId(sim.getResendId());
                targetStat.setJobStatus(sim.getJobStatus());
                targetStat.setSendComplete(isSendComplete);
                targetStat.setRequestSendComplete(isSendRequested);
                targetStat.setTrackingEnd(isTrackingEnd);
                targetStat.setTimeOut(isTimeOut);
                targetStat.setStoped(isSendInfoStoped);
                targetStat.setReulstProcess(isReulstProcess);
                targetStat.setCtBeforeCancle(isCtBeforeCancle);
                targetStat.setMoniteStatus(moniteStatus);
                this.statService.applyStatus(targetStat, sim);
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4022.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private boolean checkIfDeliveryIsStopped(String schdJobStatus) {
        return schdJobStatus.equals("32");
    }

    private boolean checkIfRedsultProcess(SchdInfoModel schdInfoModel) {
        return schdInfoModel.getHasSendListYn().equalsIgnoreCase("Y");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updateStatTargetCntTable(long sendId, long schdId, long targetCnt, long pushedCnt) {
        if (targetCnt == -1L && pushedCnt == -1L) {
            return;
        }
        HashMap<String, Long> statMap = new HashMap<String, Long>();
        statMap.put("SEND_ID", sendId);
        statMap.put("SCHD_ID", schdId);
        if (targetCnt != -1L) {
            statMap.put("TARGET_CNT", targetCnt);
        }
        if (pushedCnt != -1L) {
            statMap.put("PUSHED_CNT", pushedCnt);
        }
        long start = System.currentTimeMillis();
        try {
            this.statDao.updateStatInfo(statMap);
        }
        catch (DuplicateKeyException dupEx) {
            this.statDao.updateStatInfo(statMap);
            long end = System.currentTimeMillis();
            log.debug("[QUERY] updateStatInfo sendId:{}, schdId:{}, data:{}  END ============[{}] seconds", new Object[]{sendId, schdId, ((Object)statMap).toString(), (double)(end - start) / 1000.0});
            if (statMap != null) {
                statMap.clear();
            }
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4021.makeLogMsg(this), new Object[]{sendId, schdId, e.getMessage(), e});
            {
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    log.debug("[QUERY] updateStatInfo sendId:{}, schdId:{}, data:{}  END ============[{}] seconds", new Object[]{sendId, schdId, ((Object)statMap).toString(), (double)(end - start) / 1000.0});
                    if (statMap != null) {
                        statMap.clear();
                    }
                    throw throwable;
                }
            }
            long end = System.currentTimeMillis();
            log.debug("[QUERY] updateStatInfo sendId:{}, schdId:{}, data:{}  END ============[{}] seconds", new Object[]{sendId, schdId, ((Object)statMap).toString(), (double)(end - start) / 1000.0});
            if (statMap != null) {
                statMap.clear();
            }
        }
        long end = System.currentTimeMillis();
        log.debug("[QUERY] updateStatInfo sendId:{}, schdId:{}, data:{}  END ============[{}] seconds", new Object[]{sendId, schdId, ((Object)statMap).toString(), (double)(end - start) / 1000.0});
        if (statMap != null) {
            statMap.clear();
        }
    }
}

