/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.result;

import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.custom.batch.listener.ResultSmsJobListener;
import com.humuson.tms.manager.custom.repository.dao.ResultSmsDao;
import com.humuson.tms.manager.custom.repository.model.ResultSmsModel;
import com.humuson.tms.manager.result.ResultSms;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-result-sm", name={"result-use"}, havingValue="true", matchIfMissing=true)
public class SaveSmsSentResultScheduler {
    private static final Logger log = LoggerFactory.getLogger(SaveSmsSentResultScheduler.class);
    @Autowired
    ResultSms resultSmService;
    @Autowired
    private ResultSmsDao processResultSmDao;
    @Autowired
    private LockContexter contexter;
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Value(value="${tms.manager.proc-result-sm.interval}")
    private int resultTargetLimit;
    @Autowired
    @Qualifier(value="syncJobLauncher")
    protected JobLauncher syncJobLauncher;
    @Autowired
    @Qualifier(value="resultSmsJob")
    public Job resultSmsJob;

    @Scheduled(fixedDelayString="${tms.manager.proc-result-sm.interval}")
    public void saveSentResultSchedule() {
        LockController lockController = this.contexter.lock("lock.manager.result.sm");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.result.sm");
            return;
        }
        List<String> resultTableNames = this.resultSmService.makeTableList();
        for (String tableName : resultTableNames) {
            ResultSmsModel smStand = this.processResultSmDao.selectSmStandId(tableName, this.resultTargetLimit);
            if (this.isEmptyOfSmsResult(smStand)) continue;
            try {
                JobParameters jobParameters = new JobParametersBuilder().addLong("time", Long.valueOf(System.currentTimeMillis())).addLong("minId", smStand.getMinId()).addLong("maxId", smStand.getMaxId()).addLong("toCnt", smStand.getToCnt()).addString("tableName", tableName).toJobParameters();
                this.syncJobLauncher.run(this.resultSmsJob, jobParameters);
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4011.makeLogMsg(this), new Object[]{tableName, smStand, e.getMessage(), e});
            }
        }
        if (resultTableNames != null) {
            resultTableNames.clear();
            resultTableNames = null;
        }
    }

    private boolean isEmptyOfSmsResult(ResultSmsModel smStand) {
        if (smStand == null || smStand.getMinId() == 0L && smStand.getMaxId() == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("[SaveSmsSentResultScheduler] has not target");
            }
            return true;
        }
        log.info("[SaveSmsSentResultScheduler] minId {} maxId {}. count {}", new Object[]{smStand.getMinId(), smStand.getMaxId(), smStand.getToCnt()});
        return false;
    }

    @Bean(value={"resultSmsJob"})
    public Job resultSmsJob(ResultSmsJobListener listener) {
        return ((SimpleJobBuilder)((JobBuilder)this.jobBuilderFactory.get("resultSmJob").incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(this.step1()).listener((JobExecutionListener)listener)).build();
    }

    public Step step1() {
        return this.resultSmService.step1();
    }
}

