/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.result;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.handler.ResultRedisHandler;
import com.humuson.tms.manager.util.StatusCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-result-crslt", name={"result-use"}, havingValue="true", matchIfMissing=true)
public class SaveSentResultInRedisToRdbScheduler {
    private static final Logger log = LoggerFactory.getLogger(SaveSentResultInRedisToRdbScheduler.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private ResultRedisHandler processResultHandler;
    @Autowired
    StatusCheckerUtil statusCheckerUtil;
    @Autowired
    @Qualifier(value="mnAsyncTask")
    ThreadPoolTaskExecutor threadPoolExecutor;
    @Value(value="${tms.manager.proc-result.scan-cnt}")
    public int CRSLT_MIN_CNT;
    @Value(value="${tms.manager.proc-result.scan-limit}")
    public int CRSLT_MAX_CNT;
    @Value(value="${tms.manager.proc-result.scan-retry-cnt:12}")
    public int CRSLT_SCAN_RETRY_CNT;
    @Value(value="${tms.manager.proc-result.thread-limit}")
    public int RESULT_WORK_LIMIT_COUNT;
    @Value(value="${tms.manager.proc-result.drop-interval-minute}")
    public int DROP_INTERVAL_MINUTE;
    @Value(value="${tms.manager.thread.async.max-pool}")
    private int MAX_POOL_SIZE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DistributeLock(value="lock.manager.scheduled.crslt")
    @Scheduled(fixedDelayString="${tms.manager.proc-result.interval}")
    public void schedule() {
        long start = System.currentTimeMillis();
        int index = 0;
        int totalStartedThread = 0;
        int currentlyListSize = 0;
        int lockedCRSLT = 0;
        int maxCount = this.CRSLT_MAX_CNT;
        List resultKeyList = null;
        try {
            resultKeyList = this.wrapperRedisTemplate.scan("CRSLT", this.CRSLT_MIN_CNT, this.CRSLT_MAX_CNT);
            currentlyListSize = resultKeyList.size();
            for (index = 0; index < this.CRSLT_SCAN_RETRY_CNT; ++index) {
                if (log.isDebugEnabled()) {
                    log.debug("REDIS_CRSLT read result size={} / limit size[{}]", (Object)resultKeyList.size(), (Object)this.CRSLT_MAX_CNT);
                }
                for (int i = maxCount - this.CRSLT_MAX_CNT; i < resultKeyList.size(); ++i) {
                    String crsltYyyymmddssmidd;
                    String crsltResultKey = (String)resultKeyList.get(i);
                    if (log.isDebugEnabled()) {
                        log.debug("REDIS_CRSLT read i:{}, lenght:{}, result key={}", new Object[]{i, resultKeyList.size(), crsltResultKey});
                    }
                    if (this.checkProcess(crsltYyyymmddssmidd = crsltResultKey.split(":")[2])) {
                        if (this.RESULT_WORK_LIMIT_COUNT > totalStartedThread && !this.statusCheckerUtil.isAsyncThreadStocked(null)) {
                            if (this.isResultKeyWorkFinished(crsltResultKey)) {
                                boolean isOverOfDropIntervalMinute = this.checkDropTarget(this.DROP_INTERVAL_MINUTE, crsltYyyymmddssmidd);
                                this.processResultHandler.process(isOverOfDropIntervalMinute, crsltResultKey);
                                ++totalStartedThread;
                                continue;
                            }
                            log.debug("REDIS_CRSLT[result key={}] is locked. {}", (Object)crsltResultKey, (Object)this.statusCheckerUtil.getThreadStatus());
                            ++lockedCRSLT;
                            continue;
                        }
                        log.debug("Result Handler process counter has reached limit. so break. work_limit_count={} now_thread_cnt={}/ thread_max_limit={} now_active_cnt={}", new Object[]{this.RESULT_WORK_LIMIT_COUNT, totalStartedThread, this.MAX_POOL_SIZE, this.threadPoolExecutor.getActiveCount()});
                        continue;
                    }
                    log.debug("REDIS_CRSLT[result key={}] is not availabel process. currentTime: {}", (Object)crsltResultKey, (Object)Long.parseLong(DateUtil.getFullDate((String)"yyyyMMddHHmm")));
                }
                if (this.RESULT_WORK_LIMIT_COUNT <= totalStartedThread || this.statusCheckerUtil.isAsyncThreadStocked(null)) break;
                resultKeyList.clear();
                resultKeyList = this.wrapperRedisTemplate.scan("CRSLT", this.CRSLT_MIN_CNT, maxCount += this.CRSLT_MAX_CNT);
                if (currentlyListSize == resultKeyList.size() || resultKeyList.size() == 0) break;
                currentlyListSize = resultKeyList.size();
            }
        }
        catch (Exception e) {
            try {
                log.error(MNSystemErrorCode.ERR_4010.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                log.debug("[SCHEDULER] END worked:{}, try:{}, readedCRSLT:{} [{}] seconds, {}", new Object[]{totalStartedThread + lockedCRSLT, index, currentlyListSize, (double)(end - start) / 1000.0, this.statusCheckerUtil.getThreadStatus()});
                throw throwable;
            }
            long end = System.currentTimeMillis();
            log.debug("[SCHEDULER] END worked:{}, try:{}, readedCRSLT:{} [{}] seconds, {}", new Object[]{totalStartedThread + lockedCRSLT, index, currentlyListSize, (double)(end - start) / 1000.0, this.statusCheckerUtil.getThreadStatus()});
        }
        long end = System.currentTimeMillis();
        log.debug("[SCHEDULER] END worked:{}, try:{}, readedCRSLT:{} [{}] seconds, {}", new Object[]{totalStartedThread + lockedCRSLT, index, currentlyListSize, (double)(end - start) / 1000.0, this.statusCheckerUtil.getThreadStatus()});
    }

    private boolean isResultKeyWorkFinished(String resultKey) {
        return !this.wrapperRedisTemplate.isLock("lock.manager.result.handler." + resultKey);
    }

    private boolean checkDropTarget(int dropIntervalMi, String targetTime) {
        return DateUtil.checkTimeoutSecondToNow((int)(dropIntervalMi * 60), (String)(targetTime + "00"));
    }

    private boolean checkProcess(String targetTime) {
        long currentTime = Long.parseLong(DateUtil.getFullDate((String)"yyyyMMddHHmm"));
        long crsltTargetTime = Long.parseLong(targetTime);
        return crsltTargetTime < currentTime;
    }
}

