/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.openclick;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.custom.batch.executor.StatUniqOpenClickBatchExecutor;
import com.humuson.tms.manager.custom.stat.dao.StatOpenClickDao;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.manager.util.StatusCheckerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class StatUniqOpenClickScheduler {
    private static final Logger log = LoggerFactory.getLogger(StatUniqOpenClickScheduler.class);
    @Value(value="${tms.manager.proc-stat-openclick.enable:true}")
    private String useFlag;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    LockCheckerUtil lockCheckerUtil;
    @Autowired
    StatOpenClickDao statOpenClickDao;
    @Autowired
    StatUniqOpenClickBatchExecutor statUniqOpenClickBatchExecutor;
    @Autowired
    StatusCheckerUtil statusCheckerUtil;
    @Value(value="${tms.manager.proc-stat-openclick.using-workday:false}")
    private String workdayUseFlag;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-interval:7}")
    private int trackingInterval;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-start-workday:7}")
    private int betweenStartWorkday;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-end-workday:0}")
    private int betweenEndWorkday;

    @Scheduled(fixedDelayString="${tms.manager.proc-stat-openclick.interval:10000}")
    public void schedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        if (!"true".equalsIgnoreCase(this.useFlag)) {
            log.debug("[StatUniqOpenClickScheduler] enabled is {}", (Object)this.useFlag);
            return;
        }
        if (this.statusCheckerUtil.isAsyncThreadStocked(this.getClass().getSimpleName())) {
            return;
        }
        long start = System.currentTimeMillis();
        int count = 0;
        try {
            long start1 = System.currentTimeMillis();
            count = "true".equalsIgnoreCase(this.workdayUseFlag) ? this.statOpenClickDao.countPastUniqOpenClick(this.betweenStartWorkday, this.betweenEndWorkday) : this.statOpenClickDao.countPastUniqOpenClickInterval(this.trackingInterval);
            long end1 = System.currentTimeMillis();
            log.debug("[QUERY] countPastUniqOpenClick startWorkday:{}, endWorkday:{} size:{}=======[{}] seconds ", new Object[]{this.betweenStartWorkday, this.betweenEndWorkday, count, (double)(end1 - start1) / 1000.0});
            if (count == 0) {
                long end = System.currentTimeMillis();
                log.debug("[SCHEDULER] END size:{}, [{}] seconds", (Object)count, (Object)((double)(end - start) / 1000.0));
                return;
            }
            this.statUniqOpenClickBatchExecutor.executor();
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4007.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
        }
        long end = System.currentTimeMillis();
        log.debug("[SCHEDULER] END size:{}, [{}] seconds", (Object)count, (Object)((double)(end - start) / 1000.0));
    }
}

