/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.monitor;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.util.date.DateUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.monitor.memory", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MemoryStateScheduler {
    private static final Logger log = LoggerFactory.getLogger(MemoryStateScheduler.class);
    @Value(value="${tms.daemon-type}")
    private String daemonType;
    @Value(value="${tms.daemon-id}")
    private String daemonId;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    private String key = null;
    @Value(value="${tms.manager.monitor.memory.critical-percent:80}")
    private int memoryMaxPercent;
    protected Logger liveTraceLogger = LoggerFactory.getLogger((String)"liveTraceLog");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.check-interval}")
    public void checkStateOfMemory() {
        MemoryInfo memoryInfo = new MemoryInfo().scanMemoryState();
        this.writeLiveTraceLog(memoryInfo);
        try {
            String pastMemoryInfo;
            if (log.isDebugEnabled()) {
                log.debug("checking memory infomation is ", (Object)memoryInfo);
            }
            if (this.key == null) {
                this.key = "JSTAT:" + this.daemonType;
            }
            pastMemoryInfo = StringUtils.isEmpty((CharSequence)(pastMemoryInfo = this.wrapperRedisTemplate.hmget(this.key, memoryInfo.getField()))) ? "" : pastMemoryInfo + "|";
            this.wrapperRedisTemplate.hmset(this.key, memoryInfo.getField(), pastMemoryInfo + memoryInfo.getHhmmss() + ":" + memoryInfo.getMaxMemoryMegaSize() + ":" + memoryInfo.getUsedMemoryMegaSize());
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4002.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
        }
        if (this.isCheckMemory()) {
            System.gc();
        }
    }

    public boolean isCheckMemory() {
        boolean res = false;
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        DecimalFormat df = new DecimalFormat("#0");
        String useMemory = df.format((double)memUsage.getUsed() / 1048576.0);
        String totalMemory = df.format((double)memUsage.getMax() / 1048576.0);
        int usePercent = (int)(Double.parseDouble(useMemory) / Double.parseDouble(totalMemory) * 100.0);
        if (usePercent >= this.memoryMaxPercent) {
            this.liveTraceLogger.info("HeapMemory::[CheckMemory] useMemory:{}/totalMemory:{},  criticalPercent:{} %,  usePercent:{} %", new Object[]{totalMemory, useMemory, this.memoryMaxPercent, usePercent});
            res = true;
        }
        return res;
    }

    private void writeLiveTraceLog(MemoryInfo memoryInfo) {
        this.liveTraceLogger.info("Redis::[CheckLive] KEY:{}, FIELD:{}, DATA:{} / max {} MB used {} MB", new Object[]{this.key, memoryInfo.getField(), memoryInfo.getHhmmss(), memoryInfo.getMaxMemoryMegaSize(), memoryInfo.getUsedMemoryMegaSize()});
    }

    private class MemoryInfo {
        private String usedMemoryMegaSize;
        private String maxMemoryMegaSize;
        private String field;
        private String yyyymmdd;
        private String hhmmss;

        public MemoryInfo scanMemoryState() {
            MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
            DecimalFormat df = new DecimalFormat("#0");
            this.setUsedMemoryMegaSize(df.format((double)memUsage.getUsed() / 1048576.0));
            this.setMaxMemoryMegaSize(df.format((double)memUsage.getMax() / 1048576.0));
            String[] dates = DateUtil.getDivideDateDefault();
            this.setYyyymmdd(dates[0]);
            this.setHhmmss(dates[1]);
            this.setField(MemoryStateScheduler.this.daemonId + ":" + dates[0]);
            return this;
        }

        public String getUsedMemoryMegaSize() {
            return this.usedMemoryMegaSize;
        }

        public String getMaxMemoryMegaSize() {
            return this.maxMemoryMegaSize;
        }

        public String getField() {
            return this.field;
        }

        public String getYyyymmdd() {
            return this.yyyymmdd;
        }

        public String getHhmmss() {
            return this.hhmmss;
        }

        public void setUsedMemoryMegaSize(String usedMemoryMegaSize) {
            this.usedMemoryMegaSize = usedMemoryMegaSize;
        }

        public void setMaxMemoryMegaSize(String maxMemoryMegaSize) {
            this.maxMemoryMegaSize = maxMemoryMegaSize;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setYyyymmdd(String yyyymmdd) {
            this.yyyymmdd = yyyymmdd;
        }

        public void setHhmmss(String hhmmss) {
            this.hhmmss = hhmmss;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemoryInfo)) {
                return false;
            }
            MemoryInfo other = (MemoryInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$usedMemoryMegaSize = this.getUsedMemoryMegaSize();
            String other$usedMemoryMegaSize = other.getUsedMemoryMegaSize();
            if (this$usedMemoryMegaSize == null ? other$usedMemoryMegaSize != null : !this$usedMemoryMegaSize.equals(other$usedMemoryMegaSize)) {
                return false;
            }
            String this$maxMemoryMegaSize = this.getMaxMemoryMegaSize();
            String other$maxMemoryMegaSize = other.getMaxMemoryMegaSize();
            if (this$maxMemoryMegaSize == null ? other$maxMemoryMegaSize != null : !this$maxMemoryMegaSize.equals(other$maxMemoryMegaSize)) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$yyyymmdd = this.getYyyymmdd();
            String other$yyyymmdd = other.getYyyymmdd();
            if (this$yyyymmdd == null ? other$yyyymmdd != null : !this$yyyymmdd.equals(other$yyyymmdd)) {
                return false;
            }
            String this$hhmmss = this.getHhmmss();
            String other$hhmmss = other.getHhmmss();
            return !(this$hhmmss == null ? other$hhmmss != null : !this$hhmmss.equals(other$hhmmss));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MemoryInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $usedMemoryMegaSize = this.getUsedMemoryMegaSize();
            result = result * 59 + ($usedMemoryMegaSize == null ? 43 : $usedMemoryMegaSize.hashCode());
            String $maxMemoryMegaSize = this.getMaxMemoryMegaSize();
            result = result * 59 + ($maxMemoryMegaSize == null ? 43 : $maxMemoryMegaSize.hashCode());
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $yyyymmdd = this.getYyyymmdd();
            result = result * 59 + ($yyyymmdd == null ? 43 : $yyyymmdd.hashCode());
            String $hhmmss = this.getHhmmss();
            result = result * 59 + ($hhmmss == null ? 43 : $hhmmss.hashCode());
            return result;
        }

        public String toString() {
            return "MemoryStateScheduler.MemoryInfo(usedMemoryMegaSize=" + this.getUsedMemoryMegaSize() + ", maxMemoryMegaSize=" + this.getMaxMemoryMegaSize() + ", field=" + this.getField() + ", yyyymmdd=" + this.getYyyymmdd() + ", hhmmss=" + this.getHhmmss() + ")";
        }
    }
}

