/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.repository.dao.SendDao;
import com.humuson.tms.manager.repository.model.ResultSendInfoModel;
import com.humuson.tms.manager.send.SendBasicService;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-send", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ResultRdbSendInfoScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResultRdbSendInfoScheduler.class);
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    SendDao sendDao;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SendBasicService sendBasicService;

    private void createSendInfo(ResultSendInfoModel rsm) {
        long sendId = rsm.getSendId();
        String triggerMethod = rsm.getTriggerMethod();
        String currentStatus = rsm.getCurrentStatus();
        int totalCnt = rsm.getSchdTotalCnt();
        int sendingCnt = rsm.getSchd30Cnt();
        int resultingCnt = rsm.getSchd38Cnt();
        int endCnt = rsm.getSchd40Cnt();
        int failCnt = rsm.getSchd41Cnt();
        int cancelCnt = rsm.getSchd42Cnt();
        int trackingEndCnt = rsm.getSchd43Cnt();
        int procTotalCnt = sendingCnt + resultingCnt + endCnt + failCnt + cancelCnt + trackingEndCnt;
        int resultCnt = endCnt + failCnt + trackingEndCnt + cancelCnt;
        int processTotalCnt = totalCnt - resultCnt;
        String uptTime = rsm.getUpdateDate();
        log.debug("[SENDINFO_PROC]triggerMethod {}, SEND ID : {} ,update send_info table : 30 [{}], 38 [{}], 40 [{}], 41 [{}], 42 [{}], 43 [{}] , : total [{}], send status : [{}] last Schd Status [{}]", new Object[]{triggerMethod, sendId, sendingCnt, resultingCnt, endCnt, failCnt, cancelCnt, trackingEndCnt, totalCnt, currentStatus, rsm.getLastSchdStatus()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.proc-send.interval}")
    public void schedule() {
        long start = System.currentTimeMillis();
        long workingSize = 0L;
        List<ResultSendInfoModel> sendList = this.sendDao.selectTargetSendList();
        long end = System.currentTimeMillis();
        log.debug("[QUERY] selectTargetSendList size:{} ============[{}] seconds", (Object)sendList.size(), (Object)((double)(end - start) / 1000.0));
        if (sendList == null || sendList.size() == 0) {
            end = System.currentTimeMillis();
            log.debug("[SCHEDULER] END worked:{}, [{}] seconds", (Object)workingSize, (Object)((double)(end - start) / 1000.0));
            return;
        }
        log.debug("target Send Data's size : {}  ", (Object)sendList.size());
        String triggerMethod = null;
        String currentStatus = null;
        for (ResultSendInfoModel rsm : sendList) {
            long sendId = rsm.getSendId();
            String lockName = "lock.manager.result.sendInfo." + sendId;
            LockController lockController = this.contexter.lock(lockName);
            try {
                if (lockController.isLocked()) {
                    log.info("[SCHEDULER] This SEND_ID({}) is already working lock[{}]", (Object)sendId, (Object)lockName);
                    continue;
                }
                lockController.lock();
                triggerMethod = rsm.getTriggerMethod();
                currentStatus = rsm.getCurrentStatus();
                int totalCnt = rsm.getSchdTotalCnt();
                int sendingCnt = rsm.getSchd30Cnt();
                int resultingCnt = rsm.getSchd38Cnt();
                int endCnt = rsm.getSchd40Cnt();
                int failCnt = rsm.getSchd41Cnt();
                int cancelCnt = rsm.getSchd42Cnt();
                int trackingEndCnt = rsm.getSchd43Cnt();
                int procTotalCnt = sendingCnt + resultingCnt + endCnt + failCnt + cancelCnt + trackingEndCnt;
                int resultCnt = endCnt + failCnt + trackingEndCnt + cancelCnt;
                int processTotalCnt = totalCnt - resultCnt;
                boolean expiresSendingMultiEndFlag = false;
                String currentDate = null;
                String uptTime = rsm.getUpdateDate();
                String cancelTime = DateUtil.getFullDateDefaultFormat();
                if (rsm.getCampType().equals("T")) {
                    currentDate = DateUtil.getWorkday();
                    log.debug("currentDate : {} getCampEndTime {}", (Object)currentDate, (Object)Integer.parseInt(rsm.getCampEndTime()));
                    if (Integer.parseInt(rsm.getCampEndTime()) < Integer.parseInt(currentDate) && !currentStatus.equals("31") && !currentStatus.equals("32")) {
                        expiresSendingMultiEndFlag = true;
                    }
                }
                if (this.sendBasicService.isStartSendProcess(rsm)) {
                    this.updateSendInfo(rsm, "42");
                    ++workingSize;
                    continue;
                }
                if (rsm.getCampType().equals("T")) {
                    currentDate = DateUtil.getWorkday();
                    log.debug("currentDate : {} getCampEndTime {}", (Object)currentDate, (Object)Integer.parseInt(rsm.getCampEndTime()));
                    if (Integer.parseInt(rsm.getCampEndTime()) >= Integer.parseInt(currentDate) || currentStatus.equals("31") || currentStatus.equals("32")) continue;
                    if (processTotalCnt != 0) {
                        this.updateSendInfo(rsm, "31");
                        ++workingSize;
                        continue;
                    }
                    this.updateSendInfo(rsm, "43");
                    ++workingSize;
                    continue;
                }
                if (currentStatus.equals("31")) continue;
                if (triggerMethod.equals(Constants.TriggerMethod.F1.toString()) || triggerMethod.equals(Constants.TriggerMethod.C5.toString())) {
                    if (rsm.getLastSchdStatus().equals("41")) {
                        this.updateSendInfo(rsm, "41");
                        ++workingSize;
                    }
                    log.debug("this Target Send ID [{}] : Skip [iImmediate delivery or real Time Send", (Object)sendId);
                    continue;
                }
                if (currentStatus.equals("32") || totalCnt == sendingCnt) continue;
                if (resultingCnt > 0 && currentStatus.equals("30")) {
                    this.updateSendInfo(rsm, "38");
                    ++workingSize;
                    continue;
                }
                if (failCnt > 0 && totalCnt == failCnt) {
                    this.updateSendInfo(rsm, "41");
                    ++workingSize;
                    continue;
                }
                if (processTotalCnt != 0) continue;
                if (resultCnt > 0) {
                    if (currentStatus.equals("38") || currentStatus.equals("30")) {
                        log.info("[SCHD_STATE_RESULTING] triggerMethod : {}, resultCnt : {}, lastSchdStatus: {}", new Object[]{triggerMethod, resultCnt, rsm.getLastSchdStatus()});
                        if (triggerMethod.equals(Constants.TriggerMethod.O9.toString()) || triggerMethod.equals(Constants.TriggerMethod.C1.toString()) || triggerMethod.equals(Constants.TriggerMethod.C2.toString()) || triggerMethod.equals(Constants.TriggerMethod.C3.toString()) || triggerMethod.equals(Constants.TriggerMethod.C4.toString())) {
                            if (rsm.getLastSchdStatus().equals("41")) {
                                this.updateSendInfo(rsm, "41");
                                ++workingSize;
                                continue;
                            }
                            this.updateSendInfo(rsm, "10");
                            ++workingSize;
                            continue;
                        }
                        if (totalCnt != resultCnt) continue;
                        this.updateSendInfo(rsm, "40");
                        ++workingSize;
                        continue;
                    }
                    if (trackingEndCnt > 0 && totalCnt == procTotalCnt && endCnt == 0) {
                        log.info("Tracking End : sendId {} trackingEndCnt {} totalCnt {} procTotalCnt {} endCnt {}", new Object[]{sendId, trackingEndCnt, totalCnt, procTotalCnt, endCnt});
                        this.updateSendInfo(rsm, "43");
                        ++workingSize;
                        continue;
                    }
                    if (!currentStatus.equals("31")) continue;
                    continue;
                }
                if (totalCnt != 0 || resultCnt != 0) continue;
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4035.makeLogMsg(this), new Object[]{sendId, e.getMessage(), e});
            }
            finally {
                if (lockController == null) continue;
                lockController.unLock();
            }
        }
        if (sendList != null) {
            sendList.clear();
            sendList = null;
        }
        end = System.currentTimeMillis();
        log.info("[SCHEDULER] END worked:{}, [{}] seconds", (Object)workingSize, (Object)((double)(end - start) / 1000.0));
    }

    public int updateSendInfo(ResultSendInfoModel rsm, String jobstate) {
        if (this.sendDao.countSendInfoByJobStatus(rsm.getSendId(), rsm.getCurrentStatus()) < 1) {
            return 0;
        }
        Object updateJobstatus = null;
        switch (jobstate) {
            case "31": {
                this.sendBasicService.sendResult31Process(rsm);
                break;
            }
            case "32": {
                this.sendBasicService.sendResult32Process(rsm);
                break;
            }
            case "38": {
                this.sendBasicService.sendResult38Process(rsm);
                break;
            }
            case "40": {
                this.sendBasicService.sendResult40Process(rsm);
                break;
            }
            case "41": {
                this.sendBasicService.sendResult41Process(rsm);
                break;
            }
            case "42": {
                this.sendBasicService.sendResult42Process(rsm);
                break;
            }
            case "43": {
                this.sendBasicService.sendResult43Process(rsm);
                break;
            }
            case "10": {
                this.sendBasicService.sendResult10Process(rsm);
                break;
            }
        }
        long startDb = System.currentTimeMillis();
        int result = this.sendDao.updateSendInfoJobState(rsm.getSendId(), jobstate);
        long endDb = System.currentTimeMillis();
        if (result > 0) {
            log.info("[QUERY] updateSendInfo sendId:{} currentStatus{}, changeJobStatus:{} ============[{}] seconds", new Object[]{rsm.getSendId(), rsm.getCurrentStatus(), jobstate, (double)(endDb - startDb) / 1000.0});
        }
        return result;
    }

    public boolean isCanceled(ResultSendInfoModel rsm) {
        if (rsm.getUpdateDate() == null) {
            return false;
        }
        return Long.parseLong(rsm.getUpdateDate()) + 10L < Long.parseLong(DateUtil.getFullDateDefaultFormat());
    }
}

