/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.handler.MonitorSendProcessHandler;
import com.humuson.tms.manager.repository.model.SprocModel;
import com.humuson.tms.manager.stat.Stat;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class MonitorSendProcessScheduler {
    private static final Logger log = LoggerFactory.getLogger(MonitorSendProcessScheduler.class);
    @Autowired
    private LockContexter contexter;
    @Autowired
    Stat statService;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    private final int DEMON_TYPE = 0;
    private final int DEMON_SERVER_ID = 1;
    private final int DEMON_STATUS = 2;
    private final int DEMON_TIME = 3;
    private final int DEMON_INPUT = 4;
    private final int DEMON_PROCESS = 5;
    private final int DEMON_OUTPUT = 6;
    @Autowired
    private MonitorSendProcessHandler processSendMoniterHandler;
    @Value(value="${tms.manager.moniter.send-process.scan-cnt}")
    public int scanCnt;
    @Value(value="${tms.manager.moniter.send-process.scan-limit}")
    public int scanLimit;
    @Value(value="${tms.manager.moniter.send-process.timeout-sender}")
    public int timeoutSender;
    @Value(value="${tms.manager.moniter.send-process.timeout-mapper}")
    public int timeoutMapper;
    @Value(value="${tms.manager.moniter.send-process.timeout-controller}")
    public int timeoutController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        if (!this.wrapperRedisTemplate.isLock("lock.manager.monitor.send")) {
            log.info("[MonitorSendProcessScheduler] START -> Time :{} ", (Object)DateUtil.getFullDateDefaultFormat());
            LockController lockController = this.contexter.lock("lock.manager.monitor.send");
            lockController.lock();
            int threadIndex = 0;
            List sprocKeyList = null;
            Map sprocMap = null;
            try {
                sprocKeyList = this.wrapperRedisTemplate.scan("SPROC", this.scanCnt, this.scanLimit);
                log.debug("[MonitorSendProcessScheduler] scanLimit {} schdKeyList size {}", (Object)this.scanLimit, (Object)sprocKeyList.size());
                int blankValueCnt = 0;
                block13: for (String sprocKey : sprocKeyList) {
                    blankValueCnt = 0;
                    String[] schds = sprocKey.split(":");
                    Map infoMap = null;
                    try {
                        infoMap = this.wrapperRedisTemplate.hgetAllString("PINFO:" + schds[1]);
                        if (infoMap != null) {
                            log.debug("{} infoMap.size {}", (Object)("PINFO:" + schds[1]), (Object)infoMap.size());
                        }
                    }
                    catch (Exception e) {
                        log.error(MNSystemErrorCode.ERR_4030.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
                    }
                    if (infoMap == null || infoMap.size() < 10) {
                        this.dropRedisReqEmpty(infoMap == null, schds[1]);
                        break;
                    }
                    sprocMap = this.wrapperRedisTemplate.hgetAllString(sprocKey);
                    for (String field : sprocMap.keySet()) {
                        String value = (String)sprocMap.get(field);
                        SprocModel sprocModel = null;
                        if (value != null && !"".equals(value)) {
                            sprocModel = this.processState(infoMap, sprocKey, field, value);
                        } else {
                            ++blankValueCnt;
                        }
                        if (threadIndex < this.scanLimit) continue;
                        continue block13;
                    }
                }
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4031.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
            }
            finally {
                try {
                    if (sprocMap != null) {
                        sprocMap.clear();
                    }
                    if (lockController != null) {
                        lockController.unLock();
                        lockController.close();
                    }
                }
                catch (Exception e) {
                    log.error(MNSystemErrorCode.ERR_4032.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
                }
            }
            log.info("[MonitorSendProcessScheduler]end {} starting thread ", (Object)threadIndex);
        } else {
            log.warn("[LOCK] {} is already locking... this schd is pass", (Object)"lock.manager.monitor.send");
        }
    }

    private SprocModel processState(Map<String, String> infoMap, String sprocKey, String field, String value) throws Exception {
        SprocModel sprocModel = null;
        try {
            if (value.endsWith("|")) {
                value = value.substring(0, value.length() - 1);
            }
            String[] states = value.split("\\|");
            int stateLength = states.length;
            boolean isTimeout = false;
            boolean isEnd = false;
            log.debug("last part : {}", (Object)states[stateLength - 1]);
            SprocModel.SprocModelBuilder sprocBuild = SprocModel.builder();
            for (String sprocDatas : states) {
                String[] sprocs = sprocDatas.split(":");
                if (sprocs[0].equals("CT")) {
                    sprocBuild.ctDemonServerId(sprocs[1]).ctDemonInput(sprocs[4]).ctDemonOutput(sprocs[6]).ctDemonProcess(sprocs[5]).ctDemonTime(sprocs[3]).ctDemonStatus(sprocs[2]);
                    continue;
                }
                if (!sprocs[0].equals("MP")) continue;
                if (sprocs[2].equals("10")) {
                    sprocBuild.mpStDemonServerId(sprocs[1]).mpStDemonInput(sprocs[4]).mpStDemonTime(sprocs[3]).mpStDemonStatus(sprocs[2]);
                    continue;
                }
                if (sprocs[2].equals("40")) {
                    sprocBuild.mpEnDemonServerId(sprocs[1]).mpEnDemonTime(sprocs[3]).mpEnDemonStatus(sprocs[2]).mpEnDemonInput(sprocs[4]);
                    continue;
                }
                sprocBuild.mpEnDemonServerId(sprocs[1]).mpEnDemonTime(sprocs[3]).mpEnDemonStatus(sprocs[2]);
            }
            sprocModel = sprocBuild.build();
            boolean cancelTargetFlag = false;
            if (sprocModel.getCtDemonStatus() != null && sprocModel.getCtDemonStatus().equals("42")) {
                cancelTargetFlag = true;
            }
            if (sprocModel.getMpStDemonStatus() != null && sprocModel.getMpStDemonStatus().equals("42")) {
                cancelTargetFlag = true;
            }
            if (sprocModel.getMpEnDemonStatus() != null && sprocModel.getMpEnDemonStatus().equals("42")) {
                cancelTargetFlag = true;
            }
            sprocModel.setCancelTargetFlag(cancelTargetFlag);
            String timeOut = null;
            log.debug("cancelTargetFlag {} [ sprocModel {}", (Object)cancelTargetFlag, (Object)sprocModel.toString());
            if (sprocModel.getMpStDemonTime() != null) {
                if (sprocModel.getMpEnDemonStatus() != null) {
                    isEnd = true;
                } else {
                    isTimeout = DateUtil.checkTimeoutSecondToNow((int)this.timeoutMapper, (String)sprocModel.getMpStDemonTime());
                    if (isTimeout) {
                        timeOut = sprocModel.getMpStDemonTime();
                    }
                }
            } else if (sprocModel.getCtDemonTime() != null) {
                isTimeout = DateUtil.checkTimeoutSecondToNow((int)this.timeoutController, (String)sprocModel.getCtDemonTime());
                if (isTimeout) {
                    timeOut = sprocModel.getMpStDemonTime();
                }
            } else {
                throw new ArrayIndexOutOfBoundsException("value daemon type is not match");
            }
            if (isEnd || cancelTargetFlag) {
                return sprocModel;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error(MNSystemErrorCode.ERR_4033.makeLogMsg(this), new Object[]{sprocKey, field, value, e.getMessage(), e});
            this.delRedisReqFormat(sprocKey, field);
        }
        return null;
    }

    private void dropRedisReqEmpty(boolean pinfoIsNull, String schdId) {
        log.info("[NOT MONITOR SEND TARGET] schdId {} is not have PINFO ", (Object)schdId);
        if (!pinfoIsNull) {
            this.wrapperRedisTemplate.del("PINFO:" + schdId);
            log.warn("[REDIS_DELETE] {} ", (Object)("PINFO:" + schdId));
        }
        this.wrapperRedisTemplate.del("SPROC:" + schdId);
        log.warn("[REDIS_DELETE] {} ", (Object)("SPROC:" + schdId));
        List tlistKeyList = this.wrapperRedisTemplate.scan("TLIST:" + schdId, this.scanCnt, this.scanLimit);
        if (tlistKeyList != null && tlistKeyList.size() > 0) {
            for (String tlistKey : tlistKeyList) {
                this.wrapperRedisTemplate.del(tlistKey);
            }
            log.warn("[REDIS_DELETE] {} target seq size {}", (Object)("TLIST:" + schdId), (Object)tlistKeyList.size());
        }
    }

    private void delRedisReqFormat(String sprocKey, String sprocField) {
        this.wrapperRedisTemplate.hmdel(sprocKey, sprocField);
        log.warn("[REDIS_DELETE] {} {}", (Object)sprocKey, (Object)sprocField);
        this.wrapperRedisTemplate.del("TLIST:" + sprocField);
        log.warn("[REDIS_DELETE] {}", (Object)("TLIST:" + sprocField));
    }
}

