/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.repository.dao.DomainFilterDao;
import com.humuson.tms.manager.repository.model.DomainFilterModel;
import com.humuson.tms.util.date.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-domain-filter", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MonitorDomainFilterScheduler {
    private static final Logger log = LoggerFactory.getLogger(MonitorDomainFilterScheduler.class);
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    DomainFilterDao dfDao;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired
    JdbcTemplate jdbcTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.proc-domain-filter.interval:30000}")
    public void schedule() {
        LockController lockController = this.contexter.lock("lock.manager.result.domainFilter");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.result.domainFilter");
            return;
        }
        lockController.lock();
        long start = System.currentTimeMillis();
        long workingSize = 0L;
        long currentTime = this.createCurrentTime();
        List<DomainFilterModel> dfList = this.dfDao.selectDomainFilterList(String.valueOf(currentTime));
        if (dfList != null && dfList.size() != 0) {
            workingSize = dfList.size();
            try {
                List dinfoKeyMap = this.wrapperRedisTemplate.scan("DINFO", 100, 10000);
                if (dinfoKeyMap != null && dinfoKeyMap.size() > 0) {
                    for (DomainFilterModel dfModel : dfList) {
                        boolean delFalg = false;
                        if (currentTime > Long.parseLong(dfModel.getLimitTime()) || dfModel.getDelYn().equals("Y")) {
                            delFalg = true;
                        }
                        DomainFilterModel dfResultModel = this.applyDomainFilter(dfModel, delFalg, dinfoKeyMap);
                        long startDb = System.currentTimeMillis();
                        this.dfDao.updateProcComplDomain(dfResultModel);
                        long endDb = System.currentTimeMillis();
                        log.debug("[QUERY] updateProcComplDomain ============[{}] seconds", (Object)((double)(endDb - startDb) / 1000.0));
                    }
                }
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4027.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
            }
            finally {
                if (dfList != null) {
                    dfList.clear();
                    dfList = null;
                }
            }
        }
        if (lockController != null) {
            lockController.unLock();
        }
        long end = System.currentTimeMillis();
        log.debug("[SCHEDULER] END worked:{} [{}] seconds", (Object)workingSize, (Object)((double)(end - start) / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainFilterModel applyDomainFilter(DomainFilterModel dfModel, boolean delFalg, List<String> dinfoKeyMap) {
        JsonObject targetDfValue = null;
        JsonParser parser = null;
        JsonObject dinfoJson = null;
        try {
            for (String dinfoKey : dinfoKeyMap) {
                String dinfoValue = this.wrapperRedisTemplate.hmget(dinfoKey, dfModel.getDomain());
                if (delFalg) {
                    dfModel.setDelYn("D");
                    if (dinfoValue == null) continue;
                    this.wrapperRedisTemplate.hmdel(dinfoKey, dfModel.getDomain());
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)dinfoValue)) {
                    targetDfValue = new JsonObject();
                    targetDfValue.addProperty("mx", "");
                    targetDfValue.addProperty("ip", "");
                    targetDfValue.addProperty("useYn", "D");
                    targetDfValue.addProperty("regDate", dfModel.getRegDate());
                    targetDfValue.addProperty("expirationDate", dfModel.getLimitTime());
                    dinfoValue = targetDfValue.toString();
                } else {
                    parser = new JsonParser();
                    dinfoJson = parser.parse(dinfoValue).getAsJsonObject();
                    dinfoJson.addProperty("useYn", "D");
                    dinfoJson.addProperty("regDate", dfModel.getRegDate());
                    dinfoJson.addProperty("expirationDate", dfModel.getLimitTime());
                    dinfoValue = dinfoJson.toString();
                }
                this.wrapperRedisTemplate.hmset(dinfoKey, dfModel.getDomain(), dinfoValue);
            }
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4029.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (dinfoJson != null) {
                dinfoJson = null;
            }
            if (parser != null) {
                parser = null;
            }
            if (targetDfValue != null) {
                targetDfValue = null;
            }
        }
        return dfModel;
    }

    public long createCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parsedDate = null;
        try {
            parsedDate = dateFormat.parse(DateUtil.getFullDate((String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (ParseException e1) {
            log.error(MNSystemErrorCode.ERR_4028.makeLogMsg(this), (Object)e1.getMessage(), (Object)e1);
        }
        if (parsedDate == null) {
            return 0L;
        }
        return parsedDate.getTime();
    }
}

