/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.result;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.humuson.tms.adaptor.activemq.ActiveMQSender;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.crypto.HumusonEncryptor;
import com.humuson.tms.manager.repository.dao.MonitorSendDao;
import com.humuson.tms.manager.repository.dao.ResultDao;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SendListModel;
import com.humuson.tms.manager.result.ResultRedis;
import com.humuson.tms.manager.util.ManagerUtil;
import com.humuson.tms.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@TmsComponent
@Scope(value="prototype")
@Transactional(isolation=Isolation.READ_COMMITTED)
public class ResultBasicRedis
implements ResultRedis {
    private static final Logger log = LoggerFactory.getLogger(ResultBasicRedis.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    ResultDao resultDao;
    @Autowired
    MonitorSendDao monitorSendDao;
    @Autowired
    TmsBatchSqlExecutor<SendListModel> sqlExecutor;
    @Autowired
    @Qualifier(value="resultLogBlockQueue")
    BlockingQueue resultLogBlockQueue;
    @Value(value="${tms.manager.proc-result.logging-file-use}")
    private String loggingFileUse;
    @Value(value="${tms.manager.proc-result.logging-fail-sep}")
    private String loggingFailSep;
    @Value(value="${tms.manager.proc-result.logging-rdb-use}")
    private String loggingRdbUse;
    @Value(value="${tms.manager.proc-result.logging-hardbounce-use}")
    private String loggingHardbounceUse;
    @Value(value="${tms.manager.proc-result.max-detail-byte}")
    private int maxDetailByte;
    @Value(value="${tms.manager.proc-result.del-redis-type}")
    private String delRedisType;
    @Value(value="${tms.manager.resend-queue.use}")
    private String queueUesYn;
    @Value(value="${tms.manager.resend-queue.queue-name}")
    private String queueName;
    @Value(value="${tms.manager.resend-queue.limit-size}")
    private String queueSize;
    @Value(value="${tms.manager.resend-queue.resend-codes}")
    private String resendCodes;
    @Value(value="${tms.manager.content.path}")
    private String contentPath;
    @Value(value="${tms.manager.watcher.file.url}")
    private String watcherFileUrl;
    @Value(value="${tms.manager.fullcontent-del-flag}")
    private boolean deleteFullContentFlag = false;
    @Autowired
    @Qualifier(value="tmsRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    TmsCommonConfig tmsCommonConfig;
    @Autowired
    @Qualifier(value="activemq-sender")
    ActiveMQSender activeMQsender;
    protected Logger resultTraceLogger = LoggerFactory.getLogger((String)"resultTraceLog");
    String MISSING_SERVER = "NN";
    @Autowired
    StatDao statDao;
    public static final String EXCEPT_ERROR_CODE = "11";
    public static final String SEND_CANCLE_CODE = "61";

    @Override
    public List<Map<String, String>> makeResultObj(String resultKey, Map<String, String> targetMap, Map<String, String> tmsCodeMap, Map<String, String> chnCodeMap) {
        String[] resultKeys = resultKey.split("\\:");
        String chnType = resultKeys[1];
        ArrayList<Map<String, String>> totalMapList = new ArrayList<Map<String, String>>();
        boolean isBulk = false;
        for (String crsltField : targetMap.keySet()) {
            String crsltValue = targetMap.get(crsltField);
            if (crsltValue != null && !"".equals(crsltValue)) {
                try {
                    String[] crsltFieldStrs = crsltField.split(":");
                    isBulk = "TMS_BULK".equals(crsltFieldStrs[3]);
                    JsonParser targetParser = new JsonParser();
                    JsonObject targetJson = targetParser.parse(crsltValue).getAsJsonObject();
                    String tlistKey = null;
                    tlistKey = targetJson.get("RESULT_TYPE").getAsString().equals("Q") ? "QLIST:" + crsltFieldStrs[1] + ":" + crsltFieldStrs[2] : "TLIST:" + crsltFieldStrs[1] + ":" + crsltFieldStrs[2];
                    if (isBulk) {
                        totalMapList.addAll(this.addBulkMapList(chnType, tmsCodeMap, chnCodeMap, crsltField, crsltValue, tlistKey));
                        continue;
                    }
                    totalMapList.add(this.addSingleMap(chnType, tmsCodeMap, chnCodeMap, crsltField, crsltValue, tlistKey));
                }
                catch (Exception e) {
                    log.error("{}", (Throwable)e);
                    log.error("[RESULT_PROCESS_ERROR] crsltField {} crsltValue {}", (Object)crsltField, (Object)crsltValue);
                }
                continue;
            }
            log.debug("crsltField {} is empty", (Object)crsltField);
        }
        return totalMapList;
    }

    public void addQueueTarget() {
    }

    private Map<String, String> addSingleMap(String chnType, Map<String, String> tmsCodeMap, Map<String, String> chnCodeMap, String crsltField, String crsltValue, String tlistKey) {
        String[] crsltFieldStrs = crsltField.split(":");
        Map totalMap = null;
        try {
            totalMap = JsonUtil.getMapFromJson((String)crsltValue);
            String tlistField = crsltFieldStrs[3] + ":" + crsltFieldStrs[4];
            String tlistValue = this.wrapperRedisTemplate.hmget(tlistKey, tlistField);
            totalMap.putAll(JsonUtil.getMapFromJson((String)crsltValue));
            totalMap.put("TLIST_KEY", tlistKey);
            totalMap.put("TLIST_FIELD", tlistField);
            totalMap.put("CRSLT_FIELD", crsltField);
            totalMap.put("CHANNEL_TYPE", chnType);
            totalMap.put("SEND_ID", crsltFieldStrs[0]);
            totalMap.put("SCHD_ID", crsltFieldStrs[1]);
            totalMap.put("TARGET_SEQ", crsltFieldStrs[2]);
            totalMap.put("MEMBER_ID", crsltFieldStrs[3]);
            totalMap.put("UNIQUE_SEQ", crsltFieldStrs[4]);
            String resultCode = this.judgeResultCode((String)totalMap.get("ERROR_CODE"), tmsCodeMap, chnCodeMap);
            String isfileWrite = null;
            if (!StringUtils.isEmpty((Object)tlistValue)) {
                totalMap.putAll(JsonUtil.getMapFromJson((String)tlistValue));
                String campType = "N";
                if (totalMap.containsKey("CAMP_TYPE")) {
                    campType = (String)totalMap.get("CAMP_TYPE");
                }
                if (totalMap.containsKey("MAP_FILE_SAVE_YN")) {
                    isfileWrite = (String)totalMap.get("MAP_FILE_SAVE_YN");
                }
                if (!StringUtils.isEmpty(isfileWrite)) {
                    totalMap.put("EVENT_INFO1", isfileWrite);
                    switch (isfileWrite) {
                        case "Y": {
                            totalMap.put("EVENT_INFO2", totalMap.get("MAP_FILE_IP"));
                            totalMap.put("EVENT_INFO3", totalMap.get("MAP_FILE_PATH"));
                            break;
                        }
                        case "N": {
                            totalMap.put("CONTENT_DATA", this.convertTlistValueToContentData(tlistValue));
                            break;
                        }
                        default: {
                            log.error("CRSLT_PROC] TLIST MAP_FILE_SAVE_YN Value : {}", (Object)isfileWrite);
                        }
                    }
                }
                this.resendQueue(resultCode, crsltFieldStrs[0], crsltFieldStrs[1], crsltFieldStrs[2], tlistKey, tlistField, tlistValue, chnType, campType);
            } else {
                log.debug("[TLIST is empty] tlistKey [{}] tlistField [{}] tlistValue [{}]", new Object[]{tlistKey, tlistField, tlistValue});
            }
            totalMap.put("STATUS", resultCode);
        }
        catch (Exception e) {
            log.error("[addSingleMapList] TLIST key {} CRSLT field {} Exception : {}", new Object[]{tlistKey, crsltField, e});
        }
        return totalMap;
    }

    public boolean checkTlistAllBlank(Map<String, String> tlistValues) {
        boolean isCheckResult = true;
        Iterator<String> targetTlistValue = tlistValues.keySet().iterator();
        String targetField = null;
        String targetValue = null;
        while (targetTlistValue.hasNext()) {
            targetField = targetTlistValue.next();
            targetValue = tlistValues.get(targetField);
            if (StringUtils.isEmpty((Object)targetValue)) continue;
            isCheckResult = false;
            break;
        }
        return isCheckResult;
    }

    public void resendQueue(String resultCode, String sendId, String schdId, String targetSeq, String tlistKey, String tlistField, String tlistValue, String chanelType, String campType) {
        if (this.queueUesYn.equals("Y") && !campType.equals("T") && this.resendCodes.indexOf(resultCode) > 0 && (chanelType.equals(Constants.ChannelType.EM.toString()) || chanelType.equals(Constants.ChannelType.PU.toString()))) {
            try {
                String qlistKey = tlistKey.replaceAll("TLIST", "QLIST");
                JsonParser parser = new JsonParser();
                boolean whetherQueueSend = false;
                int queueCnt = 0;
                String queueMqKey = null;
                JsonObject queueJson = parser.parse(tlistValue).getAsJsonObject();
                if (queueJson.has("QUEUE_TIMES")) {
                    queueCnt = Integer.parseInt(queueJson.get("QUEUE_TIMES").getAsString());
                    if (queueCnt < Integer.parseInt(this.queueSize)) {
                        queueJson.addProperty("QUEUE_TIMES", String.valueOf(++queueCnt));
                        whetherQueueSend = true;
                    }
                } else {
                    queueJson.addProperty("QUEUE_TIMES", "1");
                    whetherQueueSend = true;
                }
                if (whetherQueueSend) {
                    queueMqKey = sendId.concat(":").concat(schdId).concat(":").concat(targetSeq);
                    JsonObject queueMqMessage = new JsonObject();
                    queueMqMessage.add("domain", queueJson.get("DOMAIN"));
                    queueMqMessage.addProperty("key", queueMqKey);
                    queueMqMessage.addProperty("memberId", queueJson.get("TMS_M_ID").getAsString().concat(":").concat(queueJson.get("UNIQUE_SEQ").getAsString()));
                    queueMqMessage.addProperty("channelType", chanelType);
                    queueMqMessage.addProperty("company", "tms");
                    queueMqMessage.addProperty("sendType", Constants.SendType.Q.toString());
                    this.wrapperRedisTemplate.hmset(qlistKey, tlistField, queueJson.toString());
                    this.activeMQsender.send(this.queueName, queueMqMessage.toString());
                }
            }
            catch (Exception e) {
                log.error("SEND QUEUE ERROR : {}", (Throwable)e);
            }
        }
    }

    private String convertTlistValueToContentData(String tlistValue) throws JSONException {
        JSONObject tilstValueJson = new JSONObject(tlistValue);
        tilstValueJson.remove("TMS_M_TARGET");
        tilstValueJson.remove("TMS_M_ID");
        tilstValueJson.remove("TMS_M_NAME");
        tilstValueJson.remove("TMS_M_EMAIL");
        tilstValueJson.remove("TMS_M_PHONE");
        tilstValueJson.remove("UNIQUE_SEQ");
        tilstValueJson.remove("TRIGGER_METHOD");
        tilstValueJson.remove("DOMAIN");
        tilstValueJson.remove("MAP_FILE_SAVE_YN");
        return tilstValueJson.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> addBulkMapList(String chnType, Map<String, String> tmsCodeMap, Map<String, String> chnCodeMap, String crsltField, String crsltValue, String tlistKey) {
        ArrayList<Map<String, String>> bulkList = new ArrayList<Map<String, String>>();
        HashMap<String, String> totalMap = new HashMap<String, String>();
        Map bulkMap = null;
        try {
            String[] crsltFieldStrs = crsltField.split(":");
            bulkMap = this.wrapperRedisTemplate.hgetAllString(tlistKey);
            if (bulkMap != null && bulkMap.size() > 0) {
                Map tmpMap = JsonUtil.getMapFromJson((String)crsltValue);
                String campType = "N";
                for (String tlistField : bulkMap.keySet()) {
                    String status;
                    String tlistValue = (String)bulkMap.get(tlistField);
                    totalMap.put("TLIST_KEY", tlistKey);
                    totalMap.put("TLIST_FIELD", tlistField);
                    totalMap.put("SEND_ID", crsltFieldStrs[0]);
                    totalMap.put("TARGET_SEQ", crsltFieldStrs[2]);
                    totalMap.put("SCHD_ID", crsltFieldStrs[1]);
                    totalMap.put("CHANNEL_TYPE", chnType);
                    if (!StringUtils.isEmpty((Object)tlistValue)) {
                        totalMap.putAll(JsonUtil.getMapFromJson((String)tlistValue));
                        String isfileWrite = null;
                        Object contentData = null;
                        if (totalMap.containsKey("MAP_FILE_SAVE_YN")) {
                            isfileWrite = (String)totalMap.get("MAP_FILE_SAVE_YN");
                        }
                        if (!StringUtils.isEmpty(isfileWrite)) {
                            totalMap.put("EVENT_INFO1", isfileWrite);
                            switch (isfileWrite) {
                                case "Y": {
                                    totalMap.put("EVENT_INFO2", (String)totalMap.get("MAP_FILE_IP"));
                                    totalMap.put("EVENT_INFO3", (String)totalMap.get("MAP_FILE_PATH"));
                                    break;
                                }
                                case "N": {
                                    totalMap.put("CONTENT_DATA", this.convertTlistValueToContentData(tlistValue));
                                    break;
                                }
                                default: {
                                    log.error("CRSLT_PROC] TLIST MAP_FILE_SAVE_YN Value : {}", (Object)isfileWrite);
                                }
                            }
                        }
                    } else {
                        log.error("[TLIST is empty] {} {}", (Object)tlistKey, (Object)tlistField);
                    }
                    totalMap.put("WORKDAY", (String)tmpMap.get("WORKDAY"));
                    if (tmpMap.get("ERROR_DETAIL") != null && ((String)tmpMap.get("ERROR_DETAIL")).getBytes().length > this.maxDetailByte) {
                        totalMap.put("ERROR_DETAIL", this.getMaxByteString((String)tmpMap.get("ERROR_DETAIL"), this.maxDetailByte));
                    } else {
                        totalMap.put("ERROR_DETAIL", (String)tmpMap.get("ERROR_DETAIL"));
                    }
                    totalMap.put("RESULT_TYPE", (String)tmpMap.get("RESULT_TYPE"));
                    totalMap.put("SERVER_ID", (String)tmpMap.get("SERVER_ID"));
                    totalMap.put("ERROR_CODE", (String)tmpMap.get("ERROR_CODE"));
                    totalMap.put("SITE_ID", (String)tmpMap.get("SITE_ID"));
                    totalMap.put("MEMBER_ID", (String)totalMap.get("TMS_M_ID"));
                    if (totalMap.containsKey("CAMP_TYPE")) {
                        campType = (String)totalMap.get("CAMP_TYPE");
                    }
                    if ((status = (String)totalMap.get("STATUS")) == null || "".equals(status)) {
                        String resultCode = this.judgeResultCode((String)totalMap.get("ERROR_CODE"), tmsCodeMap, chnCodeMap);
                        this.resendQueue(resultCode, crsltFieldStrs[0], crsltFieldStrs[1], crsltFieldStrs[2], tlistKey, tlistField, tlistValue, chnType, campType);
                        totalMap.put("STATUS", resultCode);
                        totalMap.put("CRSLT_FIELD", crsltField);
                        bulkList.add(totalMap);
                    }
                    if (totalMap == null) continue;
                    totalMap.clear();
                }
                if (tmpMap != null) {
                    tmpMap.clear();
                    tmpMap = null;
                }
            } else {
                log.error("[addBulkMapList] TLIST is empty  {} {} {}", new Object[]{tlistKey, crsltField, crsltValue});
            }
        }
        catch (Exception e) {
            log.error("[addBulkMapList] {} {} {}, error:{}", new Object[]{tlistKey, crsltField, crsltValue, e});
        }
        finally {
            if (totalMap != null) {
                totalMap.clear();
                totalMap = null;
            }
            if (bulkMap != null) {
                bulkMap.clear();
                bulkMap = null;
            }
        }
        return bulkList;
    }

    public Map<String, String> getPinfo(String shcdId) throws Exception {
        String pinfoKey = null;
        pinfoKey = "PINFO".concat(":").concat(shcdId);
        return this.wrapperRedisTemplate.hgetAllString(pinfoKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void recordLog(boolean isDrop, String crsltKey, List<Map<String, String>> resultMapList) {
        block53: {
            totalStart = System.currentTimeMillis();
            resultList = new ArrayList<SendListModel>();
            emHardList = new ArrayList<SendListModel>();
            tlistBulkMap = new HashMap<K, V>();
            crsltBulkMap = new HashMap<K, V>();
            tlistValues = null;
            slm = null;
            tlistKey = null;
            tlistValue = null;
            tlistFiled = null;
            schdId = null;
            siteId = null;
            sendSubType = null;
            isEncrypt = false;
            pinfo = null;
            pinfoGrp = new HashMap<String, Map>();
            for (Map<String, String> resultMap : resultMapList) {
                ResultBasicRedis.log.debug("TMS_M_ID {} {}", (Object)resultMap.get("MEMBER_ID"), (Object)resultMap.get("UNIQUE_SEQ"));
                try {
                    slm = null;
                    if (resultMap.containsKey("SCHD_ID")) {
                        schdId = resultMap.get("SCHD_ID");
                        if (pinfoGrp.containsKey(schdId)) {
                            if (pinfo != null) {
                                pinfo.clear();
                            }
                            pinfo = (Map)pinfoGrp.get(schdId);
                        } else {
                            pinfo = this.getPinfo(schdId);
                            pinfoGrp.put(schdId, pinfo);
                        }
                        if (pinfo.containsKey("ENCRYPT_YN")) {
                            v0 = isEncrypt = ((String)pinfo.get("ENCRYPT_YN")).equals("Y") != false;
                        }
                        if (pinfo.get("TYPE") != null && pinfo.containsKey("TYPE")) {
                            sendSubType = (String)pinfo.get("TYPE");
                        }
                        if (pinfo.get("SITE_ID") != null && pinfo.containsKey("SITE_ID")) {
                            siteId = (String)pinfo.get("SITE_ID");
                        }
                    }
                    if (sendSubType != null) {
                        resultMap.put("TYPE", sendSubType);
                    }
                    if (siteId != null) {
                        resultMap.put("SITE_ID", siteId);
                    }
                    if ((slm = this.settingResultModel(resultMap, isEncrypt)).getChannelType().equals(Constants.ChannelType.EM.toString())) {
                        slm.setTmsMEmail(slm.getMemberTargetData());
                    } else if (slm.getChannelType().equals(Constants.ChannelType.SM.toString()) || slm.getChannelType().equals(Constants.ChannelType.KA.toString())) {
                        slm.setTmsMPhone(slm.getMemberTargetData());
                    } else if (slm.getChannelType().equals(Constants.ChannelType.PU.toString())) {
                        slm.setTmsMToken(slm.getMemberTargetData());
                    }
                    if (slm.getChannelType().equals("XP")) {
                        slm.setChannelType(Constants.ChannelType.PU.toString());
                    }
                    if ("Y".equals(this.loggingFileUse) && resultMap.get("STATUS") != null && "01".equals(resultMap.get("STATUS"))) {
                        start = System.currentTimeMillis();
                        this.resultTraceLogger.info("{} : {}", (Object)crsltKey, (Object)resultMap.toString());
                        end = System.currentTimeMillis();
                        ResultBasicRedis.log.info("[FILE] {} fileLogging  size {} END ============[{}] seconds", new Object[]{crsltKey, resultMap.size(), (double)(end - start) / 1000.0});
                    }
                    if ("Y".equals(this.loggingRdbUse)) {
                        if (slm.getLogDetail() != null) {
                            slm.setLogDetail(ManagerUtil.isSplitListByte(slm.getLogDetail(), 400));
                        }
                        if (slm.getCodeDetail() != null) {
                            slm.setCodeDetail(ManagerUtil.isSplitListByte(slm.getCodeDetail(), 40));
                        }
                        resultList.add(slm);
                    }
                    tlistKey = resultMap.get("TLIST_KEY");
                    tlistFiled = resultMap.get("TLIST_FIELD");
                    tlistValue = resultMap.get("TLIST_FIELD");
                    if (slm.getEventType().equals("Q")) {
                        if (slm.getQueueTime() > Integer.parseInt(this.queueSize) || this.resendCodes.indexOf(slm.getEventCode()) <= 0) {
                            this.wrapperRedisTemplate.hmdel(tlistKey, tlistFiled);
                        }
                        this.wrapperRedisTemplate.hmset(crsltKey, resultMap.get("CRSLT_FIELD"), "");
                    } else {
                        this.wrapperRedisTemplate.hmset(tlistKey, tlistFiled, "");
                        this.wrapperRedisTemplate.hmset(crsltKey, resultMap.get("CRSLT_FIELD"), "");
                        ResultBasicRedis.log.debug("[REDIS_BLANK] {} {} {}", new Object[]{this.delRedisType, tlistKey, resultMap.get("TLIST_FIELD")});
                        ResultBasicRedis.log.debug("[REDIS_BLANK] {} {} {}", new Object[]{this.delRedisType, crsltKey, resultMap.get("CRSLT_FIELD")});
                        tlistValues = this.wrapperRedisTemplate.hgetAllString(tlistKey);
                    }
                    if (!"Y".equals(this.loggingHardbounceUse) || !Constants.ChannelType.EM.toString().equals(slm.getChannelType()) || slm.getEventInfo1() == null || "".equals(slm.getEventInfo1()) || "01".equals(slm.getEventInfo1()) || "30".equals(slm.getEventInfo1()) || Integer.parseInt(slm.getEventInfo1()) >= 50) continue;
                    emHardList.add(slm);
                }
                catch (Exception e) {
                    ResultBasicRedis.log.error("resultMapList loop error:{}", (Throwable)e);
                }
            }
            if (pinfo != null) {
                pinfo.clear();
                pinfo = null;
            }
            if (pinfoGrp != null) {
                pinfoGrp.clear();
                pinfoGrp = null;
            }
            if (tlistBulkMap.isEmpty()) break block53;
            tlistIter = tlistBulkMap.keySet().iterator();
            cleanTargetTlistValue = null;
            while (tlistIter.hasNext()) {
                tlistKey = (String)tlistIter.next();
                cleanTargetTlistValue = (Map)tlistBulkMap.get(tlistKey);
                start = System.currentTimeMillis();
                try {
                    this.wrapperRedisTemplate.hmsetAll(tlistKey, cleanTargetTlistValue);
                    tlistValues = this.wrapperRedisTemplate.hgetAllString(tlistKey);
                }
                catch (Exception e) {
                    try {
                        ResultBasicRedis.log.error("[REDIS_BLANK] tlist blank tlistKey {}, error: {}", (Object)tlistKey, (Object)e);
                    }
                    catch (Throwable var27_35) {
                        end = System.currentTimeMillis();
                        ResultBasicRedis.log.info("[REDIS_BLANK] redisType:{}, key:{} size: {} END ============[{}] seconds", new Object[]{this.delRedisType, tlistKey, cleanTargetTlistValue.size(), (double)(end - start) / 1000.0});
                        if (cleanTargetTlistValue != null) {
                            cleanTargetTlistValue.clear();
                        }
                        throw var27_35;
                    }
                    end = System.currentTimeMillis();
                    ResultBasicRedis.log.info("[REDIS_BLANK] redisType:{}, key:{} size: {} END ============[{}] seconds", new Object[]{this.delRedisType, tlistKey, cleanTargetTlistValue.size(), (double)(end - start) / 1000.0});
                    if (cleanTargetTlistValue != null) {
                        cleanTargetTlistValue.clear();
                    } else {
                        ** GOTO lbl126
                    }
                }
                end = System.currentTimeMillis();
                ResultBasicRedis.log.info("[REDIS_BLANK] redisType:{}, key:{} size: {} END ============[{}] seconds", new Object[]{this.delRedisType, tlistKey, cleanTargetTlistValue.size(), (double)(end - start) / 1000.0});
                if (cleanTargetTlistValue != null) {
                    cleanTargetTlistValue.clear();
                }
                if (!this.checkTlistAllBlank(tlistValues)) continue;
                ResultBasicRedis.log.warn("[Delete] tlistKey : [{}] , tlistValues Size : [{}]", (Object)tlistKey, (Object)tlistValues.size());
                this.deleteFile(tlistKey, this.deleteFullContentFlag);
            }
        }
        if (tlistValues != null) {
            tlistValues.clear();
            tlistValues = null;
        }
        if (tlistBulkMap != null) {
            tlistBulkMap.clear();
            tlistBulkMap = null;
        }
        if (!crsltBulkMap.isEmpty()) {
            start = System.currentTimeMillis();
            try {
                this.wrapperRedisTemplate.hmsetAll(crsltKey, crsltBulkMap);
            }
            catch (Exception e) {
                ResultBasicRedis.log.error("[REDIS_BLANK] crslt blank crsltKey {}, error: {}", (Object)crsltKey, (Object)e);
            }
            end = System.currentTimeMillis();
            ResultBasicRedis.log.info("[REDIS_BLANK] redisType:{} key:{} size: {} END ============[{}] seconds", new Object[]{this.delRedisType, crsltKey, crsltBulkMap.size(), (double)(end - start) / 1000.0});
        }
        if (crsltBulkMap != null) {
            crsltBulkMap.clear();
            crsltBulkMap = null;
        }
        if (resultList.size() > 0) {
            for (SendListModel var22_25 : resultList) {
            }
            start = System.currentTimeMillis();
            try {
                ResultBasicRedis.log.debug("[ResultBasicRedis] {} insertSendList resultList size {} start", (Object)crsltKey, (Object)resultList.size());
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.ResultDao.insertSendList", resultList, false);
            }
            catch (Exception e) {
                ResultBasicRedis.log.error("[ResultBasicRedis] Bulk insert Error crsltKey {}, error: {}", (Object)crsltKey, (Object)e);
                for (SendListModel result : resultList) {
                    try {
                        this.resultDao.insertSendList(result);
                    }
                    catch (Exception e1) {
                        ResultBasicRedis.log.error("Single insertSendList Error : {}, {}", (Object)result.toLogString(), (Object)e1);
                    }
                }
            }
            end = System.currentTimeMillis();
            ResultBasicRedis.log.info("[QUERY] batch insertSendList size {}, CRSLT:{} END ============[{}] seconds", new Object[]{resultList.size(), crsltKey, (double)(end - start) / 1000.0});
        }
        if (resultList != null) {
            resultList.clear();
            resultList = null;
        }
        if (emHardList.size() > 0) {
            start = System.currentTimeMillis();
            try {
                ResultBasicRedis.log.debug("[ResultBasicRedis] {} insertHardbounceErr emHardList size {} start", (Object)crsltKey, (Object)emHardList.size());
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.ResultDao.insertHardbounceErr", emHardList, true);
            }
            catch (Exception e) {
                ResultBasicRedis.log.error("Bulk insert Error crsltKey {}, error:{}", (Object)crsltKey, (Object)e);
            }
            end = System.currentTimeMillis();
            ResultBasicRedis.log.info("[QUERY] insertHardbounceErr emHardList size {}, CRSLT:{} END ============[{}] seconds", new Object[]{emHardList.size(), crsltKey, (double)(end - start) / 1000.0});
        }
        if (emHardList != null) {
            emHardList.clear();
            emHardList = null;
        }
        totalEnd = System.currentTimeMillis();
        ResultBasicRedis.log.info("[SCHEDULER] END worked:{}, data:{} [{}] seconds", new Object[]{resultMapList.size(), crsltKey, (double)(totalEnd - totalStart) / 1000.0});
    }

    public SendListModel settingResultModel(Map<String, String> memberMap, boolean isEncrypt) {
        String channelType = null;
        SendListModel.SendListModelBuilder sendListModelBuiler = SendListModel.builder();
        sendListModelBuiler.logType("TMS_SEND_LIST").workday(memberMap.get("WORKDAY")).memberId(memberMap.get("MEMBER_ID")).channelType(memberMap.get("CHANNEL_TYPE")).memberIdSeq(memberMap.get("UNIQUE_SEQ")).memberName(memberMap.get("TMS_M_NAME")).domain(memberMap.get("DOMAIN")).logDetail(memberMap.get("ERROR_DETAIL")).eventCode(memberMap.get("STATUS")).eventType(memberMap.get("RESULT_TYPE")).codeDetail(memberMap.get("ERROR_CODE")).tmsMToken(memberMap.get("TMS_M_TOKEN")).eventTime(memberMap.get("END_TIME"));
        channelType = memberMap.get("CHANNEL_TYPE");
        if (memberMap.containsKey("TMS_M_EMAIL")) {
            sendListModelBuiler.tmsMEmail(isEncrypt ? HumusonEncryptor.encrypt((String)memberMap.get("TMS_M_EMAIL"), (String)this.tmsCommonConfig.getHumusonKey()) : memberMap.get("TMS_M_EMAIL"));
        }
        if (memberMap.containsKey("TMS_M_PHONE")) {
            sendListModelBuiler.tmsMPhone(isEncrypt ? HumusonEncryptor.encrypt((String)memberMap.get("TMS_M_PHONE"), (String)this.tmsCommonConfig.getHumusonKey()) : memberMap.get("TMS_M_PHONE"));
        }
        if (memberMap.containsKey("TMS_M_TARGET")) {
            if (!channelType.equals("PU")) {
                sendListModelBuiler.memberTargetData(isEncrypt ? HumusonEncryptor.encrypt((String)memberMap.get("TMS_M_TARGET"), (String)this.tmsCommonConfig.getHumusonKey()) : memberMap.get("TMS_M_TARGET"));
            } else {
                sendListModelBuiler.memberTargetData(memberMap.get("TMS_M_TARGET"));
            }
        }
        if (memberMap.containsKey("EVENT_INFO1")) {
            sendListModelBuiler.eventInfo1(memberMap.get("EVENT_INFO1"));
        }
        if (memberMap.containsKey("EVENT_INFO2")) {
            sendListModelBuiler.eventInfo2(memberMap.get("EVENT_INFO2"));
        }
        if (memberMap.containsKey("EVENT_INFO3")) {
            sendListModelBuiler.eventInfo3(memberMap.get("EVENT_INFO3"));
        }
        if (memberMap.get("TYPE") != null && memberMap.containsKey("TYPE") && memberMap.get("TYPE").equalsIgnoreCase("TMA") && memberMap.get("TMA_REQ_UID") != null && memberMap.containsKey("TMA_REQ_UID")) {
            sendListModelBuiler.eventInfo4(memberMap.get("TMA_REQ_UID"));
        }
        if (memberMap.get("EVENT_INFO5") != null && memberMap.containsKey("EVENT_INFO5")) {
            sendListModelBuiler.eventInfo5(memberMap.get("EVENT_INFO5"));
        }
        if (memberMap.containsKey("CONTENT_DATA")) {
            sendListModelBuiler.content(memberMap.get("CONTENT_DATA"));
        }
        if (memberMap.containsKey("DEVICE_ID")) {
            // empty if block
        }
        if (memberMap.containsKey("SCHD_ID")) {
            sendListModelBuiler.schdId(ManagerUtil.parseLong(memberMap.get("SCHD_ID")));
        }
        if (memberMap.containsKey("SEND_ID")) {
            sendListModelBuiler.sendId(ManagerUtil.parseLong(memberMap.get("SEND_ID")));
        }
        if (memberMap.containsKey("QUEUE_TIMES")) {
            sendListModelBuiler.queueTime(ManagerUtil.parseInt(memberMap.get("QUEUE_TIMES")));
        }
        if (memberMap.containsKey("SITE_ID")) {
            sendListModelBuiler.siteId(memberMap.get("SITE_ID"));
        }
        return sendListModelBuiler.build();
    }

    private String makeMonitorStr(String sendId, String schdId, String targetSeq, String daemonId, String endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append(sendId);
        sb.append(":");
        sb.append(schdId);
        sb.append(":");
        sb.append(targetSeq);
        sb.append(":");
        sb.append("SD");
        sb.append(":");
        sb.append(daemonId != null ? daemonId : this.MISSING_SERVER);
        sb.append(":");
        sb.append("40");
        sb.append(":");
        sb.append(endTime);
        return sb.toString();
    }

    @Override
    @Transactional
    public void monitorSendSchd(List<String> schdList) {
        for (String monitorStr : schdList) {
            log.debug("{}", (Object)monitorStr);
            String[] monitorStrs = monitorStr.split(":");
            int n = this.monitorSendDao.checkAlreadyRecord(Long.parseLong(monitorStrs[0]), Long.parseLong(monitorStrs[1]), monitorStrs[2], monitorStrs[3]);
        }
    }

    public String getMaxByteString(String str, int maxLen) {
        String curChar;
        StringBuilder sb = new StringBuilder();
        int curLen = 0;
        for (int i = 0; i < str.length() && (curLen += (curChar = str.substring(i, i + 1)).getBytes().length) <= maxLen; ++i) {
            sb.append(curChar);
        }
        return sb.toString();
    }

    public String judgeResultCode(String status, Map<String, String> tmsCodeMap, Map<String, String> chnCodeMap) {
        String resultCode = null;
        String defaultDomainApplyStatus = null;
        String defaultDomainApplyStatusUpper = null;
        String defaultDomainApplyStatusLower = null;
        String[] statuss = null;
        try {
            if (status.contains(".")) {
                statuss = status.split("\\.");
                if (statuss.length > 2) {
                    defaultDomainApplyStatus = statuss[0].concat(".").concat(statuss[1]).concat(".").concat("default");
                    defaultDomainApplyStatusUpper = statuss[0].toUpperCase().concat(".").concat(statuss[1]).concat(".").concat("default");
                    defaultDomainApplyStatusLower = statuss[0].toLowerCase().concat(".").concat(statuss[1]).concat(".").concat("default");
                } else {
                    defaultDomainApplyStatus = status;
                }
            }
            if (!StringUtils.isEmpty((Object)status.trim())) {
                if (chnCodeMap.containsKey(status = status.trim())) {
                    resultCode = chnCodeMap.get(status);
                } else if (tmsCodeMap.containsKey(status)) {
                    resultCode = status;
                }
                status = status.trim().toUpperCase();
                if (chnCodeMap.containsKey(status)) {
                    resultCode = chnCodeMap.get(status);
                } else if (tmsCodeMap.containsKey(status)) {
                    resultCode = status;
                }
                status = status.trim().toLowerCase();
                if (chnCodeMap.containsKey(status)) {
                    resultCode = chnCodeMap.get(status);
                } else if (tmsCodeMap.containsKey(status)) {
                    resultCode = status;
                }
                if (resultCode == null) {
                    if (chnCodeMap.containsKey(defaultDomainApplyStatus)) {
                        resultCode = chnCodeMap.get(defaultDomainApplyStatus);
                    } else if (chnCodeMap.containsKey(defaultDomainApplyStatusUpper)) {
                        resultCode = chnCodeMap.get(defaultDomainApplyStatusUpper);
                    } else if (chnCodeMap.containsKey(defaultDomainApplyStatusLower)) {
                        resultCode = chnCodeMap.get(defaultDomainApplyStatusLower);
                    }
                }
                if (resultCode == null && !StringUtils.isEmpty((Object)status)) {
                    if (status.indexOf("MP0") > -1 || status.indexOf("TMS0") > -1) {
                        resultCode = "01";
                    } else if (status.indexOf("MP1") > -1) {
                        resultCode = EXCEPT_ERROR_CODE;
                    } else if (status.indexOf("CT1") > -1) {
                        resultCode = "12";
                    } else if (status.indexOf("CT5") > -1 || status.indexOf("TMS7") > -1) {
                        resultCode = "50";
                    } else if (status.indexOf("CT6") > -1 || status.indexOf("MP6") > -1 || status.indexOf("TMS6") > -1) {
                        resultCode = SEND_CANCLE_CODE;
                    } else if (status.indexOf("CT7") > -1 || status.indexOf("MP7") > -1) {
                        resultCode = "70";
                    } else if (status.indexOf("TMS9") > -1 || status.indexOf("TMS4") > -1) {
                        resultCode = "99";
                    }
                }
                if (resultCode == null) {
                    resultCode = "99";
                }
            } else {
                resultCode = "99";
            }
        }
        catch (Exception e) {
            log.error("Error TMS CODE : defaultDomainApplyStatus : {} / status: {}, error:{}", new Object[]{defaultDomainApplyStatus, status, e});
        }
        return resultCode;
    }

    public void deleteFile(String tlistKey, boolean isDel) {
        this.wrapperRedisTemplate.del(tlistKey);
        if (isDel) {
            String deletePath = null;
            String[] tlistParams = tlistKey.split(":");
            String pinfoKey = null;
            Map targetSchdValue = null;
            pinfoKey = "PINFO".concat(":").concat(tlistParams[1]);
            try {
                targetSchdValue = this.wrapperRedisTemplate.hgetAllString(pinfoKey);
            }
            catch (Exception e) {
                log.error("[Delete] Pinfo data import error from redis : {}", (Throwable)e);
            }
            String workday = null;
            if (!StringUtils.isEmpty((Object)targetSchdValue) && targetSchdValue.containsKey("WORKDAY")) {
                workday = (String)targetSchdValue.get("WORKDAY");
                deletePath = this.contentPath.concat(workday).concat("/").concat(tlistParams[1]).concat("/").concat(tlistParams[2]);
                deletePath = this.watcherFileUrl.concat(deletePath);
                log.info("[Delete] Watcher call delete Files : {}", (Object)deletePath);
                this.restTemplate.delete(deletePath, new Object[0]);
            } else {
                log.error("[Delete] There is no workday value in this PINFO [{}].", (Object)pinfoKey);
            }
        }
    }
}

