/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.monitor.log.EventType;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.manager.monitor.log.FileEventer;
import com.humuson.tms.manager.monitor.log.FinishFileNextJob;
import com.humuson.tms.manager.monitor.log.MoveFileController;
import com.humuson.tms.manager.monitor.log.RealTimeDirectoryWatchDog;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.dir.watchdog", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class TmsDirectoryWatchdogScheduler {
    private static final Logger log = LoggerFactory.getLogger(TmsDirectoryWatchdogScheduler.class);
    public static final String ING = ".ing";
    @Value(value="${tms.manager.monitor.dir}")
    protected String[] directorys;
    @Value(value="${tms.manager.monitor.tracking.enable:false}")
    private boolean isTrackingEnable;
    @Autowired
    RealTimeDirectoryWatchDog realTimeDirectoryWatchDog;
    @Autowired(required=false)
    List<FileEventListener> fileEventListeners;
    @Autowired
    FinishFileNextJob<File, Boolean> moveFileController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=600000L)
    public void ifExistEventFileThenRegistToFileListener() {
        for (String directory : this.directorys) {
            this.realTimeDirectoryWatchDog.lock.lock();
            try {
                this.registFileListener(directory);
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4131.makeLogMsg(this), new Object[]{directory, e.getMessage(), e});
            }
            finally {
                this.realTimeDirectoryWatchDog.lock.unlock();
            }
        }
    }

    private void registFileListener(String directory) {
        Object[] files;
        FileEventListener fileEventListener = this.getFileEventListener(directory);
        if (fileEventListener == null) {
            log.warn("MN1520| not found registed directory FileEventListener. so skip.. directory[{}]", (Object)directory);
            return;
        }
        File directoryFile = new File(directory);
        if (!directoryFile.exists()) {
            directoryFile.mkdirs();
        }
        if (ObjectUtils.isEmpty((Object[])(files = directoryFile.listFiles((FileFilter)FileFileFilter.FILE)))) {
            return;
        }
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (Object file : files) {
            if (!fileEventListener.isExistListen()) continue;
            this.notifyFileEventListener(fileEventListener, (File)file, EventType.EXIST);
        }
    }

    protected void notifyFileEventListener(FileEventListener fileEventListener, File file, EventType type) {
        try {
            if (this.isFinishFileJob(fileEventListener, file)) {
                return;
            }
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4133.makeLogMsg(this), new Object[]{file.getName(), e.getMessage(), e});
            return;
        }
        if (this.isWaitingFileForWork(fileEventListener, file) || this.isBackupDirectoryExist(fileEventListener, file)) {
            return;
        }
        FileEventer event = new FileEventer();
        event.setEventType(type);
        event.setFileName(file.getName());
        try {
            fileEventListener.listenerQueue().add(event);
            log.info("regist FileEventer[{}] to file listener queue", (Object)event);
        }
        catch (IllegalStateException e) {
            log.error(MNSystemErrorCode.ERR_4134.makeLogMsg(this), new Object[]{event, e.getMessage(), e});
        }
        catch (ClassCastException e1) {
            log.error(MNSystemErrorCode.ERR_4135.makeLogMsg(this), new Object[]{event, e1.getMessage(), e1});
        }
        catch (NullPointerException e2) {
            log.error(MNSystemErrorCode.ERR_4136.makeLogMsg(this), new Object[]{event, e2.getMessage(), e2});
        }
        catch (IllegalArgumentException e3) {
            log.error(MNSystemErrorCode.ERR_4137.makeLogMsg(this), new Object[]{event, e3.getMessage(), e3});
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4138.makeLogMsg(this), new Object[]{event, e.getMessage(), e});
        }
    }

    private boolean isFinishFileJob(FileEventListener fileEventListener, File file) throws Exception {
        File backupFile = new File(fileEventListener.backupDirectory(), file.getName());
        if (backupFile.exists() && this.moveFileController instanceof MoveFileController) {
            String destDirectory = ((MoveFileController)this.moveFileController).getDestDirectory();
            File destFile = new File(destDirectory + file.getName());
            return this.moveFileController.nextJob(file.getAbsoluteFile(), destFile);
        }
        return false;
    }

    private boolean isWaitingFileForWork(FileEventListener fileEventListener, File file) {
        if (ObjectUtils.isEmpty((Object)file.getName())) {
            return false;
        }
        FileEventer event = new FileEventer();
        event.setFileName(file.getName());
        return fileEventListener.listenerQueue().contains(event);
    }

    private boolean isBackupDirectoryExist(FileEventListener fileEventListener, File file) {
        return new File(fileEventListener.backupDirectory(), file.getName()).exists() || new File(fileEventListener.backupDirectory(), file.getName() + ING).exists();
    }

    private FileEventListener getFileEventListener(String directory) {
        for (FileEventListener fileEventListener : this.fileEventListeners) {
            if (!fileEventListener.workDirectory().equals(directory)) continue;
            return fileEventListener;
        }
        return null;
    }

    private Collection<File> readingDirecotry(File directory, String[] fileExtensions, boolean b) {
        return FileUtils.listFiles((File)directory, (String[])fileExtensions, (boolean)false);
    }
}

