/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.manager.monitor.log.FileEventer;
import com.humuson.tms.manager.monitor.log.FileTailerListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RealTimeFileEventHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RealTimeFileEventHandler.class);
    protected String fixedFileNamePattern;
    protected FileEventListener eventListener;
    @Autowired(required=false)
    List<FileEventListener> fileEventListeners;
    private boolean running = true;
    protected Queue<FileEventer> tempQueue = new LinkedList<FileEventer>();

    @PostConstruct
    public void eventNotify() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (this.running) {
            for (FileEventListener fileEventListener : this.fileEventListeners) {
                String fileName = null;
                try {
                    BlockingQueue<FileEventer> queue = fileEventListener.listenerQueue();
                    FileEventer eventer = queue.take();
                    if (eventer == null) continue;
                    FileTailerListener fileTailerListener = fileEventListener.fileTailerListener();
                    fileName = eventer.getFileName();
                    if (fileTailerListener.finishedFilter(fileEventListener, eventer)) continue;
                    fileTailerListener.getFileQueue().add(eventer);
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    log.error(MNSystemErrorCode.ERR_4130.makeLogMsg(this), new Object[]{fileName, e.getMessage(), e});
                }
            }
        }
    }
}

