/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.monitor.log.DirectoryWatchDog;
import com.humuson.tms.manager.monitor.log.EventType;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.util.FileUtil;
import com.humuson.tms.util.seq.TimeUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RealTimeDirectoryWatchDog
extends DirectoryWatchDog
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RealTimeDirectoryWatchDog.class);
    private WatchService watcher = null;
    private int initialCount;
    private boolean running = true;
    @Value(value="${tms.manager.monitor.tracking.enable:false}")
    private boolean isTrackingEnable;

    public void stop() {
        this.running = false;
    }

    @PostConstruct
    public void watchingDirectory() throws IOException {
        if (!this.isTrackingEnable) {
            return;
        }
        this.readingDirectorys();
        this.initial(this.directorys);
        new Thread(this).start();
    }

    public synchronized void addDirectory(String pathDir) {
        this.directorys[this.directorys.length] = pathDir;
        try {
            this.lock.lock();
            Paths.get(pathDir, new String[0]).register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4117.makeLogMsg(this), new Object[]{pathDir, e.getMessage(), e});
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
    }

    public void initial(String[] directorys) throws IOException {
        if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4118.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
                this.watcher = null;
            }
        }
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            for (String directory : directorys) {
                if (directory.trim().isEmpty()) continue;
                Paths.get(directory, new String[0]).register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                log.info("real time monitor directory = {} ", (Object)directory);
            }
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4119.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
            try {
                if (this.initialCount++ > 5) {
                    log.error(MNSystemErrorCode.ERR_4120.makeLogMsg(this));
                } else {
                    this.initial(directorys);
                }
            }
            catch (Exception e2) {
                log.error(MNSystemErrorCode.ERR_4121.makeLogMsg(this));
            }
        }
    }

    private Path getModifiedFilePath(WatchKey key) throws InterruptedException {
        return (Path)key.watchable();
    }

    private void registFileListener(String directory, String fileName, WatchEvent.Kind<?> kind) {
        String fullPathFileName = FileUtil.lastSeparator((String)directory) + fileName;
        try {
            for (FileEventListener fileEventListener : this.fileEventListeners) {
                if (!this.detectDirectory(fileEventListener.workDirectory(), directory) || !fileEventListener.detectFilePattern(fileName)) continue;
                EventType type = null;
                if (this.detectCreateEvent(fileEventListener, kind)) {
                    type = EventType.CREATE;
                } else if (this.detectDeleteEvent(fileEventListener, kind)) {
                    type = EventType.DELETE;
                } else {
                    log.warn("MN1501| this file[{}] event is not include create|delete type", (Object)fullPathFileName);
                    return;
                }
                this.notifyFileEventListener(fileEventListener, new File(fullPathFileName), type);
            }
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4122.makeLogMsg(this), new Object[]{fullPathFileName, e.getMessage(), e});
        }
    }

    private boolean detectDirectory(String workDirectory, String directory) {
        return Paths.get(workDirectory, new String[0]).compareTo(Paths.get(directory, new String[0])) == 0;
    }

    private boolean detectCreateEvent(FileEventListener fileEventListener, WatchEvent.Kind<?> kind) {
        return kind == StandardWatchEventKinds.ENTRY_CREATE && fileEventListener.isCreateListen();
    }

    private boolean detectDeleteEvent(FileEventListener fileEventListener, WatchEvent.Kind<?> kind) {
        return kind == StandardWatchEventKinds.ENTRY_DELETE && fileEventListener.isDeleteListen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void directoryWatching() {
        int errorCount = 0;
        block14: while (this.running) {
            WatchKey key = null;
            try {
                key = this.watcher.take();
                if (key == null) {
                    log.info("watcher is null");
                    Thread.sleep(100L);
                    continue;
                }
                try {
                    Path pathFilePath = this.getModifiedFilePath(key);
                    Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block14;
                        WatchEvent<?> event = iterator.next();
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent<?> ev = event;
                        Path filePath = (Path)ev.context();
                        String directory = pathFilePath.toString();
                        String fileName = filePath.getFileName().toString();
                        String fullPathFileName = FileUtil.lastSeparator((String)directory) + filePath;
                        if (log.isDebugEnabled()) {
                            log.debug("monitor directory event={} file name[{}]", (Object)kind.name(), (Object)fullPathFileName);
                        }
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        this.registFileListener(directory, fileName, kind);
                    }
                }
                catch (InterruptedException e) {
                    log.error(MNSystemErrorCode.ERR_4125.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error(MNSystemErrorCode.ERR_4126.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
                }
            }
            catch (ClosedWatchServiceException ce) {
                log.error(MNSystemErrorCode.ERR_4123.makeLogMsg(this), (Object)ce.getMessage(), (Object)ce);
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4124.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
                if (++errorCount > 5) {
                    return;
                }
                TimeUtil.mileSecondsLockSleep((int)200);
            }
            finally {
                if (key == null || key.reset()) continue;
                log.warn("don't watching key reset ");
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.directoryWatching();
                continue;
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4128.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
                continue;
            }
            finally {
                try {
                    Thread.sleep(100L);
                    this.initial(this.directorys);
                }
                catch (Exception e2) {
                    log.error(MNSystemErrorCode.ERR_4129.makeLogMsg(this), (Object)e2.getMessage(), (Object)e2);
                }
                continue;
            }
            break;
        }
    }
}

