/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.manager.monitor.log.FinishFileNextJob;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.ObjectUtils;

public class MoveFileController
implements FinishFileNextJob<File, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(MoveFileController.class);
    protected Logger logger = LoggerFactory.getLogger((String)"trackingTraceLog");
    private static final String ER = ".er";
    @Value(value="${tms.manager.monitor.finish.move}")
    private String DEST_DIR;
    @Value(value="${tms.manager.monitor.dir}")
    protected String[] directorys;
    @Autowired(required=false)
    List<FileEventListener> fileEventListeners;

    public String getDestDirectory() {
        return this.DEST_DIR;
    }

    @Scheduled(fixedDelay=600000L)
    public void ifExistFinishFileThenMove() {
        for (String directory : this.directorys) {
            try {
                this.registFileListener(directory);
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4115.makeLogMsg(this), new Object[]{directory, e.getMessage(), e});
            }
        }
    }

    private void registFileListener(String directory) {
        Object[] files;
        FileEventListener fileEventListener = this.getFileEventListener(directory);
        if (fileEventListener == null) {
            log.warn("MN1520| not found registed directory FileEventListener. so skip.. directory[{}]", (Object)directory);
            return;
        }
        File directoryFile = new File(directory);
        if (!directoryFile.exists()) {
            directoryFile.mkdirs();
        }
        if (ObjectUtils.isEmpty((Object[])(files = directoryFile.listFiles((FileFilter)FileFileFilter.FILE)))) {
            return;
        }
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (Object file : files) {
            if (!fileEventListener.isExistListen()) continue;
            try {
                this.isFinishFileJob(fileEventListener, (File)file);
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4116.makeLogMsg(this), new Object[]{((File)file).getName(), e.getMessage(), e});
                return;
            }
        }
    }

    private boolean isFinishFileJob(FileEventListener fileEventListener, File file) throws Exception {
        File backupFile = new File(fileEventListener.backupDirectory(), file.getName());
        if (backupFile.exists()) {
            File destFile = new File(this.DEST_DIR + file.getName());
            return this.nextJob(file.getAbsoluteFile(), destFile);
        }
        return false;
    }

    private FileEventListener getFileEventListener(String directory) {
        for (FileEventListener fileEventListener : this.fileEventListeners) {
            if (!fileEventListener.workDirectory().equals(directory)) continue;
            return fileEventListener;
        }
        return null;
    }

    @Override
    public Boolean nextJob(File orgFile, File destFile) {
        try {
            if (destFile.exists()) {
                if (orgFile.length() != destFile.length()) {
                    log.warn("The source[{}] and destination[{}] files are different.so source file move it with an extension[.er].", (Object)orgFile.getName(), (Object)destFile.getName());
                    File erFile = new File(destFile.getAbsolutePath() + ER);
                    if (erFile.exists()) {
                        log.warn("this ER file[{}] is exist. so skip..", (Object)erFile.getName());
                        return true;
                    }
                    Files.move(orgFile.toPath(), orgFile.toPath().resolveSibling(erFile.getAbsolutePath()), new CopyOption[0]);
                }
                return true;
            }
            Files.move(orgFile.toPath(), orgFile.toPath().resolveSibling(destFile.getAbsolutePath()), new CopyOption[0]);
            return true;
        }
        catch (Exception e) {
            this.logger.error("MN1513| file move error. so dest file[{}] delete. org file[{}], error:{}", new Object[]{destFile.getAbsolutePath(), orgFile.getAbsolutePath(), e});
            try {
                new FileWriter(destFile).close();
                FileUtils.forceDelete((File)destFile);
            }
            catch (IOException e2) {
                this.logger.error("MN1580| dest file[{}] creating error, error:{}", (Object)destFile, (Object)e2);
            }
            return false;
        }
    }

    public static void main(String[] args) {
        File o = new File("E:/test/euckr.txt");
        File d = new File("E:/test/temp/euckr.txt");
        new MoveFileController().nextJob(o, d);
    }
}

