/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.manager.monitor.log.LogFileTailerListener;
import com.humuson.tms.manager.repository.dao.RealTimeFileUploadDao;
import com.humuson.tms.manager.repository.model.TmsErrorInfo;
import com.humuson.tms.util.chunk.ChunkCycleCountExecutor;
import com.humuson.tms.util.chunk.ChunkExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MNLogFileTailerListener
extends LogFileTailerListener {
    private static final Logger log = LoggerFactory.getLogger(MNLogFileTailerListener.class);
    @Autowired
    @Qualifier(value="MNLogFileEventListener")
    FileEventListener mnLogFileEventListener;
    @Autowired
    RealTimeFileUploadDao realTimeFileUploadDao;
    @Autowired
    TmsBatchSqlExecutor<TmsErrorInfo> sqlExecutor;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    ChunkExecutor chunkExecutor = new ChunkExecutor(){

        public void execute() {
            MNLogFileTailerListener.this.lock.readLock().lock();
            try {
                if (MNLogFileTailerListener.this.tmsErrorInfos.isEmpty()) {
                    return;
                }
                MNLogFileTailerListener.this.sqlExecutor.batchUpdate("insertErrorInfo", MNLogFileTailerListener.this.tmsErrorInfos);
                System.out.println("batch update commit size=" + MNLogFileTailerListener.this.tmsErrorInfos.size());
            }
            catch (Exception e) {
                log.error(MNSystemErrorCode.ERR_4114.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
            }
            finally {
                MNLogFileTailerListener.this.tmsErrorInfos.clear();
                MNLogFileTailerListener.this.lock.readLock().unlock();
            }
        }
    };
    List<TmsErrorInfo> tmsErrorInfos = new ArrayList<TmsErrorInfo>();

    @PostConstruct
    public void initinal() {
        log.info("{} listening queue start", (Object)this.getClass().getName());
        this.p = Pattern.compile(this.fileLineParsePattern());
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
        new ChunkCycleCountExecutor(this.chunkExecutor, 300, 500).start();
    }

    @Override
    protected String fileLineParsePattern() {
        return this.defaultParsePattern;
    }

    @Override
    FileEventListener fileEventListener() {
        return this.mnLogFileEventListener;
    }

    @Override
    boolean isReadApplyPattern(String line) {
        return true;
    }

    @Override
    void workingJob(String fileName, String line) {
        TmsErrorInfo error = this.parsingErrorInfo(line);
        try {
            this.singleUpdate(error);
            Thread.sleep(500L);
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
    }

    private void singleUpdate(TmsErrorInfo error) {
        try {
            if (this.realTimeFileUploadDao.insertErrorInfo(error) != 1) {
                log.warn("failed upload DS file[{}] skip..", (Object)error);
            }
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
    }

    private TmsErrorInfo parsingErrorInfo(String line) {
        TmsErrorTokenHandler tmsErrorToken = new TmsErrorTokenHandler();
        TmsErrorInfo errorInfo = new TmsErrorInfo();
        GenericTokenParser parser = new GenericTokenParser("[", "]", (TokenHandler)tmsErrorToken);
        parser.parse(line);
        List<String> logContents = tmsErrorToken.logContent();
        int codePosition = line.indexOf("|");
        if (codePosition <= 0) {
            errorInfo.setErrorCode("DS1000");
            errorInfo.setDescription(line);
        } else {
            errorInfo.setErrorCode(line.substring(codePosition - 6, codePosition));
            errorInfo.setDescription(line.substring(codePosition + 1));
        }
        errorInfo.setDemon("DS");
        errorInfo.setDemonId(2);
        return errorInfo;
    }

    public static void main(String[] args) {
        MNLogFileTailerListener ds = new MNLogFileTailerListener();
        TmsErrorInfo errorInfo = ds.parsingErrorInfo("[2018-04-23 18:06:36,870] [main] [ERROR] [SimplePathWatchDog:71] : MN1001| 4-10");
        System.out.println(errorInfo);
    }

    public static class TmsErrorTokenHandler
    implements TokenHandler {
        private TmsErrorInfo error = new TmsErrorInfo();
        private List<String> logContents = new ArrayList<String>();
        private int count = 0;

        public String handleToken(String content) {
            this.logContents.add(content);
            return content;
        }

        public List<String> logContent() {
            return this.logContents;
        }
    }
}

