/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.monitor.log.EventType;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.manager.monitor.log.FileEventer;
import com.humuson.tms.manager.monitor.log.PreviewFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DirectoryWatchDog {
    private static final Logger log = LoggerFactory.getLogger(DirectoryWatchDog.class);
    @Value(value="${tms.manager.monitor.dir}")
    protected String[] directorys;
    @Value(value="${tms.manager.monitor.tracking.enable:false}")
    private boolean isTrackingEnable;
    protected final ReentrantLock lock = new ReentrantLock();
    @Autowired(required=false)
    List<FileEventListener> fileEventListeners;

    protected void readingDirectorys() {
        this.readingDirectorys(this.directorys);
    }

    private void readingDirectorys(String[] directorys2) {
        for (String directory : this.directorys) {
            this.readingDirecotry(directory);
        }
    }

    private void readingDirecotry(String directory) {
        this.registFileListener(directory);
    }

    private void registFileListener(String directory) {
        FileEventListener fileEventListener = this.getFileEventListener(directory);
        if (fileEventListener == null) {
            log.warn("MN1520| not found registed directory FileEventListener. so skip.. directory[{}]", (Object)directory);
            return;
        }
        File directoryFile = new File(directory);
        if (!directoryFile.exists()) {
            directoryFile.mkdirs();
        }
        try {
            this.setAsExecutable(directory);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collection<File> files = this.readingDirecotry(directoryFile, fileEventListener.extensions(), false);
        for (File file : files) {
            if (!fileEventListener.isExistListen()) continue;
            this.notifyFileEventListener(fileEventListener, file, EventType.EXIST);
        }
    }

    protected void notifyFileEventListener(FileEventListener fileEventListener, File file, EventType type) {
        if (PreviewFile.INSTANCE.isSamePreviewFile(fileEventListener.workDirectory(), file.getName())) {
            log.warn("this file[{}] is same preview input file", (Object)file.getName());
            return;
        }
        FileEventer event = new FileEventer();
        event.setEventType(type);
        event.setFileName(file.getName());
        try {
            if (log.isDebugEnabled()) {
                log.debug("regist FileEventer[{}] to file listener queue", (Object)event);
            }
            fileEventListener.listenerQueue().add(event);
        }
        catch (IllegalStateException e) {
            log.error(MNSystemErrorCode.ERR_4096.makeLogMsg(this), new Object[]{event, e.getMessage(), e});
        }
        catch (ClassCastException e1) {
            log.error(MNSystemErrorCode.ERR_4097.makeLogMsg(this), new Object[]{event, e1.getMessage(), e1});
        }
        catch (NullPointerException e2) {
            log.error(MNSystemErrorCode.ERR_4098.makeLogMsg(this), new Object[]{event, e2.getMessage(), e2});
        }
        catch (IllegalArgumentException e3) {
            log.error(MNSystemErrorCode.ERR_4099.makeLogMsg(this), new Object[]{event, e3.getMessage(), e3});
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4100.makeLogMsg(this), new Object[]{event, e.getMessage(), e});
        }
    }

    private Collection<File> readingDirecotry(File directory, String[] fileExtensions, boolean b) {
        return FileUtils.listFiles((File)directory, (String[])fileExtensions, (boolean)false);
    }

    private FileEventListener getFileEventListener(String directory) {
        for (FileEventListener fileEventListener : this.fileEventListeners) {
            if (!fileEventListener.workDirectory().equals(directory)) continue;
            return fileEventListener;
        }
        return null;
    }

    public void setAsExecutable(String filePath) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        Files.setPosixFilePermissions(Paths.get(filePath, new String[0]), perms);
    }
}

