/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.monitor.log.FinishFileController;
import java.io.File;
import java.io.FileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ControllerBackupFile {
    private static final Logger log = LoggerFactory.getLogger(ControllerBackupFile.class);
    protected File backupFile;
    private FileWriter writer = null;
    public boolean append = false;
    @Autowired
    protected FinishFileController changeFileNameController;

    public void init(File file, boolean append) {
        this.append = append;
        this.backupFile = file;
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = new FileWriter(file, append);
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4093.makeLogMsg(this), new Object[]{file.getName(), e.getMessage(), e});
        }
    }

    public void writePosition(long position) {
        if (this.ifAppendFirstLineSkip()) {
            return;
        }
        try {
            this.writer.write("\n");
            this.writer.write("" + position);
            this.writer.flush();
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4094.makeLogMsg(this), new Object[]{this.backupFile.getName(), position, e.getMessage(), e});
            this.init(this.backupFile, true);
        }
    }

    private boolean ifAppendFirstLineSkip() {
        if (this.append) {
            this.append = false;
            return true;
        }
        return false;
    }

    public void finish() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            Thread.sleep(500L);
        }
        catch (Exception e2) {
            log.error(MNSystemErrorCode.ERR_4095.makeLogMsg(this), (Object)e2.getMessage(), (Object)e2);
        }
        this.changeFileNameController.finish(this.backupFile, this.finishChangeFile());
        log.info("backup file change to {}", (Object)this.finishChangeFile());
    }

    public abstract File finishChangeFile();
}

