/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.monitor.log.FinishFileController;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChangeFileNameController
implements FinishFileController {
    private static final Logger log = LoggerFactory.getLogger(ChangeFileNameController.class);

    @Override
    public void finish(File orgFile, File destFile) {
        try {
            Files.move(orgFile.toPath(), orgFile.toPath().resolveSibling(destFile.getAbsolutePath()), new CopyOption[0]);
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4090.makeLogMsg(this), new Object[]{destFile.getAbsolutePath(), orgFile.getAbsolutePath(), e.getMessage(), e});
            try {
                new FileWriter(destFile).close();
                FileUtils.forceDelete((File)orgFile);
            }
            catch (IOException e2) {
                log.error(MNSystemErrorCode.ERR_4091.makeLogMsg(this), new Object[]{destFile, e2.getMessage(), e2});
            }
        }
    }
}

