/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.stat;

import com.humuson.tms.manager.custom.stat.StatDataVO;
import com.humuson.tms.manager.custom.stat.StatProcess;
import com.humuson.tms.manager.custom.stat.dao.CustomStatDao;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomStatProcess
extends StatProcess
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CustomStatProcess.class);
    CustomStatDao statDao;

    public CustomStatProcess(StatDataVO statDataVo, CustomStatDao statDao) {
        this.setChannelType(statDataVo.getChannelType());
        this.setSchdId(statDataVo.getSchdId());
        this.setSendId(statDataVo.getSendId());
        this.setProcType(statDataVo.getProcType());
        this.setStatType(statDataVo.getStatType());
        this.setDateType(statDataVo.getDateType());
        this.setOpenWorkday(statDataVo.getOpenWorkday());
        this.setOpenHour(statDataVo.getOpenHour());
        this.setClickWorkday(statDataVo.getClickWorkday());
        this.setClickHour(statDataVo.getClickHour());
        this.statDao = statDao;
    }

    @Override
    public List<Map<String, Object>> getStatData() {
        List<Map<String, Object>> targetData = null;
        String query = null;
        try {
            if ("H".equalsIgnoreCase(this.dateValue)) {
                query = "resultHourStat";
                targetData = this.statDao.resultHourStat(this.schdId, this.sendId, this.channelType, this.eventType);
            } else if (this.dateValue.equals("U")) {
                query = "resultUniqStat";
                targetData = this.statDao.resultUniqStat(this.schdId, this.sendId, this.channelType, this.eventType);
            }
        }
        catch (Exception e) {
            log.error("Error-query:{}, schdId:{}, sendId:{}, channelType:{}, eventType:{}, e:{}", new Object[]{query, this.schdId, this.sendId, this.channelType, this.eventType, e});
        }
        if (log.isDebugEnabled()) {
            log.debug("dateValue : {} schdId : {}, sendId : {} channelType : {}, eventType : {}, targetData  : {}", new Object[]{this.dateValue, this.schdId, this.sendId, this.channelType, this.eventType, targetData});
        }
        return targetData;
    }

    @Override
    public Map<String, Object> convertStatData(Map<String, Object> statData) {
        statData.put("SEND_ID", this.sendId);
        statData.put("SCHD_ID", this.schdId);
        statData.put("CHANNEL_TYPE", this.channelType);
        statData.put("OPEN_WORKDAY", this.openWorkday);
        statData.put("OPEN_HOUR", this.openHour);
        statData.put("CLICK_WORKDAY", this.clickWorkday);
        statData.put("CLICK_HOUR", this.clickHour);
        return statData;
    }

    @Override
    public int updateTargetTable(Map<String, Object> convertData) {
        try {
            if (this.dateValue.equals("U")) {
                this.statDao.updateUniqOpenClickStat(convertData);
            } else if (this.eventType.equals("O")) {
                if (convertData.get("SEND_ID") != null && convertData.containsKey("SEND_ID") && convertData.get("SCHD_ID") != null && convertData.containsKey("SCHD_ID") && convertData.get("CHANNEL_TYPE") != null && convertData.containsKey("CHANNEL_TYPE") && convertData.get("OPEN_WORKDAY") != null && convertData.containsKey("OPEN_WORKDAY") && convertData.get("OPEN_HOUR") != null && convertData.containsKey("OPEN_HOUR")) {
                    this.statDao.updateOpenStat(convertData);
                }
            } else if (this.eventType.equals("C") && convertData.get("SEND_ID") != null && convertData.containsKey("SEND_ID") && convertData.get("SCHD_ID") != null && convertData.containsKey("SCHD_ID") && convertData.get("CHANNEL_TYPE") != null && convertData.containsKey("CHANNEL_TYPE") && convertData.get("CLICK_WORKDAY") != null && convertData.containsKey("CLICK_WORKDAY") && convertData.get("CLICK_HOUR") != null && convertData.containsKey("CLICK_HOUR")) {
                this.statDao.updateClickStat(convertData);
            }
        }
        catch (Exception e) {
            log.error("ERROR : {}, DATA : {}", (Object)e, (Object)convertData.toString());
        }
        return 0;
    }

    @Override
    public void run() {
        String[] statTypes = this.statType.split("\\".concat("|"));
        String[] dateTypes = this.dateType.split("\\".concat("|"));
        String[] stringArray = statTypes;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String statValue;
            this.eventType = statValue = stringArray[i];
            String[] stringArray2 = dateTypes;
            int n2 = stringArray2.length;
            for (int j = 0; j < n2; ++j) {
                String dateValue;
                this.dateValue = dateValue = stringArray2[j];
                this.work();
            }
        }
    }
}

