/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.result;

import com.humuson.tms.manager.custom.repository.model.ResultSmsModel;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

@Component
public class ResultInfobankSms {
    private static final Logger log = LoggerFactory.getLogger(ResultInfobankSms.class);
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    @Qualifier(value="resultInfobankSmsReader")
    public MyBatisPagingItemReader<ResultSmsModel> resultInfobankSmsReader;
    @Autowired
    @Qualifier(value="resultInfobankSmsWriter")
    public ItemWriter<ResultSmsModel> resultInfobankSmsWriter;
    @Value(value="${tms.manager.proc-result-sm.fixed-table.flag}")
    private String fixedTableFlag;
    @Value(value="${tms.manager.proc-result-sm.fixed-table.name}")
    private String fixedTableName;
    @Value(value="${tms.manager.proc-result-sm.fixed-table.format}")
    private String fixedTableFormat;
    private static final int CHUNK_SIZE = 1000;

    public Step step1() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("resultSmStep").chunk(1000).reader(this.resultInfobankSmsReader).writer(this.resultInfobankSmsWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }

    public List<String> makeTableList() {
        ArrayList<String> tableList = new ArrayList<String>();
        if ("Y".equals(this.fixedTableFlag)) {
            tableList.add(this.fixedTableName);
        } else {
            String day = DateUtil.getFullDate((String)"DD");
            if ("D".equals(this.fixedTableFlag) || "M".equals(this.fixedTableFlag) && "01".equals(day)) {
                tableList.add(this.fixedTableName + DateUtil.getDateCalculationDay((String)this.fixedTableFormat, (int)-1));
            }
            tableList.add(this.fixedTableName + DateUtil.getFullDate((String)this.fixedTableFormat));
        }
        return tableList;
    }
}

