/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.monitor;

import com.humuson.tms.manager.monitor.MonitorDaemon;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class MonitorCustomDaemon
implements MonitorDaemon {
    private static final Logger log = LoggerFactory.getLogger(MonitorCustomDaemon.class);
    @Value(value="${tms.manager.monitor.daemon-live.timeout-err}")
    public int timeoutErr;
    protected Logger liveTraceLogger = LoggerFactory.getLogger((String)"liveTraceLog");

    @Override
    public void processDaemonWork(String daemonType, String field, String value) {
        try {
            String[] kStrs = field.split(":");
            String[] vStrs = value.split(":");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("DAEMON_TYPE", daemonType);
            paramMap.put("DAEMON_INDEX", kStrs[0]);
            paramMap.put("LAST_WORK_DATE", kStrs[1] + vStrs[0]);
            paramMap.put("MAX_MEMORY", Long.parseLong(vStrs[1]));
            paramMap.put("USED_MEMORY", Long.parseLong(vStrs[2]));
            if (DateUtil.checkTimeoutSecondToNow((int)this.timeoutErr, (String)(kStrs[1] + vStrs[0]))) {
                this.liveTraceLogger.error("[DaemonDead] {} {} {} {} {}", new Object[]{daemonType, kStrs[0], kStrs[1] + vStrs[0], vStrs[1], vStrs[2]});
            } else {
                this.liveTraceLogger.info("[DaemonLive] {} {} {} {} {}", new Object[]{daemonType, kStrs[0], kStrs[1] + vStrs[0], vStrs[1], vStrs[2]});
            }
        }
        catch (Exception e) {
            log.error("[processDaemonWork] daemon data error. {}", (Throwable)e);
        }
    }
}

