/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.writer;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.config.Constants;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.custom.repository.dao.ResultBiztalkDao;
import com.humuson.tms.manager.custom.repository.model.ResultBiztalkModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="resultImcBiztalkWriter")
@StepScope
public class ResultImcBiztalkWriter
implements ItemWriter<ResultBiztalkModel> {
    private static final Logger log = LoggerFactory.getLogger(ResultImcBiztalkWriter.class);
    @Autowired
    ResultBiztalkDao resultBizDao;
    @Autowired
    TmsBatchSqlExecutor<ResultBiztalkModel> sqlExecutorBiz;
    @Autowired
    @Qualifier(value="bizError")
    Map<String, String> bizErrorCodes;
    @Value(value="#{jobParameters['minId'] ?: 0L}")
    private long minId;
    @Value(value="#{jobParameters['maxId'] ?: 0L}")
    private long maxId;
    @Value(value="#{jobParameters['tableName'] ?: 'IMC_AT_BIZ_MSG_LOG'}")
    private String tableName;
    @Value(value="#{jobParameters['time'] ?: 0L}")
    private long workTime;

    @BeforeStep
    public void before() {
    }

    @Transactional
    public void write(List<? extends ResultBiztalkModel> items) {
        ArrayList<ResultBiztalkModel> targetResultData = new ArrayList<ResultBiztalkModel>();
        for (ResultBiztalkModel resultBiztalkModel : items) {
            String[] targetMember = resultBiztalkModel.getTargetMember().split("\\".concat("|"));
            String memberId = targetMember[0];
            String memberIdSeq = targetMember[1];
            resultBiztalkModel.setMemberId(memberId);
            resultBiztalkModel.setMemberIdSeq(memberIdSeq);
            targetResultData.add(resultBiztalkModel);
            if (!StringUtils.isEmpty((CharSequence)resultBiztalkModel.getResendEventCode())) {
                resultBiztalkModel.setEventCode(resultBiztalkModel.getResendEventCode());
                resultBiztalkModel.setEventTime(resultBiztalkModel.getResendeventTime());
                resultBiztalkModel.setEventType(Constants.EventType.T.toString());
                targetResultData.add(resultBiztalkModel);
            }
            String[] infoKeys = resultBiztalkModel.getInfoKeys().split("\\".concat("|"));
            String schdId = infoKeys[0];
            String sendId = infoKeys[1];
            resultBiztalkModel.setSchdId(schdId);
            resultBiztalkModel.setSendId(sendId);
            resultBiztalkModel.setEventCode(this.judgeResultCode(resultBiztalkModel.getEventCode()));
        }
        try {
            log.info("[JOB_WRITER] START updateKaResultByKey min {} max {} size {}", new Object[]{this.minId, this.maxId, targetResultData.size()});
            this.sqlExecutorBiz.batchUpdate("com.humuson.tms.manager.custom.repository.dao.ResultBiztalkDao.updateKaResultByKey", targetResultData);
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4072.makeLogMsg(this), new Object[]{this.minId, this.maxId, e.getMessage(), e});
            for (ResultBiztalkModel result : targetResultData) {
                try {
                    this.resultBizDao.updateKaResultByKey(result);
                }
                catch (Exception e1) {
                    log.error(MNSystemErrorCode.ERR_4073.makeLogMsg(this), new Object[]{result.toLogString(), e1.getMessage(), e1});
                }
            }
        }
        try {
            log.info("[JOB_WRITER] START insertSendList min {} max {} size {}", new Object[]{this.minId, this.maxId, targetResultData.size()});
            this.sqlExecutorBiz.batchUpdate("com.humuson.tms.manager.custom.repository.dao.ResultBiztalkDao.insertSendListBiz", targetResultData);
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4074.makeLogMsg(this), new Object[]{this.minId, this.maxId, e.getMessage(), e});
            log.error("print stack trace", (Throwable)e);
            for (ResultBiztalkModel result : targetResultData) {
                try {
                    this.resultBizDao.insertSendListBiz(result);
                }
                catch (Exception e1) {
                    log.error(MNSystemErrorCode.ERR_4075.makeLogMsg(this), new Object[]{result.toLogString(), e1.getMessage(), e1});
                }
            }
        }
        if (targetResultData != null) {
            targetResultData.clear();
        }
    }

    public String judgeResultCode(String eventCode) {
        String resultCode = "99";
        if (eventCode != null && !eventCode.trim().isEmpty() && this.bizErrorCodes.containsKey(eventCode = eventCode.trim())) {
            resultCode = this.bizErrorCodes.get(eventCode);
        }
        return resultCode;
    }
}

