/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.reader;

import com.humuson.tms.manager.custom.repository.model.ResultSmsModel;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="resultInfobankSmsReader")
@StepScope
public class ResultInfobankSmsReader
extends MyBatisPagingItemReader<ResultSmsModel> {
    private static final Logger log = LoggerFactory.getLogger(ResultInfobankSmsReader.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="#{jobParameters['minId'] ?: 0L}")
    private long minId;
    @Value(value="#{jobParameters['maxId'] ?: 0L}")
    private long maxId;
    @Value(value="#{jobParameters['tableName'] ?: 'em_smt_log'}")
    private String tableName;
    @Value(value="${tms.manager.proc-result-sm.reader-page-size}")
    private int pageSize;

    @PostConstruct
    public void init() {
        log.debug("[StatStep1MybatisReader] minId {} maxId {}", (Object)this.minId, (Object)this.maxId);
        this.setSqlSessionFactory(this.sqlSessionFactory);
        this.setQueryId("com.humuson.tms.manager.custom.repository.dao.ResultSmsDao.selectSmResult");
        this.setPageSize(this.pageSize);
    }

    @BeforeStep
    public void before() {
    }

    public ResultSmsModel read() throws Exception, UnexpectedInputException, ParseException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABLE_NAME", this.tableName);
        paramMap.put("MIN_ID", this.minId);
        paramMap.put("MAX_ID", this.maxId);
        this.setParameterValues(paramMap);
        return (ResultSmsModel)super.read();
    }
}

