/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.reader;

import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.repository.model.SendListModel;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent(value="resultReader")
@StepScope
public class ResultBasicReader
extends MyBatisPagingItemReader<SendListModel> {
    private static final Logger log = LoggerFactory.getLogger(ResultBasicReader.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="#{jobParameters['schdId'] ?: 0L}")
    private long schdId;
    @Value(value="${tms.manager.proc-stat.reader-page-size}")
    private int pageSize;

    @PostConstruct
    public void init() {
        log.info("[Stat Step1 Reader] schdId {} pageSize {} ", (Object)this.schdId, (Object)this.pageSize);
        this.setSqlSessionFactory(this.sqlSessionFactory);
        this.setQueryId("com.humuson.tms.manager.repository.dao.StatDao.resultSendList");
        this.setPageSize(this.pageSize);
    }

    @BeforeStep
    public void before() {
    }

    public SendListModel read() throws Exception, UnexpectedInputException, ParseException {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("SCHD_ID", this.schdId);
        this.setParameterValues(paramMap);
        return (SendListModel)super.read();
    }
}

