/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.processor;

import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.custom.stat.dao.StatOpenClickDao;
import com.humuson.tms.manager.custom.stat.openclick.StatOpenClickInfo;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;

@TmsComponent(value="statUniqOpenClickProcessor")
@StepScope
public class StatUniqOpenClickProcessor
implements ItemProcessor<StatOpenClickInfo, StatOpenClickInfo> {
    private static final Logger log = LoggerFactory.getLogger(StatUniqOpenClickProcessor.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatOpenClickInfo process(StatOpenClickInfo uniqStatInfo) throws Exception {
        SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.SIMPLE);
        try {
            StatOpenClickDao statOpenClickDao = (StatOpenClickDao)sqlSession.getMapper(StatOpenClickDao.class);
            StatOpenClickInfo result = statOpenClickDao.resultUniqStat(uniqStatInfo);
            uniqStatInfo.setLAST_SEND_LIST_ID(result.getLAST_SEND_LIST_ID());
            uniqStatInfo.setUNIQ_OPEN_CNT(result.getUNIQ_OPEN_CNT());
            uniqStatInfo.setUNIQ_CLICK_CNT(result.getUNIQ_CLICK_CNT());
            log.info("sendId:{}, schdId:{}, workday:{},  openCnt:{}, clickCnt:{}, uniqOpenCnt:{}, uniqClickCnt:{}, lastSendListId:{}", new Object[]{uniqStatInfo.getSEND_ID(), uniqStatInfo.getSCHD_ID(), uniqStatInfo.getWORKDAY(), uniqStatInfo.getOPEN_CNT(), uniqStatInfo.getCLICK_CNT(), uniqStatInfo.getUNIQ_OPEN_CNT(), uniqStatInfo.getUNIQ_CLICK_CNT(), uniqStatInfo.getLAST_SEND_LIST_ID()});
        }
        catch (Exception e) {
            log.error("data : {}, error : {}", (Object)uniqStatInfo.toString(), (Object)e);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.clearCache();
                sqlSession.close();
            }
        }
        return uniqStatInfo;
    }
}

