/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.processor;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.custom.repository.model.ResultWebModel;
import com.humuson.tms.manager.repository.model.SendListModel;
import com.humuson.tms.manager.util.ManagerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;

@TmsComponent(value="resultSendListProcessor")
@StepScope
public class ResultSendListProcessor
implements ItemProcessor<SendListModel, ResultWebModel> {
    private static final Logger log = LoggerFactory.getLogger(ResultSendListProcessor.class);

    public ResultWebModel process(SendListModel result) throws Exception {
        ResultWebModel rwm = new ResultWebModel();
        if (result.getLogDetail() != null) {
            result.setLogDetail(ManagerUtil.isSplitListByte(result.getLogDetail(), 400));
        }
        if (result.getCodeDetail() != null) {
            result.setCodeDetail(ManagerUtil.isSplitListByte(result.getCodeDetail(), 40));
        }
        rwm.setSendListId(result.getSendListId());
        rwm.setWorkday(result.getWorkday());
        rwm.setChannelType(result.getChannelType());
        rwm.setMemberId(result.getMemberId());
        rwm.setMemberIdSeq(result.getMemberIdSeq());
        rwm.setMemberName(result.getMemberName());
        rwm.setDomain(result.getDomain());
        rwm.setSchdId(result.getSchdId());
        rwm.setSendId(result.getSendId());
        rwm.setSiteId(result.getSiteId());
        rwm.setSendListEvnetType(result.getEventType());
        if (Constants.EventType.S.toString().equals(result.getEventType())) {
            rwm.setSendTime(result.getEventTime());
            rwm.setTmsMEmail(result.getTmsMEmail());
            rwm.setTmsMToken(result.getTmsMToken());
            rwm.setTmsMPhone(result.getTmsMPhone());
            rwm.setSendCode(result.getEventCode());
            rwm.setSendListFatigueYn(result.getFatigueYn());
            rwm.setLogDetail(result.getLogDetail());
            rwm.setSendCodeDetail(result.getCodeDetail());
        } else if (Constants.EventType.O.toString().equals(result.getEventType())) {
            rwm.setOpenCode("Y");
            rwm.setOpenTime(result.getEventTime());
        } else if (Constants.EventType.C.toString().equals(result.getEventType())) {
            rwm.setClickCode("Y");
            rwm.setClickTime(result.getEventTime());
        } else if (Constants.EventType.R.toString().equals(result.getEventType())) {
            rwm.setSendCode(result.getEventCode());
            rwm.setLogDetail(result.getLogDetail());
            rwm.setSendCodeDetail(result.getCodeDetail());
        } else if (Constants.EventType.Q.toString().equals(result.getEventType())) {
            rwm.setSendCode(result.getEventCode());
            rwm.setLogDetail(result.getLogDetail());
            rwm.setSendCodeDetail(result.getCodeDetail());
        } else if (Constants.EventType.T.toString().equals(result.getEventType())) {
            // empty if block
        }
        rwm.setEventInfo1(result.getEventInfo1());
        rwm.setEventInfo2(result.getEventInfo2());
        rwm.setEventInfo3(result.getEventInfo3());
        rwm.setEventInfo4(result.getEventInfo4());
        rwm.setEventInfo5(result.getEventInfo5());
        return rwm;
    }
}

