/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.executor;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.custom.batch.listener.StatUniqOpenClickListener;
import com.humuson.tms.manager.custom.stat.openclick.StatOpenClickInfo;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.xmlbeans.impl.piccolo.util.DuplicateKeyException;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

@Component
@Configuration
@EnableBatchProcessing
@Qualifier(value="StatUniqOpenClickBatchExecutor")
public class StatUniqOpenClickBatchExecutor {
    private static final Logger log = LoggerFactory.getLogger(StatUniqOpenClickBatchExecutor.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    JobLauncher asyncJobLauncher;
    @Autowired
    @Qualifier(value="statUniqOpenClickProcessor")
    public ItemProcessor<StatOpenClickInfo, StatOpenClickInfo> statUniqOpenClickProcessor;
    @Autowired
    @Qualifier(value="statUniqOpenClickWriter")
    public ItemWriter<StatOpenClickInfo> statUniqOpenClickWriter;
    @Autowired
    @Qualifier(value="statUniqOpenClickListener")
    public StatUniqOpenClickListener statUniqOpenClickListener;
    @Value(value="${tms.manager.proc-stat-openclick.batch-chunk:1000}")
    private int pageSize;
    @Value(value="${tms.manager.proc-stat-openclick.using-workday:false}")
    private String workdayUseFlag;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-interval:7}")
    private int trackingInterval;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-start-workday:7}")
    private int betweenStartWorkday;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-end-workday:0}")
    private int betweenEndWorkday;

    public int executor() {
        long time = Long.parseLong(DateUtil.getFullDate((String)"yyyyMMddHH24mm"));
        String jobName = "batchJobUniqOpenClick";
        String stepName = "batchStepUniqOpenClick.." + time;
        String readerName = "batchReaderUniqOpenClick.." + time;
        try {
            JobParameters jobParameters = new JobParametersBuilder().addString("jobName", jobName).addString("stepName", stepName).addString("readerName", readerName).addLong("time", Long.valueOf(time)).toJobParameters();
            Job job = ((SimpleJobBuilder)((JobBuilder)this.jobBuilderFactory.get(jobName).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(this.statUniqOpenClickStep(stepName, readerName)).listener((JobExecutionListener)this.statUniqOpenClickListener)).build();
            this.asyncJobLauncher.run(job, jobParameters);
            return 1;
        }
        catch (BeansException e) {
            log.debug("BeansException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (JobExecutionAlreadyRunningException e) {
            log.debug("JobExecutionAlreadyRunningException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (JobRestartException e) {
            log.debug("JobRestartException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (JobInstanceAlreadyCompleteException e) {
            log.debug("JobInstanceAlreadyCompleteException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (JobParametersInvalidException e) {
            log.debug("JobParametersInvalidException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (DuplicateKeyException e) {
            log.debug("DuplicateKeyException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (IllegalStateException e) {
            log.debug("IllegalStateException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4071.makeLogMsg(this), new Object[]{jobName, e.getMessage(), e});
        }
        return 0;
    }

    public ItemReader<StatOpenClickInfo> getMybatisItemReader(String readerName) throws Exception {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        MyBatisPagingItemReader mybatisPagingItemReader = new MyBatisPagingItemReader();
        mybatisPagingItemReader.setSqlSessionFactory(this.sqlSessionFactory);
        mybatisPagingItemReader.setName(readerName);
        mybatisPagingItemReader.setPageSize(this.pageSize);
        if ("true".equalsIgnoreCase(this.workdayUseFlag)) {
            paramMap.put("SCHD_START_DATE", this.betweenStartWorkday);
            paramMap.put("SCHD_END_DATE", this.betweenEndWorkday);
            mybatisPagingItemReader.setQueryId("com.humuson.tms.manager.custom.stat.dao.StatOpenClickDao.selectStartUniqOpenClickList");
        } else {
            paramMap.put("TRACKING_INTERVAL", this.trackingInterval);
            mybatisPagingItemReader.setQueryId("com.humuson.tms.manager.custom.stat.dao.StatOpenClickDao.selectStartUniqOpenClickListInterval");
        }
        mybatisPagingItemReader.setParameterValues(paramMap);
        mybatisPagingItemReader.afterPropertiesSet();
        return mybatisPagingItemReader;
    }

    public Step statUniqOpenClickStep(String stepName, String readerName) throws Exception {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get(stepName).chunk(this.pageSize).reader(this.getMybatisItemReader(readerName)).processor(this.statUniqOpenClickProcessor).writer(this.statUniqOpenClickWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }
}

