/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.controller;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.config.QueFileLogger;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

public class QueLoggingController {
    private static final Logger log = LoggerFactory.getLogger(QueLoggingController.class);
    @Autowired
    QueFileLogger queFileLogger;
    @Autowired
    @Qualifier(value="resultLogBlockQueue")
    BlockingQueue resultLogBlockQueue;
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Value(value="${tms.manager.file-path.logging.fail-header}")
    private String failHeader;
    @Value(value="${tms.manager.file-path.logging.fail-footer}")
    private String failFooter;
    @Value(value="${tms.manager.file-path.logging.queue-size}")
    private int queueSize;

    @PostConstruct
    public void init() {
        log.info("[QueLoggingController] init {}", (Object)this.resultLogBlockQueue.getClass().getName());
        QueLogger r = new QueLogger(this.resultLogBlockQueue, this.contexter);
        Thread t = new Thread(r);
        t.setName("QueLogger" + System.currentTimeMillis());
        t.start();
    }

    @Component
    class QueLogger
    implements Runnable {
        BlockingQueue resultLogBlockQueue;
        LockContexter contexter;

        QueLogger(BlockingQueue blockingQueue, LockContexter contexter) {
            this.resultLogBlockQueue = blockingQueue;
            this.contexter = contexter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("=================={} START===================={}", (Object)Thread.currentThread().getName(), (Object)this.resultLogBlockQueue.getClass().getName());
            String queueKey = null;
            String queueFiled = null;
            String queueTimes = null;
            String lockKey = "lock.manager.logging.fail.";
            LockController lockController = null;
            while (true) {
                try {
                    HashMap logMap = (HashMap)this.resultLogBlockQueue.take();
                    if (logMap == null || logMap.size() <= 0) continue;
                    String schdId = (String)logMap.get("SCHD_ID");
                    lockController = this.contexter.lock(lockKey + schdId);
                    lockController.lock();
                    if (schdId == null) continue;
                    queueKey = "TLIST".concat(":").concat(schdId).concat(":").concat("QUEUE");
                    queueFiled = ((String)logMap.get("TMS_M_ID")).concat(":").concat((String)logMap.get("UNIQUE_SEQ"));
                    queueTimes = (String)logMap.get("QUEUE_TIMES");
                    if (logMap.get("QUEUE_TIMES") != null) {
                        int queueCnt = Integer.parseInt(queueTimes);
                        if (queueCnt < QueLoggingController.this.queueSize) {
                            ++queueCnt;
                        }
                    } else {
                        logMap.put("QUEUE_TIMES", "1");
                    }
                    QueLoggingController.this.wrapperRedisTemplate.hmset(queueKey, queueFiled, ((Object)logMap).toString());
                    continue;
                }
                catch (Exception e) {
                    log.error("error", (Throwable)e);
                    continue;
                }
                finally {
                    if (lockController == null) continue;
                    lockController.unLock();
                    continue;
                }
                break;
            }
        }
    }
}

