/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.clean;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.manager.clean.Clean;
import com.humuson.tms.manager.repository.dao.CleanDao;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent(value="CleanBasicRedis")
public class CleanBasicRedis
implements Clean {
    private static final Logger log = LoggerFactory.getLogger(CleanBasicRedis.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    CleanDao cleanDao;
    @Autowired
    private LockContexter contexter;
    @Value(value="${tms.manager.clean.redis.holding-day-min}")
    private int cleanRedisHoldingDayMin;
    @Value(value="${tms.manager.clean.redis.holding-day-max}")
    private int cleanRedisHoldingDayMax;
    @Value(value="${tms.manager.proc-stat.stat-limit-day}")
    private int statLimitDay;

    @Override
    public void cleanData() {
        String[] todays = DateUtil.getDivideDateDefault();
        int minWorkday = Integer.parseInt(DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)this.cleanRedisHoldingDayMin));
        int maxWorkday = Integer.parseInt(DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)this.cleanRedisHoldingDayMax));
        List<SchdInfoModel> schdList = this.cleanDao.selectCleanSchd(minWorkday, maxWorkday);
        ArrayList<String> schdIdList = new ArrayList<String>();
        String schdId = null;
        String cycleType = null;
        for (SchdInfoModel schdInfoModel : schdList) {
            schdId = Long.toString(schdInfoModel.getSchdId());
            cycleType = schdInfoModel.getCycleType();
            if ("Y".equals(schdInfoModel.getDelYn())) {
                schdIdList.add(schdId);
                log.info("schd {} is deleted", (Object)schdId);
                continue;
            }
            if (cycleType != null && cycleType.startsWith("O") && this.checkLimitDay(schdInfoModel.getWorkday(), schdInfoModel.getTrackingYn(), schdInfoModel.getTrackingClose())) {
                schdIdList.add(schdId);
                log.info("schd {} is {} and tracking over", (Object)schdId, (Object)cycleType);
                continue;
            }
            if (cycleType == null || !cycleType.startsWith("C") && !cycleType.startsWith("F") || !"N".equals(schdInfoModel.getUseYn())) continue;
            schdIdList.add(schdId);
            log.info("schd {} is {} and use N", (Object)schdId, (Object)cycleType);
        }
        log.info("[cleanData] schdIdList {}", (Object)schdIdList.size());
        for (String string : schdIdList) {
            this.wrapperRedisTemplate.del("PINFO:" + string);
            log.warn("[REDIS_DELETE] {} ", (Object)("PINFO:" + string));
        }
        ArrayList<String> jstatKeyList = new ArrayList<String>();
        jstatKeyList.add("JSTAT:CT");
        jstatKeyList.add("JSTAT:MP");
        jstatKeyList.add("JSTAT:SD");
        jstatKeyList.add("JSTAT:MN");
        jstatKeyList.add("JSTAT:DS");
        for (String jstatKey : jstatKeyList) {
            try {
                Map jstatMap = this.wrapperRedisTemplate.hgetAllString(jstatKey);
                if (jstatMap != null && jstatMap.size() > 0) {
                    for (String field : jstatMap.keySet()) {
                        String[] fields = field.split(":");
                        if (fields[1] == null || Integer.parseInt(fields[1]) > minWorkday) continue;
                        this.wrapperRedisTemplate.hmdel(jstatKey, field);
                        log.warn("[REDIS_DELETE] {} {}", (Object)jstatKey, (Object)field);
                    }
                    continue;
                }
                log.info("[cleanData] jstat map is empty");
            }
            catch (Exception e) {
                log.error("print stack trace", (Throwable)e);
            }
        }
        List list = this.wrapperRedisTemplate.scan("MFATI", 100, 1000);
        log.info("mfatiKeyList size {}", (Object)list.size());
        int yesterday = Integer.parseInt(todays[0]) - 1;
        for (String mfatiKey : list) {
            String[] mfatiKeys = mfatiKey.split(":");
            if (mfatiKeys[1] == null || Integer.parseInt(mfatiKeys[1]) > yesterday) continue;
            this.wrapperRedisTemplate.del(mfatiKey);
            log.warn("[REDIS_DELETE] {}", (Object)mfatiKey);
        }
    }

    private boolean checkLimitDay(String workday, String trackingYn, String trackingClose) {
        String[] todays = DateUtil.getDivideDateDefault();
        long today = Long.parseLong(todays[0]);
        long targetDay = Long.parseLong(workday);
        targetDay = "Y".equals(trackingYn) ? (targetDay += Long.parseLong(trackingClose)) : (targetDay += (long)this.statLimitDay);
        return targetDay <= today;
    }
}

