/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.writer;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.config.MNColumn;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SendListModel;
import java.util.HashMap;
import java.util.List;
import javax.batch.runtime.JobExecution;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterJob;
import org.springframework.batch.core.annotation.BeforeJob;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;

@TmsComponent(value="statWriter")
@StepScope
public class StatBasicWriter
implements ItemWriter<SendListModel> {
    private static final Logger log = LoggerFactory.getLogger(StatBasicWriter.class);
    @Autowired
    TmsBatchSqlExecutor<SendListModel> sqlExecutor;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="#{jobParameters['schdId'] ?: 0L}")
    private long schdId;
    @Value(value="#{jobParameters['sendId'] ?: 0L}")
    private long sendId;
    @Value(value="#{jobParameters['channelType']}")
    private String channelType;
    @Value(value="#{jobParameters['workday']}")
    private String workday;
    @Value(value="#{jobParameters['target'] ?: 0L}")
    private long target;
    @Value(value="#{jobParameters['pushed'] ?: 0L}")
    private long pushed;
    protected StepExecution stepExecution;
    SqlSession sqlSession = null;
    StatDao statDao = null;

    @BeforeJob
    public void beforeJob(JobExecution jobExecution) {
        this.sqlSession = this.sqlSessionFactory.openSession(ExecutorType.SIMPLE);
        this.statDao = (StatDao)this.sqlSession.getMapper(StatDao.class);
    }

    @AfterJob
    public void afterJob(JobExecution jobExecution) {
        if (this.sqlSession != null) {
            this.sqlSession.close();
        }
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void write(List<? extends SendListModel> items) {
        long endDb;
        long startDb;
        SqlSession sqlSession;
        long start;
        block13: {
            start = System.currentTimeMillis();
            log.info("[JOB_WRITER] START insertSendListFlag, updateStatInfo. schdId {}, selected size:{}", (Object)this.schdId, (Object)items.size());
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.SIMPLE);
            StatDao statDao = (StatDao)sqlSession.getMapper(StatDao.class);
            List<? extends SendListModel> resultList = items;
            try {
                long startDb2 = System.currentTimeMillis();
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.StatDao.insertSendListFlag", resultList, false);
                long endDb2 = System.currentTimeMillis();
                log.info("[QUERY] batch insertSendListFlag. sendId:{}, schdId:{}, size:{} END ============[{}] seconds", new Object[]{this.sendId, this.schdId, resultList.size(), (double)(endDb2 - startDb2) / 1000.0});
            }
            catch (Exception e) {
                log.error("Bulk insert Error schdId:{}===============================", (Object)this.schdId);
                log.error("print stack trace", (Throwable)e);
                long startDb3 = System.currentTimeMillis();
                for (SendListModel result : resultList) {
                    try {
                        statDao.insertSendListFlag(result);
                    }
                    catch (Exception e1) {
                        log.error("Single insert Error : {}, {}", (Object)result.toLogString(), (Object)e1);
                    }
                }
                long endDb3 = System.currentTimeMillis();
                log.info("[QUERY] single insertSendListFlag sendId:{}, schdId:{}, size:{} END ============[{}] seconds", new Object[]{this.sendId, this.schdId, resultList.size(), (double)(endDb3 - startDb3) / 1000.0});
            }
            long filterCnt = this.stepExecution.getExecutionContext().getLong("STAT_FILTER_CNT", 0L);
            long exceptCnt = this.stepExecution.getExecutionContext().getLong("STAT_EXCEPT_CNT", 0L);
            long successCnt = this.stepExecution.getExecutionContext().getLong("STAT_SUCCESS_CNT", 0L);
            long failCnt = this.stepExecution.getExecutionContext().getLong("STAT_FAIL_CNT", 0L);
            long openCnt = this.stepExecution.getExecutionContext().getLong("STAT_OPEN_CNT", 0L);
            long clickCnt = this.stepExecution.getExecutionContext().getLong("STAT_CLICK_CNT", 0L);
            long receivedSuccessCnt = this.stepExecution.getExecutionContext().getLong("STAT_RECEIVED_SUCCESS_CNT", 0L);
            long receivedFailCnt = this.stepExecution.getExecutionContext().getLong("STAT_RECEIVED_FAIL_CNT", 0L);
            long switchCnt = this.stepExecution.getExecutionContext().getLong("STAT_SWITCH_CNT", 0L);
            HashMap<String, Long> statMap = new HashMap<String, Long>();
            statMap.put("SEND_ID", this.sendId);
            statMap.put("SCHD_ID", this.schdId);
            statMap.put("FILTER_CNT", filterCnt);
            statMap.put("SUCCESS_CNT", successCnt);
            statMap.put("FAIL_CNT", failCnt);
            statMap.put("OPEN_CNT", openCnt);
            statMap.put("CLICK_CNT", clickCnt);
            statMap.put("EXCEPT_CNT", exceptCnt);
            statMap.put("RECEIVED_SUCCESS_CNT", receivedSuccessCnt);
            statMap.put("RECEIVED_FAIL_CNT", receivedFailCnt);
            statMap.put("SWITCHED_CNT", switchCnt);
            statMap.put(MNColumn.HAS_SEND_LIST_YN, 1L);
            startDb = System.currentTimeMillis();
            try {
                statDao.updateStatInfo(statMap);
                if (statMap == null) break block13;
                statMap.clear();
            }
            catch (DuplicateKeyException dupEx) {
                block14: {
                    statDao.updateStatInfo(statMap);
                    if (statMap == null) break block14;
                    statMap.clear();
                }
                endDb = System.currentTimeMillis();
                log.info("[QUERY] updateStatInfo sendId{}, schdId:{} END ============[{}] seconds", new Object[]{this.sendId, this.schdId, (double)(endDb - startDb) / 1000.0});
                this.stepExecution.getExecutionContext().putLong("STAT_FILTER_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_EXCEPT_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_SUCCESS_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_FAIL_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_OPEN_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_CLICK_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_SUCCESS_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_FAIL_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_SWITCH_CNT", 0L);
            }
            catch (Exception e) {
                block15: {
                    log.error("updateStatInfo Error : sendId:{} schdId:{}, e:{}", new Object[]{this.sendId, this.schdId, e});
                    if (statMap == null) break block15;
                    statMap.clear();
                    {
                        catch (Throwable throwable) {
                            if (statMap != null) {
                                statMap.clear();
                            }
                            long endDb4 = System.currentTimeMillis();
                            log.info("[QUERY] updateStatInfo sendId{}, schdId:{} END ============[{}] seconds", new Object[]{this.sendId, this.schdId, (double)(endDb4 - startDb) / 1000.0});
                            this.stepExecution.getExecutionContext().putLong("STAT_FILTER_CNT", 0L);
                            this.stepExecution.getExecutionContext().putLong("STAT_EXCEPT_CNT", 0L);
                            this.stepExecution.getExecutionContext().putLong("STAT_SUCCESS_CNT", 0L);
                            this.stepExecution.getExecutionContext().putLong("STAT_FAIL_CNT", 0L);
                            this.stepExecution.getExecutionContext().putLong("STAT_OPEN_CNT", 0L);
                            this.stepExecution.getExecutionContext().putLong("STAT_CLICK_CNT", 0L);
                            this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_SUCCESS_CNT", 0L);
                            this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_FAIL_CNT", 0L);
                            this.stepExecution.getExecutionContext().putLong("STAT_SWITCH_CNT", 0L);
                            throw throwable;
                        }
                    }
                }
                endDb = System.currentTimeMillis();
                log.info("[QUERY] updateStatInfo sendId{}, schdId:{} END ============[{}] seconds", new Object[]{this.sendId, this.schdId, (double)(endDb - startDb) / 1000.0});
                this.stepExecution.getExecutionContext().putLong("STAT_FILTER_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_EXCEPT_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_SUCCESS_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_FAIL_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_OPEN_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_CLICK_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_SUCCESS_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_FAIL_CNT", 0L);
                this.stepExecution.getExecutionContext().putLong("STAT_SWITCH_CNT", 0L);
            }
        }
        endDb = System.currentTimeMillis();
        log.info("[QUERY] updateStatInfo sendId{}, schdId:{} END ============[{}] seconds", new Object[]{this.sendId, this.schdId, (double)(endDb - startDb) / 1000.0});
        this.stepExecution.getExecutionContext().putLong("STAT_FILTER_CNT", 0L);
        this.stepExecution.getExecutionContext().putLong("STAT_EXCEPT_CNT", 0L);
        this.stepExecution.getExecutionContext().putLong("STAT_SUCCESS_CNT", 0L);
        this.stepExecution.getExecutionContext().putLong("STAT_FAIL_CNT", 0L);
        this.stepExecution.getExecutionContext().putLong("STAT_OPEN_CNT", 0L);
        this.stepExecution.getExecutionContext().putLong("STAT_CLICK_CNT", 0L);
        this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_SUCCESS_CNT", 0L);
        this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_FAIL_CNT", 0L);
        this.stepExecution.getExecutionContext().putLong("STAT_SWITCH_CNT", 0L);
        if (sqlSession != null) {
            sqlSession.commit(true);
            sqlSession.close();
        }
        long end = System.currentTimeMillis();
        log.info("[JOB_WRITER] END insertSendListFlag, updateStatInfo. schdId {},size:{} [{}] seconds", new Object[]{this.schdId, items.size(), (double)(end - start) / 1000.0});
    }

    private String makeWorkdayHour(String eventTime) {
        if (eventTime != null && !"".equals(eventTime) && eventTime.length() >= 10) {
            return eventTime.substring(0, 10);
        }
        return null;
    }
}

