/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.writer;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.manager.config.MNSystemErrorCode;
import com.humuson.tms.manager.repository.dao.CleanRdbDao;
import com.humuson.tms.manager.repository.model.SendListModel;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="cleanRecordWebWriter")
@StepScope
public class CleanRecordWebBasicWriter
implements ItemWriter<SendListModel> {
    private static final Logger log = LoggerFactory.getLogger(CleanRecordWebBasicWriter.class);
    @Autowired
    TmsBatchSqlExecutor<SendListModel> sqlExecutor;
    @Autowired
    SqlSessionFactory sqlSessionFactory;

    @BeforeStep
    public void before() {
    }

    public void write(List<? extends SendListModel> items) {
        log.info("[JOB_WRITER] START items cnt {}", (Object)items.size());
        SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.SIMPLE);
        CleanRdbDao cleanRdbDao = (CleanRdbDao)sqlSession.getMapper(CleanRdbDao.class);
        List<? extends SendListModel> resultList = items;
        try {
            this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.CleanRdbDao.deleteRecordWebResult", resultList, false);
        }
        catch (Exception e) {
            log.error(MNSystemErrorCode.ERR_4069.makeLogMsg(this), (Object)e.getMessage(), (Object)e);
            for (SendListModel sendListModel : resultList) {
                try {
                    cleanRdbDao.deleteRecordWebResult(sendListModel);
                }
                catch (Exception e1) {
                    log.error(MNSystemErrorCode.ERR_4070.makeLogMsg(this), new Object[]{sendListModel.getSchdId(), sendListModel.getMemberId(), sendListModel.getMemberIdSeq(), e.getMessage(), e});
                }
            }
        }
        if (sqlSession != null) {
            sqlSession.commit(true);
            sqlSession.close();
        }
        log.info("[JOB_WRITER] END");
    }
}

