/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.task;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.repository.dao.MonitorSendDao;
import com.humuson.tms.manager.repository.dao.ResultDao;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SendListModel;
import com.humuson.tms.manager.stat.Stat;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent(value="statTasklet")
@StepScope
public class StatBasicTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(StatBasicTasklet.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    Stat statService;
    @Autowired
    StatDao statDao;
    @Autowired
    ResultDao resultDao;
    @Autowired
    MonitorSendDao monitorSendDao;
    @Autowired
    TmsBatchSqlExecutor<SendListModel> sqlExecutor;
    @Value(value="#{jobParameters['schdId'] ?: 0L}")
    private long schdId;
    @Value(value="#{jobParameters['sendId'] ?: 0L}")
    private long sendId;
    @Value(value="#{jobParameters['channelType']}")
    private String channelType;
    @Value(value="#{jobParameters['workday']}")
    private String workday;
    @Value(value="#{jobParameters['applyMgFlag']}")
    private String applyMgFlag;
    @Value(value="${tms.manager.proc-stat.reader-page-size}")
    private int pageSize;

    public RepeatStatus execute(StepContribution arg0, ChunkContext arg1) throws Exception {
        log.info("[StatBasicTasklet] applyMgFlag {} schdId {} sendId {} channelType {} workday {}", new Object[]{this.applyMgFlag, this.schdId, this.sendId, this.channelType, this.workday});
        if ("Y".equals(this.applyMgFlag)) {
            List<String> targetSeqList = this.monitorSendDao.selectTargetSeqBySchdId(this.sendId, this.schdId);
            String nowDate = DateUtil.getFullDateDefaultFormat();
            String tlistKey = null;
            for (String targetSeqStr : targetSeqList) {
                tlistKey = "TLIST:" + this.schdId + ":" + targetSeqStr;
                log.info("[StatBasicTasklet] tlistKey {}", (Object)tlistKey);
                Map tlistMap = this.wrapperRedisTemplate.hgetAllString(tlistKey);
                if (tlistMap != null && tlistMap.size() > 0) {
                    log.info("[StatBasicTasklet] TLIST size {} ", (Object)tlistMap.size());
                    int filterCnt = 0;
                    ArrayList<SendListModel> sendList = new ArrayList<SendListModel>();
                    for (String tlistField : tlistMap.keySet()) {
                        String tlistValue = (String)tlistMap.get(tlistField);
                        Map tlistValueMap = JsonUtil.getMapFromJson((String)tlistValue);
                        String tlistStatus = (String)tlistValueMap.get("STATUS");
                        if (tlistStatus != null && !"".equals(tlistStatus)) {
                            log.info("tlist {} {} {}", new Object[]{tlistKey, tlistField, tlistStatus});
                            tlistValueMap.put("STATUS", tlistStatus);
                            tlistValueMap.put("END_TIME", nowDate);
                            sendList.add(this.settingResultModel(tlistValueMap));
                            this.wrapperRedisTemplate.hmdel(tlistKey, tlistField);
                            log.warn("[REDIS_DELETE] {} {}", (Object)tlistKey, (Object)tlistField);
                            ++filterCnt;
                        }
                        if (sendList == null || sendList.size() < this.pageSize) continue;
                        this.insertSendListBulk(sendList);
                        sendList.clear();
                    }
                    if (sendList != null && !sendList.isEmpty()) {
                        this.insertSendListBulk(sendList);
                    }
                    if (filterCnt != tlistMap.size()) continue;
                    this.wrapperRedisTemplate.del(tlistKey);
                    log.warn("[REDIS_DELETE] {}", (Object)tlistKey);
                    continue;
                }
                log.info("[StatBasicTasklet] {} is empty", (Object)tlistKey);
            }
        }
        return RepeatStatus.FINISHED;
    }

    private SendListModel settingResultModel(Map<String, String> memberMap) {
        SendListModel.SendListModelBuilder sendListModelBuiler = SendListModel.builder();
        sendListModelBuiler.logType("TMS_SEND_LIST").channelType(this.channelType).workday(this.workday).memberTargetData(memberMap.get("TMS_M_TARGET")).memberId(memberMap.get("MEMBER_ID")).memberIdSeq(memberMap.get("UNIQUE_SEQ")).memberName(memberMap.get("TMS_M_NAME")).domain(memberMap.get("DOMAIN")).schdId(this.schdId).sendId(this.sendId).eventCode(memberMap.get("STATUS")).eventType(Constants.EventType.S.toString()).codeDetail(memberMap.get("ERROR_CODE")).eventTime(memberMap.get("END_TIME")).tmsMEmail(memberMap.get("TMS_M_EMAIL")).tmsMPhone(memberMap.get("TMS_M_PHONE")).tmsMToken(memberMap.get("TMS_M_TOKEN")).deviceId(Long.parseLong(memberMap.get("DEVICE_ID")));
        return sendListModelBuiler.build();
    }

    private void insertSendListBulk(List<SendListModel> sendList) {
        try {
            log.info("[StatBasicTasklet] {} insertSendListBulk sendList size {}", (Object)this.schdId, (Object)sendList.size());
            this.sqlExecutor.batchUpdate("insertSendList", sendList, false);
        }
        catch (Exception e) {
            log.error("Bulk insert Error schdId {}===============================================", (Object)this.schdId);
            log.error("print stack trace", (Throwable)e);
            for (SendListModel result : sendList) {
                try {
                    this.resultDao.insertSendList(result);
                }
                catch (Exception e1) {
                    log.error("Single insert Error : {}, error:{}", (Object)result.toLogString(), (Object)e1);
                }
            }
        }
    }
}

