/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.reader;

import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.repository.model.ResultSendInfoModel;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent(value="sendReader")
@StepScope
public class SendBasicReader
extends MyBatisPagingItemReader<ResultSendInfoModel> {
    private static final Logger log = LoggerFactory.getLogger(SendBasicReader.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="#{jobParameters['sendId'] ?: 0L}")
    private long sendId;
    @Value(value="${tms.manager.proc-send.reader-page-size}")
    private int pageSize;

    @PostConstruct
    public void init() {
        this.setSqlSessionFactory(this.sqlSessionFactory);
        this.setQueryId("com.humuson.tms.manager.repository.dao.SendDao.selectTargetSendList");
        this.setPageSize(this.pageSize);
    }

    @BeforeStep
    public void before() {
    }

    public ResultSendInfoModel read() throws Exception, UnexpectedInputException, ParseException {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("SEND_ID", this.sendId);
        this.setParameterValues(paramMap);
        return (ResultSendInfoModel)super.read();
    }
}

