/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.reader;

import com.humuson.tms.manager.repository.model.LongIdModel;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="cleanAppSessReader")
@StepScope
public class CleanAppSessBasicReader
extends MyBatisPagingItemReader<LongIdModel> {
    private static final Logger log = LoggerFactory.getLogger(CleanAppSessBasicReader.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="${tms.manager.clean.rdb.reader-page-size}")
    private int pageSize;
    @Value(value="${tms.manager.clean.rdb.limit-day}")
    private int limitDay;

    @PostConstruct
    public void init() {
        this.setSqlSessionFactory(this.sqlSessionFactory);
        this.setQueryId("com.humuson.tms.manager.repository.dao.CleanRdbDao.selectCleanAppSess");
        this.setPageSize(this.pageSize);
    }

    @BeforeStep
    public void before() {
    }

    public LongIdModel read() throws Exception, UnexpectedInputException, ParseException {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("DB_INTERVAL", this.limitDay);
        this.setParameterValues(paramMap);
        return (LongIdModel)super.read();
    }
}

