/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.processor;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.repository.model.SendListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;

@TmsComponent(value="statProcessor")
@StepScope
public class StatBasicProcessor
implements ItemProcessor<SendListModel, SendListModel> {
    private static final Logger log = LoggerFactory.getLogger(StatBasicProcessor.class);
    protected StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public SendListModel process(SendListModel slm) throws Exception {
        String eventCode = slm.getEventType();
        String resultCode = slm.getEventCode();
        String codeDetail = slm.getCodeDetail();
        long filterCnt = this.stepExecution.getExecutionContext().getLong("STAT_FILTER_CNT", 0L);
        long exceptCnt = this.stepExecution.getExecutionContext().getLong("STAT_EXCEPT_CNT", 0L);
        long successCnt = this.stepExecution.getExecutionContext().getLong("STAT_SUCCESS_CNT", 0L);
        long failCnt = this.stepExecution.getExecutionContext().getLong("STAT_FAIL_CNT", 0L);
        long openCnt = this.stepExecution.getExecutionContext().getLong("STAT_OPEN_CNT", 0L);
        long clickCnt = this.stepExecution.getExecutionContext().getLong("STAT_CLICK_CNT", 0L);
        long receivedSuccessCnt = this.stepExecution.getExecutionContext().getLong("STAT_RECEIVED_SUCCESS_CNT", 0L);
        long receivedFailCnt = this.stepExecution.getExecutionContext().getLong("STAT_RECEIVED_FAIL_CNT", 0L);
        long switchCnt = this.stepExecution.getExecutionContext().getLong("STAT_SWITCH_CNT", 0L);
        if (Constants.EventType.S.toString().equalsIgnoreCase(eventCode)) {
            if ("30".equals(resultCode)) {
                log.error("[TLIST_REQ_SEND][{}] {} {}", new Object[]{"30", slm.getMemberId(), slm.getLogDetail()});
            } else if ("01".equals(resultCode)) {
                ++successCnt;
            } else if ("51".equals(resultCode) || "52".equals(resultCode) || "50".equals(resultCode) || "10".equals(resultCode) || "61".equals(resultCode) || "55".equals(resultCode) || "20".equals(resultCode)) {
                ++filterCnt;
            } else if ("11".equalsIgnoreCase(resultCode) || "12".equalsIgnoreCase(resultCode)) {
                ++exceptCnt;
            } else {
                ++failCnt;
            }
            if ("APNS".equals(slm.getDomain())) {
                if ("01".equalsIgnoreCase(resultCode)) {
                    ++receivedSuccessCnt;
                } else if (codeDetail.indexOf("CT1") <= -1 && codeDetail.indexOf("CT5") <= -1 && codeDetail.indexOf("MP0") <= -1 && codeDetail.indexOf("MP1") <= -1 && codeDetail.indexOf("CT6") <= -1 && codeDetail.indexOf("CT7") <= -1 && codeDetail.indexOf("MP6") <= -1 && codeDetail.indexOf("MP7") <= -1 && codeDetail.indexOf("TMS6") <= -1 && codeDetail.indexOf("TMS7") <= -1 && codeDetail.indexOf("TMS9") <= -1 && codeDetail.indexOf("TMS4") <= -1) {
                    ++receivedFailCnt;
                }
            }
        } else if (Constants.EventType.O.toString().equalsIgnoreCase(eventCode)) {
            ++openCnt;
        } else if (Constants.EventType.C.toString().equalsIgnoreCase(eventCode)) {
            ++clickCnt;
        } else if (Constants.EventType.Q.toString().equalsIgnoreCase(eventCode)) {
            if ("01".equalsIgnoreCase(resultCode)) {
                --failCnt;
                ++successCnt;
            }
        } else if (Constants.EventType.R.toString().equalsIgnoreCase(eventCode)) {
            if ("01".equalsIgnoreCase(resultCode)) {
                ++receivedSuccessCnt;
            } else {
                ++receivedFailCnt;
            }
            if (slm.getEventInfo2() != null && slm.getChannelType().equalsIgnoreCase(Constants.ChannelType.KA.toString())) {
                ++switchCnt;
            }
        } else {
            log.error("[StatError] MemberId {} eventCode {}", (Object)slm.getMemberId(), (Object)eventCode);
        }
        this.stepExecution.getExecutionContext().putLong("STAT_FILTER_CNT", filterCnt);
        this.stepExecution.getExecutionContext().putLong("STAT_EXCEPT_CNT", exceptCnt);
        this.stepExecution.getExecutionContext().putLong("STAT_SUCCESS_CNT", successCnt);
        this.stepExecution.getExecutionContext().putLong("STAT_FAIL_CNT", failCnt);
        this.stepExecution.getExecutionContext().putLong("STAT_OPEN_CNT", openCnt);
        this.stepExecution.getExecutionContext().putLong("STAT_CLICK_CNT", clickCnt);
        this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_SUCCESS_CNT", receivedSuccessCnt);
        this.stepExecution.getExecutionContext().putLong("STAT_RECEIVED_FAIL_CNT", receivedFailCnt);
        this.stepExecution.getExecutionContext().putLong("STAT_SWITCH_CNT", switchCnt);
        return slm;
    }
}

