/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ResultSendInfoJobListener
extends JobExecutionListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(ResultSendInfoJobListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterJob(JobExecution jobExecution) {
        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            // empty if block
        }
        try {
            long startTime = jobExecution.getJobParameters().getLong("time");
            log.info("[JOB] END job id {}  {} state {} END [{}] seconds", new Object[]{jobExecution.getId(), jobExecution.getStatus(), System.currentTimeMillis() - startTime});
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        log.info("[JOB] START job id {} START", (Object)jobExecution.getId());
    }
}

